/*
 * Decompiled with CFR 0.152.
 */
package top.mao196.calcobject.obj;

import top.mao196.calcobject.obj.CalcType;
import top.mao196.calcobject.strategy.CalcStrategy;
import top.mao196.calcobject.strategy.CalcStrategyHolder;
import top.mao196.calcobject.strategy.DefaultCalcStrategy;

public abstract class CalcObject {
    private static CalcStrategy globalCalcStrategy = new DefaultCalcStrategy();

    public static void setGlobalCalcStrategy(CalcStrategy globalCalcStrategy) {
        CalcObject.globalCalcStrategy = globalCalcStrategy;
    }

    public static CalcStrategy getGlobalCalcStrategy() {
        return globalCalcStrategy;
    }

    public CalcStrategy getCalcStrategy() {
        CalcStrategy calcStrategyThreadLocal = CalcStrategyHolder.getCalcStrategyThreadLocal();
        if (calcStrategyThreadLocal != null) {
            return calcStrategyThreadLocal;
        }
        return globalCalcStrategy;
    }

    public abstract Object getValue();

    public abstract CalcType getCalcType();

    public int compare(CalcObject other) {
        return this.getCalcStrategy().compare(this, other);
    }

    public boolean eq(CalcObject other) {
        return this.getCalcStrategy().eq(this, other);
    }

    public CalcObject add(CalcObject other) {
        return this.getCalcStrategy().add(this, other);
    }

    public CalcObject sub(CalcObject other) {
        return this.getCalcStrategy().sub(this, other);
    }

    public CalcObject div(CalcObject other) {
        return this.getCalcStrategy().div(this, other);
    }

    public CalcObject multi(CalcObject other) {
        return this.getCalcStrategy().multi(this, other);
    }

    public CalcObject neg() {
        return this.getCalcStrategy().neg(this);
    }

    public CalcObject mod(CalcObject other) {
        return this.getCalcStrategy().mod(this, other);
    }

    public int compare(CalcObject other, CalcStrategy calcStrategy) {
        return calcStrategy.compare(this, other);
    }

    public boolean eq(CalcObject other, CalcStrategy calcStrategy) {
        return calcStrategy.eq(this, other);
    }

    public CalcObject add(CalcObject other, CalcStrategy calcStrategy) {
        return calcStrategy.add(this, other);
    }

    public CalcObject sub(CalcObject other, CalcStrategy calcStrategy) {
        return calcStrategy.sub(this, other);
    }

    public CalcObject div(CalcObject other, CalcStrategy calcStrategy) {
        return calcStrategy.div(this, other);
    }

    public CalcObject multi(CalcObject other, CalcStrategy calcStrategy) {
        return calcStrategy.multi(this, other);
    }

    public CalcObject neg(CalcStrategy calcStrategy) {
        return calcStrategy.neg(this);
    }

    public CalcObject mod(CalcObject other, CalcStrategy calcStrategy) {
        return calcStrategy.mod(this, other);
    }

    public String toString() {
        Object val = this.getValue();
        return "<" + (Object)((Object)this.getCalcType()) + ", " + val + ">";
    }
}

