/*
 * Decompiled with CFR 0.152.
 */
package top.mao196.calcobject.strategy;

import cn.hutool.core.collection.CollUtil;
import java.math.RoundingMode;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import top.mao196.calcobject.ex.CompareNotSupportedException;
import top.mao196.calcobject.ex.ExpressionRuntimeException;
import top.mao196.calcobject.obj.CalcBigDecimal;
import top.mao196.calcobject.obj.CalcBigInteger;
import top.mao196.calcobject.obj.CalcBoolean;
import top.mao196.calcobject.obj.CalcDate;
import top.mao196.calcobject.obj.CalcDateTime;
import top.mao196.calcobject.obj.CalcDouble;
import top.mao196.calcobject.obj.CalcDuration;
import top.mao196.calcobject.obj.CalcInteger;
import top.mao196.calcobject.obj.CalcLong;
import top.mao196.calcobject.obj.CalcNull;
import top.mao196.calcobject.obj.CalcNumber;
import top.mao196.calcobject.obj.CalcObject;
import top.mao196.calcobject.obj.CalcString;
import top.mao196.calcobject.obj.CalcType;
import top.mao196.calcobject.strategy.CalcStrategy;

public class DefaultCalcStrategy
implements CalcStrategy {
    protected EnumSet<CalcType> numberType = EnumSet.of(CalcType.BIG_DECIMAL, CalcType.BIG_INTEGER, CalcType.DOUBLE, CalcType.INTEGER, CalcType.LONG);
    protected List<CalcType> numberTypeOrder = CollUtil.newArrayList((Object[])new CalcType[]{CalcType.INTEGER, CalcType.LONG, CalcType.BIG_INTEGER, CalcType.BIG_DECIMAL, CalcType.DOUBLE});
    protected RoundingMode roundingMode = RoundingMode.HALF_EVEN;

    @Override
    public CalcObject add(CalcObject a, CalcObject b) {
        boolean isNumberA = this.isNumber(a);
        boolean isNumberB = this.isNumber(b);
        if (this.isNull(a) && this.isNull(b)) {
            return CalcNull.instance();
        }
        if (this.isNull(a)) {
            return b;
        }
        if (this.isNull(b)) {
            return a;
        }
        if (isNumberA && isNumberB) {
            CalcNumber a1 = (CalcNumber)a;
            CalcNumber b1 = (CalcNumber)b;
            CalcType calcType = this.getNumberCalcType(a1, (CalcNumber)b);
            if (calcType == CalcType.INTEGER) {
                return CalcInteger.valueOf(a1.intValue() + b1.intValue());
            }
            if (calcType == CalcType.LONG) {
                return CalcLong.valueOf(a1.longValue() + b1.longValue());
            }
            if (calcType == CalcType.BIG_INTEGER) {
                return CalcBigInteger.valueOf(a1.bigInteger().add(b1.bigInteger()));
            }
            if (calcType == CalcType.BIG_DECIMAL) {
                return CalcBigDecimal.valueOf(a1.bigDecimal().add(b1.bigDecimal()));
            }
            if (calcType == CalcType.DOUBLE) {
                return CalcDouble.valueOf(a1.doubleValue() + b1.doubleValue());
            }
        }
        throw new ExpressionRuntimeException("Could not sub " + a + " with " + b);
    }

    @Override
    public CalcObject sub(CalcObject a, CalcObject b) {
        boolean isNumberA = this.isNumber(a);
        boolean isNumberB = this.isNumber(b);
        if (this.isNull(a) && this.isNull(b)) {
            return CalcNull.instance();
        }
        if (this.isNull(a) && isNumberB) {
            return this.neg(b);
        }
        if (isNumberA && this.isNull(b)) {
            return a;
        }
        if (isNumberA && isNumberB) {
            CalcNumber a1 = (CalcNumber)a;
            CalcNumber b1 = (CalcNumber)b;
            CalcType calcType = this.getNumberCalcType(a1, (CalcNumber)b);
            if (calcType == CalcType.INTEGER) {
                return CalcInteger.valueOf(a1.intValue() - b1.intValue());
            }
            if (calcType == CalcType.LONG) {
                return CalcLong.valueOf(a1.longValue() - b1.longValue());
            }
            if (calcType == CalcType.BIG_INTEGER) {
                return CalcBigInteger.valueOf(a1.bigInteger().subtract(b1.bigInteger()));
            }
            if (calcType == CalcType.BIG_DECIMAL) {
                return CalcBigDecimal.valueOf(a1.bigDecimal().subtract(b1.bigDecimal()));
            }
            if (calcType == CalcType.DOUBLE) {
                return CalcDouble.valueOf(a1.doubleValue() - b1.doubleValue());
            }
        }
        throw new ExpressionRuntimeException("Could not sub " + a + " with " + b);
    }

    @Override
    public CalcObject multi(CalcObject a, CalcObject b) {
        boolean isNumberA = this.isNumber(a);
        boolean isNumberB = this.isNumber(b);
        if (this.isNull(a) || this.isNull(b)) {
            return CalcNull.instance();
        }
        if (isNumberA && isNumberB) {
            CalcNumber a1 = (CalcNumber)a;
            CalcNumber b1 = (CalcNumber)b;
            CalcType calcType = this.getNumberCalcType(a1, (CalcNumber)b);
            if (calcType == CalcType.INTEGER) {
                return CalcInteger.valueOf(a1.intValue() * b1.intValue());
            }
            if (calcType == CalcType.LONG) {
                return CalcLong.valueOf(a1.longValue() * b1.longValue());
            }
            if (calcType == CalcType.BIG_INTEGER) {
                return CalcBigInteger.valueOf(a1.bigInteger().multiply(b1.bigInteger()));
            }
            if (calcType == CalcType.BIG_DECIMAL) {
                return CalcBigDecimal.valueOf(a1.bigDecimal().multiply(b1.bigDecimal()));
            }
            if (calcType == CalcType.DOUBLE) {
                return CalcDouble.valueOf(a1.doubleValue() * b1.doubleValue());
            }
        }
        throw new ExpressionRuntimeException("Could not multi " + a + " with " + b);
    }

    @Override
    public CalcObject div(CalcObject a, CalcObject b) {
        boolean isNumberA = this.isNumber(a);
        boolean isNumberB = this.isNumber(b);
        if (this.isNull(b) || isNumberB && ((CalcNumber)b).isZero()) {
            return CalcNull.instance();
        }
        if (this.isNull(a) && isNumberB) {
            return a;
        }
        if (isNumberA && isNumberB) {
            CalcNumber a1 = (CalcNumber)a;
            CalcNumber b1 = (CalcNumber)b;
            if (b1.isZero()) {
                throw new ExpressionRuntimeException("Could not div " + a + " with " + b);
            }
            CalcType calcType = this.getNumberCalcType(a1, (CalcNumber)b);
            if (calcType == CalcType.INTEGER) {
                return CalcInteger.valueOf(a1.intValue() / b1.intValue());
            }
            if (calcType == CalcType.LONG) {
                return CalcLong.valueOf(a1.longValue() / b1.longValue());
            }
            if (calcType == CalcType.BIG_INTEGER) {
                return CalcBigInteger.valueOf(a1.bigInteger().divide(b1.bigInteger()));
            }
            if (calcType == CalcType.BIG_DECIMAL) {
                return CalcBigDecimal.valueOf(a1.bigDecimal().divide(b1.bigDecimal(), this.roundingMode));
            }
            if (calcType == CalcType.DOUBLE) {
                return CalcDouble.valueOf(a1.doubleValue() / b1.doubleValue());
            }
        }
        throw new ExpressionRuntimeException("Could not div " + a + " with " + b);
    }

    @Override
    public CalcObject mod(CalcObject a, CalcObject b) {
        boolean isNumberA = this.isNumber(a);
        boolean isNumberB = this.isNumber(b);
        if (this.isNull(a) && isNumberB) {
            return a;
        }
        if (isNumberA && isNumberB) {
            CalcNumber a1 = (CalcNumber)a;
            CalcNumber b1 = (CalcNumber)b;
            if (b1.isZero()) {
                throw new ExpressionRuntimeException("Could not div " + a + " with " + b);
            }
            CalcType calcType = this.getNumberCalcType(a1, (CalcNumber)b);
            if (calcType == CalcType.INTEGER) {
                return CalcInteger.valueOf(a1.intValue() % b1.intValue());
            }
            if (calcType == CalcType.LONG) {
                return CalcLong.valueOf(a1.longValue() % b1.longValue());
            }
            if (calcType == CalcType.BIG_INTEGER) {
                return CalcBigInteger.valueOf(a1.bigInteger().mod(b1.bigInteger()));
            }
            if (calcType == CalcType.BIG_DECIMAL) {
                return CalcBigDecimal.valueOf(a1.bigDecimal().remainder(b1.bigDecimal()));
            }
            if (calcType == CalcType.DOUBLE) {
                return CalcDouble.valueOf(a1.doubleValue() % b1.doubleValue());
            }
        }
        throw new ExpressionRuntimeException("Could not mod " + a + " with " + b);
    }

    public CalcType getNumberCalcType(CalcNumber a, CalcNumber b) {
        CalcType aCalcType = a.getCalcType();
        CalcType bCalcType = b.getCalcType();
        return this.numberTypeOrder.get(Math.max(this.numberTypeOrder.indexOf((Object)aCalcType), this.numberTypeOrder.indexOf((Object)bCalcType)));
    }

    @Override
    public CalcObject neg(CalcObject a) {
        if (this.isNull(a)) {
            return a;
        }
        if (this.isNumber(a)) {
            switch (a.getCalcType()) {
                case DOUBLE: {
                    return CalcDouble.valueOf(-((CalcDouble)a).doubleValue());
                }
            }
            switch (a.getCalcType()) {
                case DOUBLE: {
                    return CalcDouble.valueOf(-((CalcDouble)a).doubleValue());
                }
                case BIG_DECIMAL: {
                    return CalcBigDecimal.valueOf(((CalcBigDecimal)a).bigDecimal().negate());
                }
                case INTEGER: {
                    return CalcInteger.valueOf(-((CalcInteger)a).intValue());
                }
                case LONG: {
                    return CalcLong.valueOf(-((CalcLong)a).longValue());
                }
                case BIG_INTEGER: {
                    return CalcBigInteger.valueOf(((CalcBigInteger)a).bigInteger().negate());
                }
            }
            throw new ExpressionRuntimeException("Could not neg " + a);
        }
        if (a.getCalcType() == CalcType.BOOLEAN) {
            return CalcBoolean.valueOf(!((CalcBoolean)a).booleanValue());
        }
        throw new ExpressionRuntimeException("Could not neg " + a);
    }

    @Override
    public int compare(CalcObject a, CalcObject b) {
        boolean isNumberCompareB;
        if (a == b) {
            return 0;
        }
        CalcType aCalcType = a.getCalcType();
        CalcType bCalcType = b.getCalcType();
        if (this.isError(a)) {
            return 1;
        }
        if (this.isError(b)) {
            return -1;
        }
        boolean isNumberCompareA = this.isNumber(a) || this.isNull(a);
        boolean bl = isNumberCompareB = this.isNumber(b) || this.isNull(b);
        if (isNumberCompareA && isNumberCompareB) {
            if (aCalcType == CalcType.NULL) {
                a = CalcInteger.valueOf(0);
            }
            if (bCalcType == CalcType.NULL) {
                b = CalcInteger.valueOf(0);
            }
            Number numberA = ((CalcNumber)a).getNumber();
            Number numberB = ((CalcNumber)b).getNumber();
            return Double.compare(numberA.doubleValue(), numberB.doubleValue());
        }
        if (aCalcType == bCalcType) {
            if (aCalcType == CalcType.BOOLEAN) {
                return Boolean.compare(((CalcBoolean)a).booleanValue(), ((CalcBoolean)b).booleanValue());
            }
            if (aCalcType == CalcType.STRING) {
                return ((CalcString)a).getStringValue().compareTo(((CalcString)b).getStringValue());
            }
            if (aCalcType == CalcType.DATE_TIME) {
                return ((CalcDateTime)a).localDateTimeValue().compareTo(((CalcDateTime)b).localDateTimeValue());
            }
            if (aCalcType == CalcType.DURATION) {
                return ((CalcDuration)a).durationValue().compareTo(((CalcDuration)b).durationValue());
            }
            if (aCalcType == CalcType.DATE) {
                return ((CalcDate)a).localDateValue().compareTo(((CalcDate)b).localDateValue());
            }
        }
        throw new CompareNotSupportedException("Could not compare " + a + " with " + b);
    }

    @Override
    public boolean eq(CalcObject a, CalcObject b) {
        CalcType bCalcType;
        if (a == b) {
            return true;
        }
        CalcType aCalcType = a.getCalcType();
        if (aCalcType == (bCalcType = b.getCalcType())) {
            return Objects.equals(a.getValue(), b.getValue());
        }
        return false;
    }

    protected boolean isNumber(CalcObject obj) {
        return this.numberType.contains((Object)obj.getCalcType());
    }

    protected boolean isNull(CalcObject obj) {
        return obj.getCalcType() == CalcType.NULL;
    }

    protected boolean isError(CalcObject obj) {
        return obj.getCalcType() == CalcType.ERROR;
    }
}

