/*
 * Decompiled with CFR 0.152.
 */
package top.mao196.calcobject.table;

import cn.hutool.core.lang.Tuple;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import top.mao196.calcobject.table.AggregateFunction;
import top.mao196.calcobject.table.Row;
import top.mao196.calcobject.table.Table;
import top.mao196.calcobject.table.TableTransform;

public class SimpleTableTransform
implements TableTransform {
    private List<String> groupKeys;
    private List<AggregateFunction> measureAggregateFiledList;
    private String tableName;

    @Override
    public Table apply(Table table) {
        Table result = new Table(true, this.groupKeys);
        result.setTableName(this.tableName);
        Map<Tuple, List<Row>> group = table.getRowList().stream().collect(Collectors.groupingBy(x -> {
            Tuple key = x.getKey();
            Object[] keys = new Object[this.groupKeys.size()];
            for (int i = 0; i < this.groupKeys.size(); ++i) {
                keys[i] = key.get(table.getKeyNames().indexOf(this.groupKeys.get(i)));
            }
            return new Tuple(keys);
        }));
        group.forEach((key, rows) -> {
            Row row = new Row((Tuple)key);
            for (AggregateFunction filed : this.measureAggregateFiledList) {
                row.put(filed.getName(), filed.getFunction().apply((List<Row>)rows));
            }
            result.addRow(row);
        });
        return result;
    }

    SimpleTableTransform(List<String> groupKeys, List<AggregateFunction> measureAggregateFiledList, String tableName) {
        this.groupKeys = groupKeys;
        this.measureAggregateFiledList = measureAggregateFiledList;
        this.tableName = tableName;
    }

    public static SimpleTableTransformBuilder builder() {
        return new SimpleTableTransformBuilder();
    }

    public List<String> getGroupKeys() {
        return this.groupKeys;
    }

    public List<AggregateFunction> getMeasureAggregateFiledList() {
        return this.measureAggregateFiledList;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setGroupKeys(List<String> groupKeys) {
        this.groupKeys = groupKeys;
    }

    public void setMeasureAggregateFiledList(List<AggregateFunction> measureAggregateFiledList) {
        this.measureAggregateFiledList = measureAggregateFiledList;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleTableTransform)) {
            return false;
        }
        SimpleTableTransform other = (SimpleTableTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<String> this$groupKeys = this.getGroupKeys();
        List<String> other$groupKeys = other.getGroupKeys();
        if (this$groupKeys == null ? other$groupKeys != null : !((Object)this$groupKeys).equals(other$groupKeys)) {
            return false;
        }
        List<AggregateFunction> this$measureAggregateFiledList = this.getMeasureAggregateFiledList();
        List<AggregateFunction> other$measureAggregateFiledList = other.getMeasureAggregateFiledList();
        if (this$measureAggregateFiledList == null ? other$measureAggregateFiledList != null : !((Object)this$measureAggregateFiledList).equals(other$measureAggregateFiledList)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        return !(this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleTableTransform;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<String> $groupKeys = this.getGroupKeys();
        result = result * 59 + ($groupKeys == null ? 43 : ((Object)$groupKeys).hashCode());
        List<AggregateFunction> $measureAggregateFiledList = this.getMeasureAggregateFiledList();
        result = result * 59 + ($measureAggregateFiledList == null ? 43 : ((Object)$measureAggregateFiledList).hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        return result;
    }

    public String toString() {
        return "SimpleTableTransform(groupKeys=" + this.getGroupKeys() + ", measureAggregateFiledList=" + this.getMeasureAggregateFiledList() + ", tableName=" + this.getTableName() + ")";
    }

    public static class SimpleTableTransformBuilder {
        private List<String> groupKeys;
        private List<AggregateFunction> measureAggregateFiledList;
        private String tableName;

        SimpleTableTransformBuilder() {
        }

        public SimpleTableTransformBuilder groupKeys(List<String> groupKeys) {
            this.groupKeys = groupKeys;
            return this;
        }

        public SimpleTableTransformBuilder measureAggregateFiledList(List<AggregateFunction> measureAggregateFiledList) {
            this.measureAggregateFiledList = measureAggregateFiledList;
            return this;
        }

        public SimpleTableTransformBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public SimpleTableTransform build() {
            return new SimpleTableTransform(this.groupKeys, this.measureAggregateFiledList, this.tableName);
        }

        public String toString() {
            return "SimpleTableTransform.SimpleTableTransformBuilder(groupKeys=" + this.groupKeys + ", measureAggregateFiledList=" + this.measureAggregateFiledList + ", tableName=" + this.tableName + ")";
        }
    }
}

