/*
 * Decompiled with CFR 0.152.
 */
package top.mao196.calcobject.table;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.lang.Tuple;
import cn.hutool.core.util.StrUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import top.mao196.calcobject.obj.CalcObject;
import top.mao196.calcobject.table.Row;
import top.mao196.calcobject.table.TableTransform;

public class Table {
    private String tableName;
    private List<Row> rowList = new ArrayList<Row>();
    private final boolean primaryKey;
    private Map<Tuple, Row> rowsMap = new HashMap<Tuple, Row>();
    private final List<String> keyNames;
    private List<String> measureKeys;

    public Table(boolean primaryKey, List<String> keyNames) {
        this.keyNames = keyNames;
        this.primaryKey = primaryKey;
    }

    public boolean isEmpty() {
        return CollUtil.isEmpty(this.rowList);
    }

    public void addRow(Row row) {
        this.rowList.add(row);
        if (this.primaryKey) {
            this.rowsMap.put(row.getKey(), row);
        }
    }

    public void addRowList(List<Row> rowList) {
        rowList.forEach(this::addRow);
    }

    public Row getRow(Tuple key) {
        if (this.primaryKey) {
            return this.rowsMap.get(key);
        }
        return null;
    }

    public void removeRow(Row row) {
        if (this.primaryKey) {
            this.rowsMap.remove(row.getKey());
        }
        this.rowList.remove(row);
    }

    public boolean removeRowByKey(Tuple key) {
        if (this.primaryKey) {
            boolean b = this.rowsMap.containsKey(key);
            if (!b) {
                return false;
            }
            Row row = this.rowsMap.get(key);
            this.rowsMap.remove(row.getKey());
            this.rowList.remove(row);
            return true;
        }
        return false;
    }

    public boolean containRow(Tuple key) {
        if (this.primaryKey) {
            return this.rowsMap.containsKey(key);
        }
        return false;
    }

    public void foreachRow(Consumer<Row> consumer) {
        this.rowList.forEach(consumer);
    }

    public String summary() {
        String summary = "\u8868\u540d:{} \n\u8868\u7ef4\u5ea6:{} \n\u8868\u884c\u6570:{}\n\u8868\u6570\u636e\u62bd\u6837:\n{} ";
        String sample = this.rowList.stream().limit(10L).map(x -> x.getKey().toString() + ":" + x.getValueMap().entrySet().stream().map(y -> (String)y.getKey() + "=" + ((CalcObject)y.getValue()).getValue()).collect(Collectors.joining(","))).collect(Collectors.joining("\n"));
        return StrUtil.format((CharSequence)summary, (Object[])new Object[]{this.tableName, this.keyNames, this.rowList.size(), sample});
    }

    public String print(int rowLimit, String ... cKeys) {
        return this.rowList.stream().limit(rowLimit).map(x -> {
            ArrayList<Object> context = new ArrayList<Object>();
            for (int i = 0; i < this.keyNames.size(); ++i) {
                context.add(x.getKey().get(i));
            }
            for (String cKey : cKeys) {
                context.add(Objects.toString(x.get(cKey).getValue()));
            }
            return CollUtil.join(context, (CharSequence)"\t");
        }).collect(Collectors.joining("\n"));
    }

    public Pair<List<String>, List<Map<String, Object>>> export(String ... cKeys) {
        ArrayList<String> header = new ArrayList<String>(new ArrayList<String>(this.keyNames));
        Collections.addAll(header, this.selectMetricKeys(cKeys));
        ArrayList data = new ArrayList();
        this.rowList.forEach(x -> {
            LinkedHashMap<String, Object> row = new LinkedHashMap<String, Object>();
            for (int i = 0; i < this.keyNames.size(); ++i) {
                row.put(this.keyNames.get(i), x.getKey().get(i));
            }
            for (String cKey : cKeys) {
                row.put(cKey, x.get(cKey).getValue());
            }
            data.add(row);
        });
        return Pair.of(header, data);
    }

    public Pair<List<String>, List<List<Object>>> export4EasyExcel(String ... cKeys) {
        ArrayList<String> header = new ArrayList<String>(new ArrayList<String>(this.keyNames));
        Collections.addAll(header, this.selectMetricKeys(cKeys));
        ArrayList data = new ArrayList();
        this.rowList.forEach(x -> {
            ArrayList<Object> row = new ArrayList<Object>();
            for (int i = 0; i < this.keyNames.size(); ++i) {
                row.add(x.getKey().get(i));
            }
            for (String cKey : cKeys) {
                row.add(x.get(cKey).getValue());
            }
            data.add(row);
        });
        return Pair.of(header, data);
    }

    private String[] selectMetricKeys(String[] cKeys) {
        if (cKeys == null || cKeys.length == 0) {
            return this.measureKeys.toArray(new String[0]);
        }
        for (String cKey : cKeys) {
            if (this.measureKeys.contains(cKey)) continue;
            throw new IllegalArgumentException("cKeys\u4e2d\u5305\u542b\u7684\u6307\u6807\u540d\u79f0\u4e0d\u5728\u6307\u6807\u5217\u8868\u4e2d");
        }
        return cKeys;
    }

    public Table transform(TableTransform tableTransform) {
        return (Table)tableTransform.apply(this);
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<Row> getRowList() {
        return this.rowList;
    }

    public boolean isPrimaryKey() {
        return this.primaryKey;
    }

    public Map<Tuple, Row> getRowsMap() {
        return this.rowsMap;
    }

    public List<String> getKeyNames() {
        return this.keyNames;
    }

    public List<String> getMeasureKeys() {
        return this.measureKeys;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setRowList(List<Row> rowList) {
        this.rowList = rowList;
    }

    public void setRowsMap(Map<Tuple, Row> rowsMap) {
        this.rowsMap = rowsMap;
    }

    public void setMeasureKeys(List<String> measureKeys) {
        this.measureKeys = measureKeys;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Table)) {
            return false;
        }
        Table other = (Table)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPrimaryKey() != other.isPrimaryKey()) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        List<Row> this$rowList = this.getRowList();
        List<Row> other$rowList = other.getRowList();
        if (this$rowList == null ? other$rowList != null : !((Object)this$rowList).equals(other$rowList)) {
            return false;
        }
        Map<Tuple, Row> this$rowsMap = this.getRowsMap();
        Map<Tuple, Row> other$rowsMap = other.getRowsMap();
        if (this$rowsMap == null ? other$rowsMap != null : !((Object)this$rowsMap).equals(other$rowsMap)) {
            return false;
        }
        List<String> this$keyNames = this.getKeyNames();
        List<String> other$keyNames = other.getKeyNames();
        if (this$keyNames == null ? other$keyNames != null : !((Object)this$keyNames).equals(other$keyNames)) {
            return false;
        }
        List<String> this$measureKeys = this.getMeasureKeys();
        List<String> other$measureKeys = other.getMeasureKeys();
        return !(this$measureKeys == null ? other$measureKeys != null : !((Object)this$measureKeys).equals(other$measureKeys));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Table;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPrimaryKey() ? 79 : 97);
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        List<Row> $rowList = this.getRowList();
        result = result * 59 + ($rowList == null ? 43 : ((Object)$rowList).hashCode());
        Map<Tuple, Row> $rowsMap = this.getRowsMap();
        result = result * 59 + ($rowsMap == null ? 43 : ((Object)$rowsMap).hashCode());
        List<String> $keyNames = this.getKeyNames();
        result = result * 59 + ($keyNames == null ? 43 : ((Object)$keyNames).hashCode());
        List<String> $measureKeys = this.getMeasureKeys();
        result = result * 59 + ($measureKeys == null ? 43 : ((Object)$measureKeys).hashCode());
        return result;
    }

    public String toString() {
        return "Table(tableName=" + this.getTableName() + ", rowList=" + this.getRowList() + ", primaryKey=" + this.isPrimaryKey() + ", rowsMap=" + this.getRowsMap() + ", keyNames=" + this.getKeyNames() + ", measureKeys=" + this.getMeasureKeys() + ")";
    }
}

