/*
 * Decompiled with CFR 0.152.
 */
package top.mao196.calcobject.util;

import cn.hutool.core.convert.Convert;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import top.mao196.calcobject.obj.CalcBigDecimal;
import top.mao196.calcobject.obj.CalcBigInteger;
import top.mao196.calcobject.obj.CalcBoolean;
import top.mao196.calcobject.obj.CalcDate;
import top.mao196.calcobject.obj.CalcDateTime;
import top.mao196.calcobject.obj.CalcDouble;
import top.mao196.calcobject.obj.CalcDuration;
import top.mao196.calcobject.obj.CalcInteger;
import top.mao196.calcobject.obj.CalcLong;
import top.mao196.calcobject.obj.CalcNull;
import top.mao196.calcobject.obj.CalcObject;
import top.mao196.calcobject.obj.CalcString;
import top.mao196.calcobject.obj.CalcType;

public class CalcObjectUtils {
    public static CalcObject toCalcObject(Object obj) {
        if (obj == null) {
            return CalcNull.instance();
        }
        if (obj instanceof CalcObject) {
            return (CalcObject)obj;
        }
        if (obj instanceof Integer) {
            return CalcInteger.valueOf((Integer)obj);
        }
        if (obj instanceof Long) {
            return CalcLong.valueOf((Long)obj);
        }
        if (obj instanceof Float) {
            return CalcDouble.valueOf(((Float)obj).floatValue());
        }
        if (obj instanceof BigDecimal) {
            return CalcBigDecimal.valueOf((BigDecimal)obj);
        }
        if (obj instanceof Double) {
            return CalcDouble.valueOf((Double)obj);
        }
        if (obj instanceof String) {
            return CalcString.valueOf((String)obj);
        }
        if (obj instanceof Boolean) {
            return CalcBoolean.valueOf((Boolean)obj);
        }
        if (obj instanceof Short) {
            return CalcInteger.valueOf(((Short)obj).shortValue());
        }
        if (obj instanceof Byte) {
            return CalcInteger.valueOf(((Byte)obj).byteValue());
        }
        if (obj instanceof BigInteger) {
            return CalcBigInteger.valueOf((BigInteger)obj);
        }
        if (obj instanceof LocalDate) {
            return CalcDate.valueOf((LocalDate)obj);
        }
        if (obj instanceof LocalDateTime) {
            return CalcDateTime.valueOf((LocalDateTime)obj);
        }
        if (obj instanceof CharSequence) {
            return CalcString.valueOf(obj.toString());
        }
        return CalcNull.instance();
    }

    public static CalcObject parse(Object obj, CalcType calcType) {
        if (obj == null) {
            return CalcNull.instance();
        }
        if (obj instanceof CalcObject) {
            obj = ((CalcObject)obj).getValue();
        }
        switch (calcType) {
            case DOUBLE: {
                return CalcObjectUtils.parseDouble(obj);
            }
            case BIG_DECIMAL: {
                return CalcObjectUtils.parseBigDecimal(obj);
            }
            case BIG_INTEGER: {
                return CalcObjectUtils.parseBigInteger(obj);
            }
            case LONG: {
                return CalcObjectUtils.parseLong(obj);
            }
            case INTEGER: {
                return CalcObjectUtils.parseInteger(obj);
            }
            case STRING: {
                return CalcObjectUtils.parseString(obj);
            }
            case BOOLEAN: {
                return CalcObjectUtils.parseBoolean(obj);
            }
            case DATE_TIME: {
                return CalcObjectUtils.parseDateTime(obj);
            }
            case DATE: {
                return CalcObjectUtils.parseDate(obj);
            }
            case DURATION: {
                return CalcObjectUtils.parseDuration(obj);
            }
        }
        return CalcNull.instance();
    }

    public static CalcObject parseDuration(Object obj) {
        if (obj instanceof Duration) {
            return CalcDuration.valueOf((Duration)obj);
        }
        return CalcNull.instance();
    }

    public static CalcObject parseDate(Object obj) {
        if (obj instanceof LocalDate) {
            return CalcDate.valueOf((LocalDate)obj);
        }
        return CalcNull.instance();
    }

    public static CalcObject parseDateTime(Object obj) {
        if (obj instanceof LocalDateTime) {
            return CalcDateTime.valueOf((LocalDateTime)obj);
        }
        return CalcNull.instance();
    }

    public static CalcObject parseBoolean(Object obj) {
        if (obj instanceof Boolean) {
            return CalcBoolean.valueOf((Boolean)obj);
        }
        Boolean value = Convert.toBool((Object)obj);
        if (value == null) {
            return CalcNull.instance();
        }
        return CalcBoolean.valueOf(value);
    }

    public static CalcObject parseString(Object obj) {
        if (obj instanceof CharSequence || obj instanceof Number) {
            return CalcString.valueOf(obj.toString());
        }
        return CalcNull.instance();
    }

    public static CalcObject parseInteger(Object obj) {
        int i;
        if (obj instanceof Integer) {
            i = (Integer)obj;
        } else {
            BigDecimal value = Convert.toBigDecimal((Object)obj);
            if (value == null) {
                return CalcNull.instance();
            }
            i = value.intValue();
        }
        return CalcInteger.valueOf(i);
    }

    public static CalcObject parseBigInteger(Object obj) {
        BigInteger result = null;
        if (obj instanceof BigInteger) {
            result = (BigInteger)obj;
        } else {
            BigDecimal value = Convert.toBigDecimal((Object)obj);
            if (value == null) {
                return CalcNull.instance();
            }
            result = value.toBigInteger();
        }
        return CalcBigInteger.valueOf(result);
    }

    public static CalcObject parseLong(Object obj) {
        long l;
        if (obj instanceof Long) {
            l = (Long)obj;
        } else if (obj instanceof Double) {
            Double d = (Double)obj;
            if (d.isInfinite() || d.isNaN()) {
                return CalcNull.instance();
            }
            l = d.longValue();
        } else {
            BigDecimal value = Convert.toBigDecimal((Object)obj);
            if (value == null) {
                return CalcNull.instance();
            }
            l = value.longValue();
        }
        return CalcLong.valueOf(l);
    }

    public static CalcObject parseBigDecimal(Object obj) {
        BigDecimal result = null;
        if (obj instanceof BigDecimal) {
            result = (BigDecimal)obj;
        } else {
            BigDecimal value = Convert.toBigDecimal((Object)obj);
            if (value == null) {
                return CalcNull.instance();
            }
            result = value;
        }
        return CalcBigDecimal.valueOf(result);
    }

    public static CalcObject parseDouble(Object obj) {
        double d;
        if (obj instanceof Number) {
            d = ((Number)obj).doubleValue();
        } else {
            Double value = Convert.toDouble((Object)obj);
            if (value == null) {
                return CalcNull.instance();
            }
            d = value;
        }
        if (Double.isNaN(d) || Double.isInfinite(d)) {
            return CalcNull.instance();
        }
        return CalcDouble.valueOf(d);
    }

    public static Object unwrap(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof CalcObject) {
            return ((CalcObject)obj).getValue();
        }
        return obj;
    }

    public static <T> T unwrap(Object obj, Class<T> clz) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof CalcObject) {
            obj = ((CalcObject)obj).getValue();
        }
        return (T)Convert.convert(clz, (Object)obj);
    }
}

