/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.maven.aether;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositoryListener;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.MirrorSelector;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.ProxySelector;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.transfer.TransferListener;
import org.eclipse.aether.util.repository.DefaultMirrorSelector;
import org.eclipse.aether.util.repository.DefaultProxySelector;
import top.marchand.maven.aether.factories.ManualRepositorySystemFactory;
import top.marchand.maven.aether.utils.ConsoleRepositoryListener;
import top.marchand.maven.aether.utils.ConsoleTransferListener;

public class AetherBooter {
    static final Map<String, RemoteRepository> KNOWN_REPOS = new HashMap<String, RemoteRepository>();

    public static RepositorySystem newRepositorySystem() {
        return ManualRepositorySystemFactory.newRepositorySystem();
    }

    public static DefaultRepositorySystemSession newRepositorySystemSession(RepositorySystem system, String localRepoLocation) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        LocalRepository localRepo = new LocalRepository(localRepoLocation);
        session.setLocalRepositoryManager(system.newLocalRepositoryManager((RepositorySystemSession)session, localRepo));
        session.setTransferListener((TransferListener)new ConsoleTransferListener());
        session.setRepositoryListener((RepositoryListener)new ConsoleRepositoryListener());
        return session;
    }

    public static List<RemoteRepository> newRepositories(RepositorySystem system, RepositorySystemSession session) {
        ArrayList<RemoteRepository> ret = new ArrayList<RemoteRepository>();
        KNOWN_REPOS.values().forEach(rr -> {
            RemoteRepository mirror = session.getMirrorSelector().getMirror(rr);
            if (mirror != null) {
                ret.add(mirror);
            } else {
                ret.add((RemoteRepository)rr);
            }
        });
        return ret;
    }

    public static void loadLocalMavenSettings(DefaultRepositorySystemSession session) {
        DefaultSettingsBuilder settingsBuilder = new DefaultSettingsBuilderFactory().newInstance();
        SettingsBuildingRequest request = AetherBooter.buildSettingsRequest();
        try {
            SettingsBuildingResult actualSettings = settingsBuilder.build(request);
            DefaultMirrorSelector mirrorSelector = new DefaultMirrorSelector();
            actualSettings.getEffectiveSettings().getMirrors().forEach(mirror -> mirrorSelector.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), true, mirror.getMirrorOf(), null));
            session.setMirrorSelector((MirrorSelector)mirrorSelector);
            DefaultProxySelector proxySelector = new DefaultProxySelector();
            actualSettings.getEffectiveSettings().getProxies().forEach(proxy -> {
                Proxy proxo = new Proxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort());
                proxySelector.add(proxo, proxy.getNonProxyHosts());
            });
            session.setProxySelector((ProxySelector)proxySelector);
        }
        catch (SettingsBuildingException ex) {
            System.err.println("[ERROR] While trying to read maven settings");
            ex.printStackTrace(System.err);
        }
    }

    private static RemoteRepository newCentralRepository() {
        return new RemoteRepository.Builder("central", "default", "http://central.maven.org/maven2/").build();
    }

    private static SettingsBuildingRequest buildSettingsRequest() {
        String path;
        File userHome = new File(System.getProperty("user.home"));
        File userSettings = new File(new File(userHome, ".m2"), "settings.xml");
        File mvnSettings = null;
        String env = System.getenv("M2_HOME");
        if (env == null) {
            env = System.getenv("MVN_HOME");
        }
        if (env == null && (path = System.getenv("PATH")) != null) {
            for (String p : path.split(File.pathSeparator)) {
                File mvnBin;
                File m2conf;
                if (!p.toLowerCase().contains("maven") || !(m2conf = new File(mvnBin = new File(p), "m2.conf")).exists() || !m2conf.isFile()) continue;
                File mvnHome = mvnBin.getParentFile();
                env = mvnHome.getAbsolutePath();
            }
        }
        if (env != null) {
            File mvnHome = new File(env);
            mvnSettings = new File(mvnHome, "settings.xml");
        }
        DefaultSettingsBuildingRequest ret = new DefaultSettingsBuildingRequest();
        if (userSettings.exists() && userSettings.isFile()) {
            ret.setUserSettingsFile(userSettings);
        }
        if (mvnSettings != null && mvnSettings.exists() && mvnSettings.isFile()) {
            ret.setGlobalSettingsFile(mvnSettings);
        }
        return ret;
    }

    public static String getLocalRepositoryPath() {
        File userHome = new File(System.getProperty("user.home"));
        File mvnDir = new File(userHome, ".m2");
        return new File(mvnDir, "repository").getAbsolutePath();
    }

    static {
        RemoteRepository central = AetherBooter.newCentralRepository();
        KNOWN_REPOS.put(central.getId(), central);
    }
}

