/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.maven.plugins;

import java.util.Arrays;
import java.util.function.Function;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import top.marchand.maven.plugins.VersionCalculator;
import top.marchand.maven.plugins.VersionCalculatorException;

@Mojo(name="calculate")
public class VersionCalculatorMavenPlugin
extends AbstractMojo {
    private static final String MAVEN_RELEASE_PLUGIN_RELEASE_VERSION = "releaseVersion";
    private static final String MAVEN_RELEASE_PLUGIN_DEVELOPMENT_VERSION = "developmentVersion";
    public static final String NONE = "NONE";
    @Parameter(defaultValue="${project.version}")
    private String currentVersion;
    @Parameter(defaultValue="NONE")
    private String releaseType;
    @Parameter(defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (NONE.equals(this.releaseType)) {
            return;
        }
        try {
            VersionCalculator versionCalculator = new VersionCalculator(this.currentVersion);
            ReleaseTypeStrategy wrapper = ReleaseTypeStrategy.of(this.releaseType);
            NextRelease next = wrapper.calculateNextRelease(versionCalculator);
            this.logJson(next);
            this.logResults(next);
            this.setMavenReleasePluginProperties(next);
        }
        catch (VersionCalculatorException ex) {
            this.logErrorMessage();
            throw new MojoExecutionException((Throwable)ex);
        }
    }

    private void logErrorMessage() {
        this.getLog().error((CharSequence)("The version you try to release does not match SemVer specification : " + this.currentVersion));
        this.getLog().error((CharSequence)"See https://semver.org/ and adapt your version");
    }

    private void logResults(NextRelease next) {
        this.getLog().info((CharSequence)("release: " + next.release));
        this.getLog().info((CharSequence)("snapshot: " + next.snapshot));
    }

    private void logJson(NextRelease next) {
        String result = "{\"release\":\"" + next.release + "\",\"nextSnapshot\":\"" + next.snapshot + "\"}";
        System.out.println(result);
    }

    private void setMavenReleasePluginProperties(NextRelease next) {
        this.project.getProperties().setProperty(MAVEN_RELEASE_PLUGIN_RELEASE_VERSION, next.release);
        this.project.getProperties().setProperty(MAVEN_RELEASE_PLUGIN_DEVELOPMENT_VERSION, next.snapshot);
    }

    private static enum ReleaseTypeStrategy {
        PATCH("PATCH", VersionCalculator::nextPatchRelease, VersionCalculator::nextPatchSnapshot),
        MINOR("MINOR", VersionCalculator::nextMinorRelease, VersionCalculator::nextMinorSnapshot),
        MAJOR("MAJOR", VersionCalculator::nextMajorRelease, VersionCalculator::nextMajorSnapshot);

        private final String code;
        private final Function<VersionCalculator, String> nextReleaser;
        private final Function<VersionCalculator, String> nextSnapshoter;

        private ReleaseTypeStrategy(String code, Function<VersionCalculator, String> nextReleaser, Function<VersionCalculator, String> nextSnapshoter) {
            this.code = code;
            this.nextReleaser = nextReleaser;
            this.nextSnapshoter = nextSnapshoter;
        }

        public static ReleaseTypeStrategy of(String releaseType) {
            return Arrays.stream(ReleaseTypeStrategy.values()).filter(v -> v.code().equals(releaseType)).findFirst().orElseThrow();
        }

        NextRelease calculateNextRelease(VersionCalculator versionCalculator) {
            return new NextRelease(this.nextRelease(versionCalculator), this.nextSnapshot(versionCalculator));
        }

        private String code() {
            return this.code;
        }

        public String nextRelease(VersionCalculator versionCalculator) {
            return this.nextReleaser.apply(versionCalculator);
        }

        public String nextSnapshot(VersionCalculator versionCalculator) {
            return this.nextSnapshoter.apply(versionCalculator);
        }
    }

    private static class NextRelease {
        private String release;
        private String snapshot;

        private NextRelease(String release, String snapshot) {
            this.release = release;
            this.snapshot = snapshot;
        }
    }
}

