/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.maven.plugins;

import java.text.NumberFormat;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import top.marchand.maven.plugins.VersionCalculatorException;

public class VersionCalculator {
    private static final NumberFormat FORMATTER = NumberFormat.getIntegerInstance();
    public static final String SNAPSHOT = "-SNAPSHOT";
    private final String inputVersion;
    private String build;
    private String patch;
    private String minor;
    private String major;
    private String prefix;
    private String suffix;
    private boolean isSnapshot = false;

    public VersionCalculator(String inputVersion) throws VersionCalculatorException {
        this.inputVersion = inputVersion;
        this.extractVersionNumbers();
    }

    private void extractVersionNumbers() throws VersionCalculatorException {
        Matcher matcher = Pattern.compile("[0-9]+").matcher(this.inputVersion);
        int groupIndex = 0;
        while (matcher.find()) {
            switch (groupIndex) {
                case 0: {
                    this.major = matcher.group();
                    break;
                }
                case 1: {
                    this.minor = matcher.group();
                    break;
                }
                case 2: {
                    this.patch = matcher.group();
                    break;
                }
                default: {
                    this.build = matcher.group();
                }
            }
            ++groupIndex;
        }
        if (groupIndex == 0) {
            throw new VersionCalculatorException("A version should at least contain one number");
        }
        matcher.find(0);
        this.prefix = this.inputVersion.substring(0, matcher.start());
        do {
            this.suffix = this.inputVersion.substring(matcher.end());
        } while (matcher.find());
        if (!this.suffix.isEmpty() && this.suffix.endsWith(SNAPSHOT)) {
            this.isSnapshot = true;
            this.suffix = this.suffix.substring(0, this.suffix.length() - SNAPSHOT.length());
        }
    }

    public String nextPatchRelease() {
        StringJoiner joiner = new StringJoiner(".");
        joiner.add(this.major);
        if (this.minor != null) {
            joiner.add(this.minor);
        } else {
            joiner.add("00");
        }
        if (this.patch != null) {
            if (this.isSnapshot) {
                joiner.add(this.formatNumber(this.patch, 2));
            } else {
                joiner.add(this.formatNumber(this.increment(this.patch), 2));
            }
        } else {
            joiner.add("01");
        }
        if (this.build != null) {
            joiner.add("00");
        }
        return this.prefix + joiner.toString() + this.suffix;
    }

    private int increment(String number) {
        return Integer.parseInt(number) + 1;
    }

    private CharSequence formatNumber(int value, int size) {
        FORMATTER.setMinimumIntegerDigits(size);
        return FORMATTER.format(value);
    }

    private CharSequence formatNumber(String value, int size) {
        return this.formatNumber(Integer.parseInt(value), size);
    }

    public String suffix() {
        return this.suffix;
    }

    public String prefix() {
        return this.prefix;
    }

    public boolean snapshot() {
        return this.isSnapshot;
    }

    public String nextMinorRelease() {
        StringJoiner joiner = new StringJoiner(".");
        joiner.add(this.major);
        if (this.minor != null) {
            if (this.snapshot()) {
                if ("00".equals(this.patch)) {
                    joiner.add(this.minor);
                } else {
                    joiner.add(this.incrementAndFormatMinor());
                }
            } else {
                joiner.add(this.incrementAndFormatMinor());
            }
        } else {
            joiner.add("01");
        }
        joiner.add("00");
        if (this.build != null) {
            joiner.add("00");
        }
        return this.prefix + joiner.toString() + this.suffix;
    }

    private CharSequence incrementAndFormatMinor() {
        return this.formatNumber(this.increment(this.minor), 2);
    }

    public String nextMajorRelease() {
        StringJoiner joiner = new StringJoiner(".");
        if (this.snapshot()) {
            if (this.minor.isEmpty() || "00".equals(this.minor)) {
                if (this.patch.isEmpty() || "00".equals(this.patch)) {
                    joiner.add(this.major);
                } else {
                    joiner.add(this.incrementAndFormatMajor());
                }
            } else {
                joiner.add(this.incrementAndFormatMajor());
            }
        } else {
            joiner.add(this.incrementAndFormatMajor());
        }
        joiner.add("00");
        joiner.add("00");
        if (this.build != null) {
            joiner.add("00");
        }
        return this.prefix + joiner.toString() + this.suffix;
    }

    private CharSequence incrementAndFormatMajor() {
        return this.formatNumber(this.increment(this.major), 1);
    }

    public String nextPatchSnapshot() {
        try {
            return new VersionCalculator(this.nextPatchRelease()).nextPatchRelease() + SNAPSHOT;
        }
        catch (VersionCalculatorException e) {
            throw new RuntimeException(e);
        }
    }

    public String nextMinorSnapshot() {
        try {
            return new VersionCalculator(this.nextMinorRelease()).nextPatchRelease() + SNAPSHOT;
        }
        catch (VersionCalculatorException e) {
            throw new RuntimeException(e);
        }
    }

    public String nextMajorSnapshot() {
        try {
            return new VersionCalculator(this.nextMajorRelease()).nextPatchRelease() + SNAPSHOT;
        }
        catch (VersionCalculatorException e) {
            throw new RuntimeException(e);
        }
    }
}

