/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.maven.spring.xd.archiver;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.artifact.resolve.ArtifactResolver;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.apache.maven.shared.dependencies.DefaultDependableCoordinate;
import org.apache.maven.shared.dependencies.DependableCoordinate;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import top.marchand.maven.artifact.resolver.utils.ArtifactResolverUtils;

@Mojo(name="archive", defaultPhase=LifecyclePhase.PACKAGE, requiresDependencyResolution=ResolutionScope.COMPILE)
public class ArchiverMojo
extends AbstractMojo {
    @Parameter(defaultValue="${session}", readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    public MavenProject project;
    @Parameter(defaultValue="xd-prio")
    public String classifier;
    @Parameter(defaultValue="true")
    public boolean addToArtifactList;
    @Parameter(defaultValue="${project.artifactId}")
    public String baseName;
    @Parameter
    public String finalName;
    @Parameter(defaultValue="${project.build.directory}")
    public File targetDir;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    public File projectTargetDir;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true, required=true)
    private List<ArtifactRepository> pomRemoteRepositories;
    @Parameter(property="remoteRepositories")
    private String remoteRepositories;
    @Component
    private MavenProjectHelper projectHelper;
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Component
    private ArtifactResolver artifactResolver;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Component(role=ArtifactRepositoryLayout.class)
    private Map<String, ArtifactRepositoryLayout> repositoryLayouts;
    private File workingDir;
    private static final String PREFIX = "[SpringArchiver] ";

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.workingDir = new File(this.projectTargetDir, "spring-xd-archiver");
        this.workingDir.mkdirs();
        ArtifactResolverUtils resolverUtils = new ArtifactResolverUtils(this.session, this.artifactResolver, this.artifactHandlerManager, this.repositoryLayouts, this.pomRemoteRepositories);
        resolverUtils.constructRepoList(this.remoteRepositories);
        String archiveFileName = this.getArchiveFileName();
        File destArchive = this.getArchiveFile(archiveFileName);
        try (FileOutputStream fos = new FileOutputStream(destArchive);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            zos.setLevel(9);
            this.addMetaFiles(zos, archiveFileName);
            this.addClassFiles(zos);
            this.addDependenciesJars(zos, resolverUtils);
            zos.finish();
            zos.close();
            this.projectHelper.attachArtifact(this.project, destArchive, this.classifier);
        }
        catch (IOException ex) {
            throw new MojoFailureException("while generating " + destArchive.getAbsolutePath(), (Throwable)ex);
        }
    }

    protected void addClassFiles(final ZipOutputStream zos) throws IOException {
        File classesDir = new File(this.project.getBuild().getOutputDirectory());
        final Path classesPath = classesDir.toPath();
        Files.walkFileTree(classesPath, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path reduced = classesPath.relativize(file);
                ArchiverMojo.this.getLog().info((CharSequence)("[SpringArchiver] Adding " + reduced.toString()));
                ZipEntry ze = new ZipEntry(reduced.toString());
                zos.putNextEntry(ze);
                try (FileInputStream is = new FileInputStream(file.toFile());){
                    ArchiverMojo.this.copyToZos(is, zos);
                }
                zos.closeEntry();
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                throw exc;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }

    protected void addMetaFiles(ZipOutputStream zos, String archiveFileName) throws IOException {
        this.getLog().debug((CharSequence)("[SpringArchiver] Looking for files in " + this.projectTargetDir.getAbsolutePath()));
        List jarFiles = Files.walk(this.projectTargetDir.toPath(), 1, new FileVisitOption[0]).filter(t -> t.getFileName().toString().endsWith(".jar") && !t.getFileName().toString().equals(archiveFileName)).collect(Collectors.toList());
        switch (jarFiles.size()) {
            case 0: {
                this.getLog().warn((CharSequence)("[SpringArchiver] No jar file found in " + this.projectTargetDir.getAbsolutePath()));
                break;
            }
            case 1: {
                this.extractMetaFilesFrom((Path)jarFiles.get(0), zos);
                break;
            }
            default: {
                Path firstJar = ((Path)jarFiles.get(0)).getFileName();
                this.getLog().warn((CharSequence)("[SpringArchiver] More than one jar file found in " + this.projectTargetDir.getAbsolutePath() + ". Using first found: " + firstJar));
                this.extractMetaFilesFrom(firstJar, zos);
            }
        }
    }

    protected void extractMetaFilesFrom(Path jar, ZipOutputStream zos) throws IOException {
        this.getLog().debug((CharSequence)("[SpringArchiver] Extracting files from " + jar.toString()));
        try (ZipInputStream zis = new ZipInputStream(Files.newInputStream(jar, new OpenOption[0]));){
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                if (ze.getName().startsWith("META-INF/") && !ze.isDirectory()) {
                    this.getLog().info((CharSequence)("[SpringArchiver] Adding " + ze.getName()));
                    ZipEntry zeo = new ZipEntry(ze.getName());
                    zos.putNextEntry(zeo);
                    this.copyToZos(zis, zos);
                    zos.closeEntry();
                    zos.flush();
                    zis.closeEntry();
                }
                ze = zis.getNextEntry();
            }
        }
    }

    protected void addDependenciesJars(final ZipOutputStream zos, final ArtifactResolverUtils resolverUtils) throws IOException {
        try {
            DependencyNode rootNode = this.dependencyGraphBuilder.buildDependencyGraph(this.project, this.buildArtifactFilter());
            DependencyNodeVisitor visitor = new DependencyNodeVisitor(){

                public boolean visit(DependencyNode dn) {
                    ArchiverMojo.this.processDependency(dn, zos, resolverUtils);
                    return true;
                }

                public boolean endVisit(DependencyNode dn) {
                    return true;
                }
            };
            rootNode.accept(visitor);
        }
        catch (DependencyGraphBuilderException ex) {
            this.getLog().error((CharSequence)"while creating dependency tree", (Throwable)ex);
            throw new IOException(ex);
        }
    }

    protected void processDependency(DependencyNode dn, ZipOutputStream zos, ArtifactResolverUtils resolverUtils) {
        DefaultDependableCoordinate coordinate = new DefaultDependableCoordinate();
        String artifactDescriptor = String.format("%s:%s:%s:%s", dn.getArtifact().getGroupId(), dn.getArtifact().getArtifactId(), dn.getArtifact().getClassifier(), dn.getArtifact().getVersion());
        coordinate.setGroupId(dn.getArtifact().getGroupId());
        coordinate.setArtifactId(dn.getArtifact().getArtifactId());
        coordinate.setVersion(dn.getArtifact().getVersion());
        coordinate.setClassifier(dn.getArtifact().getClassifier());
        File file = null;
        try {
            Artifact foundArtifact = resolverUtils.resolveArtifact((DependableCoordinate)coordinate);
            file = foundArtifact.getFile();
            ZipEntry ze = new ZipEntry("lib/" + file.getName());
            this.getLog().info((CharSequence)("[SpringArchiver] Adding " + ze.getName()));
            zos.putNextEntry(ze);
            this.uncompress(new FileInputStream(file), zos, file.getName());
            zos.closeEntry();
            zos.flush();
        }
        catch (ArtifactResolverException ex) {
            this.getLog().error((CharSequence)("while resolving " + artifactDescriptor), (Throwable)ex);
        }
        catch (IOException ex) {
            this.getLog().error((CharSequence)("while adding " + file != null ? file.getName() : "<unresolved " + artifactDescriptor + ">"), (Throwable)ex);
        }
    }

    private void copyToZos(InputStream is, OutputStream os) throws IOException {
        byte[] buffer = new byte[2048];
        int len = is.read(buffer);
        while (len > 0) {
            os.write(buffer, 0, len);
            len = is.read(buffer);
        }
        os.flush();
    }

    protected File getArchiveFile(String archiveFileName) {
        return new File(this.targetDir, archiveFileName);
    }

    protected String getArchiveFileName() {
        if (this.finalName != null && !this.finalName.isEmpty()) {
            return this.finalName;
        }
        StringBuilder sb = new StringBuilder(this.project.getArtifactId());
        sb.append("-").append(this.project.getVersion());
        if (this.classifier != null && !this.classifier.isEmpty()) {
            sb.append("-").append(this.classifier);
        }
        sb.append(".jar");
        return sb.toString();
    }

    private ArtifactFilter buildArtifactFilter() throws IOException {
        HashSet<String> excludes = this.getExcludes();
        String projectMarker = this.project.getGroupId() + ":" + this.project.getArtifactId();
        this.getLog().debug((CharSequence)("ProjectMarker is " + projectMarker));
        excludes.add(projectMarker);
        return artfct -> {
            String marker = artfct.getGroupId() + ":" + artfct.getArtifactId();
            if ("test".equals(artfct.getScope())) {
                this.getLog().debug((CharSequence)(PREFIX + artfct.toString() + " excluded because of test scope"));
                return false;
            }
            if (excludes.contains(marker)) {
                this.getLog().debug((CharSequence)(PREFIX + artfct.toString() + " exclude because of exclude list"));
                return false;
            }
            this.getLog().debug((CharSequence)(PREFIX + artfct.toString() + " accepted"));
            return true;
        };
    }

    private HashSet<String> getExcludes() throws IOException {
        InputStream isExc = ((Object)((Object)this)).getClass().getResourceAsStream("/top/marchand/maven/spring/xd/archiver/excluded-artifacts");
        HashSet<String> ret = new HashSet<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(isExc, Charset.forName("UTF-8")));
        br.lines().forEach(t -> {
            if (!t.isEmpty()) {
                ret.add((String)t);
            }
        });
        return ret;
    }

    public void uncompress(InputStream source, OutputStream target, String entryName) throws IOException {
        ZipOutputStream os;
        File tempFile = new File(this.workingDir, entryName);
        try (ZipInputStream is = new ZipInputStream(source);){
            os = new ZipOutputStream(new FileOutputStream(tempFile));
            os.setMethod(8);
            os.setLevel(0);
            ZipEntry ze = is.getNextEntry();
            while (ze != null) {
                ZipEntry entry = new ZipEntry(ze.getName());
                entry.setMethod(0);
                this.getLog().debug((CharSequence)("[SpringArchiver]    " + ze.getName() + " CS: " + ze.getCompressedSize() + " S: " + ze.getSize()));
                if (ze.getSize() >= 0L) {
                    entry.setSize(ze.getSize());
                    entry.setCompressedSize(ze.getSize());
                    entry.setCrc(ze.getCrc());
                    os.putNextEntry(entry);
                    byte[] buffer = new byte[2048];
                    int len = is.read(buffer, 0, 2048);
                    long count = 0L;
                    while (len > 0) {
                        os.write(buffer, 0, len);
                        count += (long)len;
                        len = is.read(buffer, 0, 2048);
                    }
                    this.getLog().debug((CharSequence)("[SpringArchiver]    CS: " + ze.getCompressedSize() + " S: " + ze.getSize() + " W:" + count));
                    os.closeEntry();
                    is.closeEntry();
                } else {
                    File tempEntry = File.createTempFile("SpringArchiver", ".xxx");
                    FileOutputStream tempEntryOs = new FileOutputStream(tempEntry);
                    byte[] buffer = new byte[2048];
                    CRC32 crc = new CRC32();
                    int len = is.read(buffer, 0, 2048);
                    long count = 0L;
                    while (len > 0) {
                        tempEntryOs.write(buffer, 0, len);
                        crc.update(buffer, 0, len);
                        count += (long)len;
                        len = is.read(buffer, 0, 2048);
                    }
                    is.closeEntry();
                    tempEntryOs.flush();
                    tempEntryOs.close();
                    entry.setSize(tempEntry.length());
                    entry.setCompressedSize(tempEntry.length());
                    entry.setCrc(crc.getValue());
                    os.putNextEntry(entry);
                    Files.copy(tempEntry.toPath(), os);
                    this.getLog().debug((CharSequence)("[SpringArchiver]    CS: " + tempEntry.length() + " S: " + tempEntry.length() + " W:" + tempEntry.length()));
                    os.closeEntry();
                    tempEntry.delete();
                }
                ze = is.getNextEntry();
            }
        }
        os.flush();
        os.close();
        var7_6 = null;
        try (FileInputStream tempFis = new FileInputStream(tempFile);){
            byte[] buffer = new byte[2048];
            int len = tempFis.read(buffer, 0, 2048);
            while (len > 0) {
                target.write(buffer, 0, len);
                len = tempFis.read(buffer, 0, 2048);
            }
        }
        catch (Throwable throwable) {
            var7_6 = throwable;
            throw throwable;
        }
        target.flush();
    }
}

