/*
 * Copyright 2019 Christophe Marchand
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package top.marchand.oxygen.maven.project.support.impl;

import java.awt.Color;
import java.net.URI;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.UIManager;
import ro.sync.exml.workspace.api.PluginWorkspace;

/**
 *
 * @author cmarchand
 */
public class MavenOptionView extends javax.swing.JPanel {

    private final PluginWorkspace pluginWorkspace;
    private String installDirReport, localRepoDir;
    
    public MavenOptionView(PluginWorkspace pluginWorkspace) {
        super();
        this.pluginWorkspace = pluginWorkspace;
        initComponents();
    }
    
    public void setMavenInstallDir(String location) {
        dfMavenInstallDir.setText(location);
    }
    
    public String getMavenInstallDir() {
        return dfMavenInstallDir.getText();
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lblMavenDir = new javax.swing.JLabel();
        dfMavenInstallDir = new javax.swing.JTextField();
        pbChooseInstallDir = new javax.swing.JButton();
        lblReport = new javax.swing.JLabel();

        lblMavenDir.setText("Maven install directory");

        dfMavenInstallDir.addFocusListener(new java.awt.event.FocusAdapter() {
            public void focusGained(java.awt.event.FocusEvent evt) {
                dfMavenInstallDirFocusGained(evt);
            }
        });
        dfMavenInstallDir.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                dfMavenInstallDirPropertyChange(evt);
            }
        });

        pbChooseInstallDir.setText("...");
        pbChooseInstallDir.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                pbChooseInstallDirActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(lblReport, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(lblMavenDir)
                        .addGap(25, 25, 25)
                        .addComponent(dfMavenInstallDir, javax.swing.GroupLayout.DEFAULT_SIZE, 272, Short.MAX_VALUE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(pbChooseInstallDir, javax.swing.GroupLayout.PREFERRED_SIZE, 46, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(2, 2, 2)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(lblMavenDir)
                    .addComponent(dfMavenInstallDir, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(pbChooseInstallDir))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(lblReport, javax.swing.GroupLayout.PREFERRED_SIZE, 20, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void pbChooseInstallDirActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_pbChooseInstallDirActionPerformed
        String ret = getDirectory("Maven install directory");
        if(ret!=null && !ret.isEmpty()) dfMavenInstallDir.setText(ret);
    }//GEN-LAST:event_pbChooseInstallDirActionPerformed

    private String getDirectory(String title) {
        JFileChooser chooser = new JFileChooser(); 
        chooser.setCurrentDirectory(new java.io.File("."));
        chooser.setDialogTitle("Maven installation  directory");
        chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
        //
        // disable the "All files" option.
        //
        chooser.setAcceptAllFileFilterUsed(false);
        //    
        if (chooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) { 
            return chooser.getSelectedFile().toURI().toString();
        } else {
          return null;
        }
    }

    private void dfMavenInstallDirPropertyChange(java.beans.PropertyChangeEvent evt) {//GEN-FIRST:event_dfMavenInstallDirPropertyChange
        try {
            String text = pluginWorkspace.getUtilAccess().expandEditorVariables(dfMavenInstallDir.getText(), null);
            if(text==null || text.isEmpty()) {
                installDirReport = "Maven install directory must be defined";
                setErrorMarker(dfMavenInstallDir, true);
            } else {
                URI uri = new URI(text);
                setErrorMarker(dfMavenInstallDir, false);
                installDirReport=text;
                dfMavenInstallDirFocusGained(null);
            }
        } catch(Exception ex) {
            installDirReport = ex.getLocalizedMessage();
            setErrorMarker(dfMavenInstallDir, true);
        }
    }//GEN-LAST:event_dfMavenInstallDirPropertyChange

    private void dfMavenInstallDirFocusGained(java.awt.event.FocusEvent evt) {//GEN-FIRST:event_dfMavenInstallDirFocusGained
        lblReport.setText(installDirReport);
    }//GEN-LAST:event_dfMavenInstallDirFocusGained

    private void setErrorMarker(JTextField fld, boolean isError) {
        if(isError) {
            fld.setBackground(Color.red);
        } else {
            fld.setBackground(UIManager.getColor("TextField.background"));
        }
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTextField dfMavenInstallDir;
    private javax.swing.JLabel lblMavenDir;
    private javax.swing.JLabel lblReport;
    private javax.swing.JButton pbChooseInstallDir;
    // End of variables declaration//GEN-END:variables
}
