/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.oxygen.maven.project.support.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import org.apache.log4j.Logger;
import top.marchand.oxygen.maven.project.support.MavenProjectPlugin;

public class DependencyStreamHandler
extends URLStreamHandler {
    private static final Logger LOGGER = Logger.getLogger(DependencyStreamHandler.class);
    public static final String DEPENDENCY_PROTOCOL = "dependency:/";

    @Override
    protected URLConnection openConnection(URL u) throws IOException {
        URL resolvedUrl = MavenProjectPlugin.getInstance().resolveDependencyUrl(u);
        if (resolvedUrl == null) {
            LOGGER.debug((Object)("openConnection(" + u + ") -> null"));
            return null;
        }
        LOGGER.debug((Object)("openConnection(" + u + ") -> " + resolvedUrl.toString()));
        return new DependencyUrlConnection(u, resolvedUrl);
    }

    private class DependencyUrlConnection
    extends URLConnection {
        private final URL resolvedUrl;

        public DependencyUrlConnection(URL url, URL resolvedUrl) {
            super(url);
            this.resolvedUrl = resolvedUrl;
        }

        @Override
        public void connect() throws IOException {
        }

        @Override
        public OutputStream getOutputStream() throws IOException {
            return null;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            LOGGER.debug((Object)("getInputStream(" + this.resolvedUrl.toExternalForm() + ")"));
            return this.resolvedUrl.openStream();
        }
    }
}

