/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.oxygen.maven.project.support.impl;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import org.apache.log4j.Logger;
import top.marchand.oxygen.maven.project.support.impl.nodes.AbstractMavenNode;
import top.marchand.oxygen.maven.project.support.impl.nodes.MavenDirectoryNode;
import top.marchand.oxygen.maven.project.support.impl.nodes.MavenFileNode;
import top.marchand.oxygen.maven.project.support.impl.nodes.MavenProjectNode;

public class MavenProjectExplorer {
    private static final Logger LOGGER = Logger.getLogger(MavenProjectExplorer.class);
    private final Path directory;
    private final Processor proc;
    private static final List<String> EXCLUDE_DIRS = Arrays.asList(".git", ".project", ".svn");
    private static final List<String> EXCLUDE_FILES = Arrays.asList(".gitignore", ".DS_Store");

    public MavenProjectExplorer(Path directory, Processor proc) {
        this.directory = directory;
        this.proc = proc;
    }

    public AbstractMavenNode explore(boolean includeTargetDirectory) {
        try {
            MavenFileVisitor visitor = new MavenFileVisitor(this.directory, includeTargetDirectory);
            Files.walkFileTree(this.directory, visitor);
            return visitor.getRootNode();
        }
        catch (IOException ex) {
            LOGGER.error((Object)("while exploring " + this.directory), (Throwable)ex);
            return null;
        }
    }

    protected String getProjectName(File pomFile) {
        LOGGER.debug((Object)("getting project name from " + pomFile.getAbsolutePath()));
        try {
            return this.getProjectName(this.parsePomFile(pomFile));
        }
        catch (SaxonApiException ex) {
            LOGGER.error((Object)("while getting projectName from " + pomFile.getAbsolutePath()), (Throwable)ex);
            return "UNKNOWN";
        }
    }

    protected boolean hasParent(Path file, String parentName) {
        for (Path parent = file.getParent(); parent != null; parent = parent.getParent()) {
            if (!parentName.equals(parent.getFileName().toString())) continue;
            return true;
        }
        return false;
    }

    private XdmNode parsePomFile(File pomFile) throws SaxonApiException {
        DocumentBuilder builder = this.proc.newDocumentBuilder();
        return builder.build(pomFile);
    }

    private String getProjectName(XdmNode pom) throws SaxonApiException {
        XPathCompiler comp = this.proc.newXPathCompiler();
        comp.declareNamespace("pom", "http://maven.apache.org/POM/4.0.0");
        XPathSelector xs = comp.compile("/pom:project/(pom:name|pom:artifactId)[1]/text()").load();
        xs.setContextItem((XdmItem)pom);
        return xs.evaluateSingle().getStringValue();
    }

    private class MavenFileVisitor
    implements FileVisitor<Path> {
        private final Stack<MavenDirectoryNode> stack;
        private final boolean includeTargetDirectory;
        private final Path root;
        private static final String SRC = "src";
        private MavenProjectNode rootNode;

        public MavenFileVisitor(Path root, boolean includeTargetDirectory) {
            this.includeTargetDirectory = includeTargetDirectory;
            this.root = root;
            this.stack = new Stack();
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path relative = this.root.relativize(dir);
            if (this.root.equals(dir)) {
                LOGGER.debug((Object)("starting maven project at " + dir.toString()));
                Path pom = dir.resolve("pom.xml");
                MavenProjectNode node = new MavenProjectNode(MavenProjectExplorer.this.getProjectName(pom.toFile()));
                node.add(new MavenFileNode(pom));
                this.rootNode = node;
                return FileVisitResult.CONTINUE;
            }
            if (this.isTraversable(relative)) {
                Path pom = dir.resolve("pom.xml");
                if (Files.isRegularFile(pom, new LinkOption[0])) {
                    LOGGER.debug((Object)("found sub-maven project at " + dir.toString()));
                    try {
                        MavenProjectExplorer explorer = new MavenProjectExplorer(dir, MavenProjectExplorer.this.proc);
                        if (this.stack.isEmpty()) {
                            this.rootNode.add(explorer.explore(this.includeTargetDirectory));
                        } else {
                            this.stack.peek().add(explorer.explore(this.includeTargetDirectory));
                        }
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    catch (RuntimeException ex) {
                        if (relative.startsWith(SRC) && this.stack.size() < 3 || !relative.startsWith(SRC)) {
                            MavenDirectoryNode node = new MavenDirectoryNode(dir);
                            if (this.stack.isEmpty()) {
                                this.rootNode.add(node);
                            } else {
                                this.stack.peek().add(node);
                            }
                            this.stack.push(node);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                }
                LOGGER.debug((Object)("found normal sub-dir at " + dir.toString()));
                if (relative.startsWith(SRC) && this.stack.size() < 3 || !relative.startsWith(SRC)) {
                    MavenDirectoryNode node = new MavenDirectoryNode(dir);
                    if (this.stack.isEmpty()) {
                        this.rootNode.add(node);
                    } else {
                        this.stack.peek().add(node);
                    }
                    this.stack.push(node);
                }
                return FileVisitResult.CONTINUE;
            }
            return FileVisitResult.SKIP_SUBTREE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (exc != null) {
                throw exc;
            }
            Path relative = this.root.relativize(dir);
            if (!this.root.equals(dir) && this.isTraversable(relative) && (relative.startsWith(SRC) && relative.getNameCount() <= 3 || !relative.startsWith(SRC))) {
                this.stack.pop();
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path relative = this.root.relativize(file);
            if (this.isFileAcceptable(file) && relative.getNameCount() > 3 && relative.startsWith(SRC)) {
                String packageName = null;
                if (relative.getNameCount() > 4) {
                    Path packagePath = relative.subpath(3, relative.getNameCount() - 1);
                    packageName = packagePath.toString().replaceAll("[/\\\\]", ".");
                } else {
                    packageName = "<default>";
                }
                MavenDirectoryNode node = this.stack.peek();
                node.addPackageEntry(packageName, file);
            } else if (this.isFileAcceptable(file) && relative.startsWith(SRC)) {
                MavenDirectoryNode node = this.stack.peek();
                node.add(new MavenFileNode(file));
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            if (exc != null) {
                throw exc;
            }
            return FileVisitResult.CONTINUE;
        }

        private boolean isTraversable(Path dir) {
            if (EXCLUDE_DIRS.contains(dir.getFileName().toString())) {
                return false;
            }
            if (dir.getFileName().toString().equals("xspec") && MavenProjectExplorer.this.hasParent(dir, "xspec") && MavenProjectExplorer.this.hasParent(dir, SRC)) {
                return false;
            }
            if (this.includeTargetDirectory) {
                return true;
            }
            return !"target".equals(dir.getFileName().toString());
        }

        private boolean isFileAcceptable(Path file) {
            return !EXCLUDE_FILES.contains(file.getFileName().toString());
        }

        protected MavenProjectNode getRootNode() {
            return this.rootNode;
        }
    }
}

