/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.oxygen.maven.project.support.impl;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.ToolTipManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import org.apache.log4j.Logger;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationOutputHandler;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;
import org.apache.maven.shared.invoker.PrintStreamHandler;
import org.apache.maven.shared.utils.cli.CommandLineException;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import ro.sync.exml.workspace.api.editor.page.text.WSTextEditorPage;
import ro.sync.exml.workspace.api.standalone.StandalonePluginWorkspace;
import ro.sync.exml.workspace.api.standalone.actions.MenusAndToolbarsContributorCustomizer;
import top.marchand.oxygen.maven.project.support.MavenOptionsPage;
import top.marchand.oxygen.maven.project.support.MavenProjectPlugin;
import top.marchand.oxygen.maven.project.support.impl.DlgChooseDependencyResource;
import top.marchand.oxygen.maven.project.support.impl.MavenProjectExplorer;
import top.marchand.oxygen.maven.project.support.impl.MavenTreeCellRenderer;
import top.marchand.oxygen.maven.project.support.impl.nodes.AbstractMavenNode;
import top.marchand.oxygen.maven.project.support.impl.nodes.ImageHandler;
import top.marchand.oxygen.maven.project.support.impl.nodes.MavenFileNode;

public class MavenProjectView
extends JPanel {
    private TreeModel model;
    private static final Logger LOGGER = Logger.getLogger(MavenProjectView.class);
    private final Processor proc = new Processor(Configuration.newConfiguration());
    private final StandalonePluginWorkspace pluginWorkspaceAccess;
    private File currentProjectDir;
    private JCheckBox chkShowTargetDirs;
    private JScrollPane jScrollPane1;
    private JLabel lblStatus;
    private JTree tree;

    public MavenProjectView(StandalonePluginWorkspace pluginWorkspaceAccess) {
        this.pluginWorkspaceAccess = pluginWorkspaceAccess;
        this.model = new DefaultTreeModel(new EmptyTreeNode());
        this.initComponents();
        this.tree.setCellRenderer(new MavenTreeCellRenderer());
        this.loadModel(this.getProjectDir());
        this.addPropertyChangeListener(evt -> {
            if ("ancestor".equals(evt.getPropertyName()) && (evt.getOldValue() != null && !evt.getOldValue().equals(evt.getNewValue()) || evt.getNewValue() != null && !evt.getNewValue().equals(evt.getOldValue()))) {
                File projectDir = this.getProjectDir();
                if (this.currentProjectDir == null || !this.currentProjectDir.equals(projectDir)) {
                    this.loadModel(projectDir);
                }
            }
        });
        pluginWorkspaceAccess.addMenusAndToolbarsContributorCustomizer(new MenusAndToolbarsContributorCustomizer(){

            public void customizeTextPopUpMenu(JPopupMenu popUp, final WSTextEditorPage textPage) {
                LOGGER.debug((Object)"customizeTextPopupMenu");
                Class<?> clazz = textPage.getClass();
                if (textPage.getCaretOffset() < 6) {
                    return;
                }
                try {
                    Method mGetDocument = clazz.getMethod("getDocument", new Class[0]);
                    Object ret = mGetDocument.invoke((Object)textPage, new Object[0]);
                    final Document doc = (Document)ret;
                    String before = doc.getText(textPage.getCaretOffset() - 6, 6);
                    String after = doc.getText(textPage.getCaretOffset(), 1);
                    if (("\"".equals(after) || "'".equals(after)) && ("href=\"".equals(before) || "href='".equals(before))) {
                        popUp.insert(new AbstractAction("Dependency resource...", ImageHandler.getInstance().get("Maven2Icon.gif")){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                DlgChooseDependencyResource dlg = new DlgChooseDependencyResource(SwingUtilities.getWindowAncestor(MavenProjectView.this));
                                String url = dlg.getDependencyUrl();
                                if (url != null) {
                                    try {
                                        doc.insertString(textPage.getCaretOffset(), url, null);
                                    }
                                    catch (BadLocationException ex) {
                                        LOGGER.error((Object)"Inserting at wrong position:", (Throwable)ex);
                                    }
                                }
                            }
                        }, 0);
                        popUp.insert(new JPopupMenu.Separator(), 1);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | InvocationTargetException | BadLocationException ex) {
                    LOGGER.error((Object)"while invoking getDocument()", (Throwable)ex);
                }
            }
        });
    }

    private void loadModel(final File projectDir) {
        SwingWorker<SwingWorker<String, Integer>, Integer> worker = new SwingWorker<SwingWorker<String, Integer>, Integer>(){
            private TreeModel localModel;

            @Override
            public SwingWorker<String, Integer> doInBackground() {
                MavenProjectView.this.lblStatus.setText("Project loading...");
                File pomFile = new File(projectDir, "pom.xml");
                if (!pomFile.exists()) {
                    this.localModel = new DefaultTreeModel(new EmptyTreeNode("Not a maven project"));
                    return null;
                }
                MavenOptionsPage optionPage = MavenOptionsPage.INSTANCE;
                MavenProjectExplorer explorer = new MavenProjectExplorer(projectDir.toPath(), MavenProjectView.this.proc);
                AbstractMavenNode node = explorer.explore(MavenProjectView.this.chkShowTargetDirs.isSelected());
                this.localModel = new DefaultTreeModel(node);
                LOGGER.debug((Object)"creating DependencyScanner");
                if ("".equals(optionPage.getMavenInstallDir())) {
                    JOptionPane.showMessageDialog(MavenProjectView.this, "Maven installation directory is not defined\nYou have to define it in preferences page.", "Maven not configured", 2);
                    return null;
                }
                LOGGER.debug((Object)("Maven install dir: " + optionPage.getMavenInstallDir()));
                try {
                    return new DependencyScanner(pomFile.toPath(), new File(new URI(optionPage.getMavenInstallDir())));
                }
                catch (URISyntaxException ex) {
                    return null;
                }
            }

            @Override
            protected void done() {
                LOGGER.debug((Object)"installing model");
                MavenProjectView.this.tree.setModel(this.localModel);
                MavenProjectView.this.lblStatus.setText("");
                MavenProjectView.this.currentProjectDir = projectDir;
                try {
                    SwingWorker worker = (SwingWorker)this.get();
                    if (worker != null) {
                        LOGGER.debug((Object)"submitting scanner");
                        worker.execute();
                    } else {
                        LOGGER.debug((Object)"no post-task to execute");
                    }
                }
                catch (InterruptedException | ExecutionException ex) {
                    LOGGER.error((Object)"Interrupted...", (Throwable)ex);
                }
            }
        };
        worker.execute();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.tree = new MavenJTree();
        this.chkShowTargetDirs = new JCheckBox();
        this.lblStatus = new JLabel();
        this.tree.setModel(this.model);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MavenProjectView.this.treeMouseClicked(evt);
            }
        });
        this.tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                MavenProjectView.this.treeKeyPressed(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tree);
        this.chkShowTargetDirs.setText("Show target/ dirs");
        this.chkShowTargetDirs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MavenProjectView.this.chkShowTargetDirsActionPerformed(evt);
            }
        });
        this.lblStatus.setFont(new Font("Lucida Grande", 2, 13));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 318, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.chkShowTargetDirs).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblStatus, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 333, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.chkShowTargetDirs).addComponent(this.lblStatus))));
    }

    private void chkShowTargetDirsActionPerformed(ActionEvent evt) {
        this.loadModel(this.getProjectDir());
    }

    private void treeMouseClicked(MouseEvent evt) {
        TreePath tp;
        Object o;
        if (evt.getClickCount() == 2 && (o = (tp = this.tree.getClosestPathForLocation(evt.getX(), evt.getY())).getLastPathComponent()) instanceof MavenFileNode) {
            MavenFileNode node = (MavenFileNode)o;
            this.pluginWorkspaceAccess.open(node.getFileUrl());
        }
    }

    private void treeKeyPressed(KeyEvent evt) {
        if (evt.getKeyCode() == 10) {
            for (TreePath tp : this.tree.getSelectionPaths()) {
                Object o = tp.getLastPathComponent();
                if (!(o instanceof MavenFileNode)) continue;
                MavenFileNode node = (MavenFileNode)o;
                this.pluginWorkspaceAccess.open(node.getFileUrl());
            }
        }
    }

    protected final File getProjectDir() {
        String projectDirectory = PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().expandEditorVariables("${pd}", null);
        return new File(projectDirectory);
    }

    private class DependencyEntry {
        private final int level;
        private final String artifactCoordinate;

        public DependencyEntry(int level, String artifact) {
            this.level = level;
            this.artifactCoordinate = artifact;
        }

        public int getLevel() {
            return this.level;
        }

        public String getArtifactCoordinate() {
            return this.artifactCoordinate;
        }

        public String toString() {
            return this.artifactCoordinate + " (" + this.level + ")";
        }

        public boolean equals(Object obj) {
            if (obj instanceof DependencyEntry) {
                DependencyEntry other = (DependencyEntry)obj;
                return this.getArtifactCoordinate().equals(other.getArtifactCoordinate());
            }
            return false;
        }

        public int hashCode() {
            int hash = 7;
            hash = 47 * hash + Objects.hashCode(this.artifactCoordinate);
            return hash;
        }
    }

    protected class DependencyScanner
    extends SwingWorker<String, Integer> {
        private final Path pomFile;
        private String repositoryUrl = null;
        private final File mavenInstallDir;

        protected DependencyScanner(Path pomFile, File mavenInstallDir) {
            this.pomFile = pomFile;
            this.mavenInstallDir = mavenInstallDir;
        }

        @Override
        public String doInBackground() {
            LOGGER.info((Object)"Getting dependencies...");
            MavenProjectView.this.lblStatus.setText("Deps...");
            DefaultInvocationRequest request = new DefaultInvocationRequest();
            request.setPomFile(this.pomFile.toFile());
            request.setOffline(true);
            request.setGoals(Arrays.asList("clean compile"));
            request.setBatchMode(true);
            request.setShowErrors(true);
            request.setDebug(true);
            request.setMavenOpts("-Dmaven.test.skip=true");
            DefaultInvoker invoker = new DefaultInvoker();
            invoker.setMavenHome(this.mavenInstallDir);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(baos);
            PrintStreamHandler psh = new PrintStreamHandler(ps, false);
            invoker.setOutputHandler((InvocationOutputHandler)psh);
            invoker.setErrorHandler((InvocationOutputHandler)psh);
            String output = "";
            try {
                InvocationResult result = invoker.execute((InvocationRequest)request);
                ps.flush();
                if (result.getExitCode() == 0) {
                    output = baos.toString("UTF-8");
                    LOGGER.info((Object)"Maven terminated");
                } else {
                    CommandLineException ex = result.getExecutionException();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    ex.printStackTrace(pw);
                    JOptionPane.showMessageDialog(MavenProjectView.this, sw.toString(), ex.getMessage(), 0);
                }
            }
            catch (UnsupportedEncodingException | MavenInvocationException ex) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                ex.printStackTrace(pw);
                JOptionPane.showMessageDialog(MavenProjectView.this, sw.toString(), ex.getMessage(), 0);
            }
            if (output.length() > 0) {
                List<String> classpath = this.filterClasspath(output);
                HashMap<String, String> artifactsMapping = new HashMap<String, String>();
                classpath.forEach(s -> {
                    Map.Entry<String, String> entry = this.getArtifactMapping((String)s);
                    if (entry != null) {
                        artifactsMapping.put(entry.getKey(), entry.getValue());
                    }
                });
                MavenProjectPlugin.getInstance().setDependenciesMapping(artifactsMapping);
            }
            MavenProjectView.this.lblStatus.setText("");
            return "OK";
        }

        private List<String> filterClasspath(String input) {
            TreeSet<String> set = new TreeSet<String>();
            BufferedReader reader = new BufferedReader(new StringReader(input));
            try {
                String line = reader.readLine();
                while (line != null) {
                    if (line.contains("classpathElements") && !line.contains("project.compileClasspathElements")) {
                        if (line.startsWith("[DEBUG]")) {
                            line = line.substring("DEBUG]".length() + 1).trim();
                        }
                        line = line.substring(line.indexOf("[") + 1);
                        line = line.substring(0, line.length() - 1);
                        String[] entries = line.split(", ");
                        LOGGER.debug((Object)("found " + entries.length + " entries"));
                        set.addAll(Arrays.asList(entries));
                    }
                    line = reader.readLine();
                }
            }
            catch (IOException ex) {
                LOGGER.error((Object)"while filtering classpath", (Throwable)ex);
            }
            ArrayList<String> ret = new ArrayList<String>(set.size());
            ret.addAll(set);
            return ret;
        }

        @Override
        protected void done() {
            try {
                MavenProjectView.this.lblStatus.setText((String)this.get());
            }
            catch (InterruptedException | ExecutionException ex) {
                LOGGER.error((Object)ex);
            }
            LOGGER.info((Object)("repository Url: " + this.repositoryUrl));
        }

        private Map.Entry<String, String> getArtifactMapping(String classpathEntry) {
            File f = new File(classpathEntry);
            if (f.isDirectory()) {
                if (classpathEntry.endsWith("/target/classes")) {
                    File pomFile = new File(f.getParentFile().getParentFile(), "pom.xml");
                    try {
                        XdmNode node = MavenProjectView.this.proc.newDocumentBuilder().build(pomFile);
                        XPathCompiler comp = MavenProjectView.this.proc.newXPathCompiler();
                        comp.declareNamespace("pom", "http://maven.apache.org/POM/4.0.0");
                        XPathSelector sel = comp.compile("/pom:project/pom:artifactId/text()").load();
                        sel.setContextItem((XdmItem)node);
                        String artifactId = sel.evaluateSingle().getStringValue();
                        sel = comp.compile("(/pom:project/pom:groupId/text(), /pom:project/pom:parent/pom:groupId/text())[1]").load();
                        sel.setContextItem((XdmItem)node);
                        String groupId = sel.evaluateSingle().getStringValue();
                        String entry = "dependency:/" + groupId + "+" + artifactId;
                        String path = classpathEntry.replaceAll("\\\\", "/");
                        path = "file:" + (path.startsWith("/") ? "" : "/") + path + "/";
                        return new AbstractMap.SimpleEntry<String, String>(entry, path);
                    }
                    catch (SaxonApiException ex) {
                        LOGGER.error((Object)ex.getMessage(), (Throwable)ex);
                        return null;
                    }
                }
                return null;
            }
            if (classpathEntry.endsWith(".jar")) {
                try {
                    JarFile jar = new JarFile(f);
                    Enumeration<JarEntry> enumer = jar.entries();
                    while (enumer.hasMoreElements()) {
                        JarEntry entry = enumer.nextElement();
                        if (!entry.getName().endsWith("/pom.xml")) continue;
                        String[] els = entry.getName().split("/");
                        String entryName = "dependency:/" + els[2] + "+" + els[3];
                        URL url = MavenProjectView.this.pluginWorkspaceAccess.getUtilAccess().convertFileToURL(f);
                        return new AbstractMap.SimpleEntry<String, String>(entryName, "zip:" + url.toString() + "!/");
                    }
                    return null;
                }
                catch (IOException ex) {
                    LOGGER.error((Object)("while extracting pom from " + f.getAbsolutePath()), (Throwable)ex);
                    return null;
                }
            }
            return null;
        }
    }

    private class MavenJTree
    extends JTree {
        public MavenJTree() {
            ToolTipManager.sharedInstance().registerComponent(this);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            TreePath tp = this.getClosestPathForLocation(event.getX(), event.getY());
            Object o = tp.getLastPathComponent();
            if (o instanceof AbstractMavenNode) {
                AbstractMavenNode node = (AbstractMavenNode)o;
                return node.getValue();
            }
            return super.getToolTipText(event);
        }
    }

    private class EmptyTreeNode
    implements TreeNode {
        private final String value;

        public EmptyTreeNode() {
            this("EMPTY");
        }

        public EmptyTreeNode(String value) {
            this.value = value;
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            return null;
        }

        @Override
        public int getChildCount() {
            return 0;
        }

        @Override
        public TreeNode getParent() {
            return null;
        }

        @Override
        public int getIndex(TreeNode node) {
            return -1;
        }

        @Override
        public boolean getAllowsChildren() {
            return false;
        }

        @Override
        public boolean isLeaf() {
            return true;
        }

        public Enumeration children() {
            return Collections.emptyEnumeration();
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getValue();
        }
    }
}

