/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.oxygen.maven.project.support.impl.nodes;

import java.awt.Cursor;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import javax.swing.SwingWorker;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.apache.log4j.Logger;
import top.marchand.oxygen.maven.project.support.impl.nodes.HasValue;

public abstract class LazyLoadingTreeNode
extends DefaultMutableTreeNode
implements HasValue {
    private boolean loaded = false;
    private static final Logger LOGGER = Logger.getLogger(LazyLoadingTreeNode.class);

    public LazyLoadingTreeNode(Object userObject) {
        super(userObject, true);
        this.add(new DefaultMutableTreeNode("Loading...", false));
    }

    public abstract List<MutableTreeNode> loadChildren();

    protected void setChildren(List<MutableTreeNode> childs) {
        this.removeAllChildren();
        this.setAllowsChildren(childs.size() > 0);
        childs.forEach(node -> this.add((MutableTreeNode)node));
        this.loaded = true;
    }

    public void setRunning(JComponent view, boolean running) {
        if (running) {
            view.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            view.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void expandNode(final DefaultTreeModel model, final JComponent view) {
        if (this.loaded) {
            return;
        }
        SwingWorker<List<MutableTreeNode>, Void> worker = new SwingWorker<List<MutableTreeNode>, Void>(){

            @Override
            protected List<MutableTreeNode> doInBackground() throws Exception {
                LOGGER.debug((Object)("expanding " + LazyLoadingTreeNode.this.getValue()));
                LazyLoadingTreeNode.this.setRunning(view, true);
                return LazyLoadingTreeNode.this.loadChildren();
            }

            @Override
            protected void done() {
                try {
                    LOGGER.debug((Object)"\tdone");
                    LazyLoadingTreeNode.this.setChildren((List)this.get());
                    model.nodeStructureChanged(LazyLoadingTreeNode.this);
                    LazyLoadingTreeNode.this.setRunning(view, false);
                }
                catch (InterruptedException | ExecutionException ex) {
                    LOGGER.error((Object)"while setting children", (Throwable)ex);
                }
            }
        };
        worker.execute();
    }
}

