/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.oxygen.maven.project.support.impl.nodes;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.Icon;
import javax.swing.tree.TreeNode;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import top.marchand.oxygen.maven.project.support.impl.nodes.AbstractMavenNode;

public class MavenFileNode
extends AbstractMavenNode {
    private final Path file;
    private final String fileName;
    private final URL fileUrl;

    public MavenFileNode(Path file) {
        this.file = file;
        this.fileName = file.getFileName().toString();
        URL url = null;
        try {
            url = file.toUri().toURL();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        this.fileUrl = url;
    }

    @Override
    public String getValue() {
        return this.fileName;
    }

    @Override
    public Icon getIcon() {
        Object ret = PluginWorkspaceProvider.getPluginWorkspace().getImageUtilities().getIconDecoration(this.fileUrl);
        return (Icon)ret;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return null;
    }

    @Override
    public int getChildCount() {
        return 0;
    }

    @Override
    public int getIndex(TreeNode node) {
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        return false;
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public Enumeration children() {
        return Collections.emptyEnumeration();
    }

    public Path getFile() {
        return this.file;
    }

    public URL getFileUrl() {
        return this.fileUrl;
    }
}

