/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.oxygen.maven.project.support;

import java.util.StringJoiner;
import javax.swing.JComponent;
import org.apache.log4j.Logger;
import ro.sync.exml.plugin.option.OptionPagePluginExtension;
import ro.sync.exml.workspace.api.PluginWorkspace;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import top.marchand.oxygen.maven.project.support.impl.MavenOptionView;

public class MavenOptionsPage
extends OptionPagePluginExtension {
    public static final String OPTION_PREFIX = "top.marchand.maven";
    public static final String OPTION_INSTALL_DIR = "top.marchand.maven.install.dir";
    public static final String DEFAULT_MAVEN_INSTALL_DIR = "";
    public static final String OPTION_RECENT_NEW_TEMPLATES = "top.marchand.maven.recent.templates";
    public static MavenOptionsPage INSTANCE;
    private static final Logger LOGGER;
    private MavenOptionView view;

    public MavenOptionsPage() {
        if (INSTANCE != null) {
            LOGGER.warn((Object)"Multi instances of MavenOptionPage created");
        }
        INSTANCE = this;
    }

    public void apply(PluginWorkspace pluginWorkspace) {
        pluginWorkspace.getOptionsStorage().setOption(OPTION_INSTALL_DIR, this.view.getMavenInstallDir());
    }

    public void restoreDefaults() {
        this.view.setMavenInstallDir(DEFAULT_MAVEN_INSTALL_DIR);
    }

    public String getTitle() {
        return "Maven";
    }

    public JComponent init(PluginWorkspace pluginWorkspace) {
        if (this.view == null) {
            this.view = new MavenOptionView(pluginWorkspace);
        }
        this.view.setMavenInstallDir(pluginWorkspace.getOptionsStorage().getOption(OPTION_INSTALL_DIR, DEFAULT_MAVEN_INSTALL_DIR));
        return this.view;
    }

    public String getMavenInstallDir() {
        return this.expand(PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().getOption(OPTION_INSTALL_DIR, DEFAULT_MAVEN_INSTALL_DIR));
    }

    private String expand(String s) {
        return PluginWorkspaceProvider.getPluginWorkspace().getUtilAccess().expandEditorVariables(s, null);
    }

    public String getRecentTemplates() {
        return PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().getOption(OPTION_RECENT_NEW_TEMPLATES, DEFAULT_MAVEN_INSTALL_DIR);
    }

    public void setRecentTemplateName(String templateName) {
        String[] recentTemplates = this.getRecentTemplates().split(",");
        StringJoiner joiner = new StringJoiner(",");
        int pos = 0;
        joiner.add(templateName);
        ++pos;
        for (String s : recentTemplates) {
            if (templateName.equals(s)) continue;
            joiner.add(s);
            if (++pos >= 5) break;
        }
        PluginWorkspaceProvider.getPluginWorkspace().getOptionsStorage().setOption(OPTION_RECENT_NEW_TEMPLATES, joiner.toString());
    }

    static {
        LOGGER = Logger.getLogger(MavenOptionsPage.class);
    }
}

