/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.oxygen.maven.project.support.impl;

import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;
import top.marchand.oxygen.maven.project.support.MavenProjectPlugin;
import top.marchand.oxygen.maven.project.support.impl.FilteredTreeModel;
import top.marchand.oxygen.maven.project.support.impl.MavenTreeCellRenderer;
import top.marchand.oxygen.maven.project.support.impl.nodes.AbstractMavenParentNode;
import top.marchand.oxygen.maven.project.support.impl.nodes.HasIcon;
import top.marchand.oxygen.maven.project.support.impl.nodes.HasValue;
import top.marchand.oxygen.maven.project.support.impl.nodes.ImageHandler;
import top.marchand.oxygen.maven.project.support.impl.nodes.LazyLoadingTreeNode;
import top.marchand.oxygen.maven.project.support.impl.nodes.MavenFileNode;
import top.marchand.oxygen.maven.project.support.impl.nodes.MavenPackageNode;

public class DlgChooseDependencyResource
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(DlgChooseDependencyResource.class);
    private String result;
    private FilteredTreeModel treeModel;
    private AbstractAction cancelAction = null;
    private AbstractAction okAction = null;
    private JTextField dfFilter;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JButton pbCancel;
    private JButton pbOk;
    private JTree tree;

    public DlgChooseDependencyResource(Window owner) {
        super(owner, Dialog.ModalityType.APPLICATION_MODAL);
        this._initComponents();
        this.loadModel();
    }

    private void _initComponents() {
        this.setTitle("Dependency resources...");
        this.initComponents();
        this.tree.setCellRenderer(new MavenTreeCellRenderer());
        this.tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                TreePath path = event.getPath();
                if (path.getLastPathComponent() instanceof LazyLoadingTreeNode) {
                    LazyLoadingTreeNode node = (LazyLoadingTreeNode)path.getLastPathComponent();
                    node.expandNode(DlgChooseDependencyResource.this.treeModel, DlgChooseDependencyResource.this.tree);
                }
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }
        });
        this.setLocationRelativeTo(this.getParent());
    }

    public String getDependencyUrl() {
        this.result = null;
        this.setVisible(true);
        return this.result;
    }

    private void loadModel() {
        Map<String, String> map = MavenProjectPlugin.getInstance().getDependenciesMapping();
        RootDependenciesNode root = new RootDependenciesNode("Dependencies");
        map.keySet().forEach(key -> root.add(new DependencyNode((String)key, (String)map.get(key))));
        this.treeModel = new FilteredTreeModel(root){

            @Override
            public DefaultMutableTreeNode createRootNode() {
                return new RootDependenciesNode("Dependencies");
            }
        };
        this.tree.setModel(this.treeModel);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.dfFilter = new JTextField();
        this.pbOk = new JButton();
        this.pbCancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tree = new JTree();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Filter");
        this.dfFilter.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                DlgChooseDependencyResource.this.dfFilterKeyTyped(evt);
            }
        });
        this.pbOk.setText("Ok");
        this.pbOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgChooseDependencyResource.this.pbOkActionPerformed(evt);
            }
        });
        this.pbCancel.setText("Cancel");
        this.pbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgChooseDependencyResource.this.pbCancelActionPerformed(evt);
            }
        });
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                DlgChooseDependencyResource.this.treeMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.tree);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addGap(0, 319, Short.MAX_VALUE).addComponent(this.pbCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pbOk, -2, 54, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dfFilter))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.dfFilter, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 354, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pbOk).addComponent(this.pbCancel)).addContainerGap()));
        this.pack();
    }

    private void okPressed() {
        LOGGER.debug((Object)"okPressed()");
        if (this.tree.getSelectionPath() != null) {
            Object o = this.tree.getSelectionPath().getLastPathComponent();
            if (o instanceof MavenFileNode) {
                MavenFileNode mfn = (MavenFileNode)o;
                MavenPackageNode mpn = (MavenPackageNode)mfn.getParent();
                DependencyNode dn = (DependencyNode)mpn.getParent();
                this.result = "dependency:/" + dn.getValue() + "/" + mpn.getValue().replaceAll("\\.", "/") + "/" + mfn.getValue();
                this.setVisible(false);
            } else {
                LOGGER.debug((Object)("selected node is a " + o.getClass().getName()));
            }
        } else {
            LOGGER.warn((Object)"getSelectionPath is null");
        }
    }

    @Override
    protected JRootPane createRootPane() {
        this.cancelAction = new AbstractAction("Annuler"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgChooseDependencyResource.this.setVisible(false);
            }
        };
        this.okAction = new AbstractAction("Ok"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgChooseDependencyResource.this.okPressed();
            }
        };
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        JRootPane rp = new JRootPane();
        rp.registerKeyboardAction(this.cancelAction, "CANCEL", ks, 2);
        rp.registerKeyboardAction(this.okAction, "OK", KeyStroke.getKeyStroke(10, 0), 2);
        return rp;
    }

    private void pbOkActionPerformed(ActionEvent evt) {
        this.okPressed();
    }

    private void pbCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void treeMouseClicked(MouseEvent evt) {
        Object o = this.tree.getSelectionPath().getLastPathComponent();
        if (evt.getClickCount() == 2 && o instanceof MavenFileNode) {
            this.okPressed();
        }
    }

    private void dfFilterKeyTyped(KeyEvent evt) {
        this.treeModel.filter(this.dfFilter.getText());
    }

    private class DependencyNode
    extends LazyLoadingTreeNode
    implements HasValue,
    HasIcon {
        private final String label;
        private final String url;
        private final Comparator<MutableTreeNode> comp;

        public DependencyNode(String id, String url) {
            super(url);
            this.label = id.substring("dependency:/".length());
            this.url = url;
            this.comp = (o1, o2) -> {
                if (o1 instanceof AbstractMavenParentNode && o2 instanceof AbstractMavenParentNode) {
                    return o1.toString().compareTo(o2.toString());
                }
                if (o1.getClass().equals(o2.getClass())) {
                    return o1.toString().compareTo(o2.toString());
                }
                if (o1 instanceof AbstractMavenParentNode) {
                    return -1;
                }
                return 1;
            };
        }

        @Override
        public void add(MutableTreeNode newChild) {
            super.add(newChild);
            this.sortNodes();
        }

        public void sortNodes() {
            Collections.sort(this.children, this.comp);
        }

        private void loadChildrenFileProtocol(List<MutableTreeNode> ret) {
            try {
                final HashMap entries = new HashMap();
                File f = new File(new URI(this.url));
                final Path p = f.toPath();
                Files.walkFileTree(p, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path relative = p.relativize(file.getParent());
                        String packageName = relative.toString().replaceAll("[/\\\\]", ".");
                        ArrayList<MavenFileNode> files = (ArrayList<MavenFileNode>)entries.get(packageName);
                        if (files == null) {
                            files = new ArrayList<MavenFileNode>();
                            entries.put(packageName, files);
                        }
                        files.add(new MavenFileNode(file));
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        return FileVisitResult.CONTINUE;
                    }
                });
                entries.keySet().stream().map(packageName -> {
                    MavenPackageNode pack = new MavenPackageNode("".equals(packageName) ? "<default>" : packageName);
                    ((List)entries.get(packageName)).forEach(mfn -> pack.add((MutableTreeNode)mfn));
                    return pack;
                }).forEachOrdered(pack -> ret.add((MutableTreeNode)pack));
            }
            catch (IOException | URISyntaxException ex) {
                LOGGER.debug((Object)("while loading " + this.url), (Throwable)ex);
            }
        }

        private void loadChildrenZipProtocol(List<MutableTreeNode> ret) {
            LOGGER.debug((Object)("url is " + this.url));
            String validUrl = this.url.substring(4);
            validUrl = validUrl.substring(0, validUrl.length() - 2);
            LOGGER.debug((Object)("validUrl: " + validUrl));
            try {
                ZipFile zip = new ZipFile(new File(new URI(validUrl)));
                HashMap<String, MavenPackageNode> packages = new HashMap<String, MavenPackageNode>();
                Enumeration<? extends ZipEntry> enumer = zip.entries();
                while (enumer.hasMoreElements()) {
                    ZipEntry ze = enumer.nextElement();
                    if (ze.isDirectory()) {
                        String packageName = ze.getName().replaceAll("/", ".");
                        MavenPackageNode mp = new MavenPackageNode(packageName);
                        packages.put(packageName, mp);
                        continue;
                    }
                    String[] path = ze.getName().split("/");
                    StringJoiner joiner = new StringJoiner(".");
                    for (int i = 0; i < path.length - 1; ++i) {
                        joiner.add(path[i]);
                    }
                    String packageName = joiner.toString();
                    String fileName = path[path.length - 1];
                    LOGGER.debug((Object)(packageName + "/" + fileName));
                    MavenPackageNode mp = (MavenPackageNode)packages.get(packageName);
                    if (mp == null) {
                        mp = new MavenPackageNode(packageName);
                        packages.put(packageName, mp);
                    }
                    mp.addNoSort(new MavenFileNode(Paths.get(fileName, new String[0])));
                }
                packages.values().forEach(mpn -> {
                    if (mpn.getChildCount() > 0) {
                        ret.add((MutableTreeNode)mpn);
                        mpn.sortNodes();
                    }
                });
            }
            catch (IOException | URISyntaxException ex) {
                LOGGER.error((Object)("while loading resources from " + this.url), (Throwable)ex);
            }
        }

        @Override
        public List<MutableTreeNode> loadChildren() {
            ArrayList<MutableTreeNode> ret = new ArrayList<MutableTreeNode>();
            if (this.url.startsWith("file:")) {
                this.loadChildrenFileProtocol(ret);
            } else {
                this.loadChildrenZipProtocol(ret);
            }
            return ret;
        }

        @Override
        public String toString() {
            return this.getValue();
        }

        @Override
        public String getValue() {
            return this.label;
        }

        @Override
        public Icon getIcon() {
            return ImageHandler.getInstance().get("Maven2Icon.gif");
        }

        @Override
        public Object clone() {
            DependencyNode ret = (DependencyNode)super.clone();
            Enumeration<TreeNode> enumer = this.children();
            while (enumer.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)enumer.nextElement();
                ret.add((MutableTreeNode)child.clone());
            }
            return ret;
        }
    }

    private class RootDependenciesNode
    extends AbstractMavenParentNode {
        private final String label;

        public RootDependenciesNode(String label) {
            this.label = label;
        }

        @Override
        public String getValue() {
            return this.label;
        }

        @Override
        public Icon getIcon() {
            return null;
        }
    }
}

