/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.oxygen.maven.project.support.impl;

import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import javax.swing.AbstractAction;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import org.apache.log4j.Logger;
import ro.sync.exml.workspace.api.PluginWorkspaceProvider;
import top.marchand.oxygen.maven.project.support.MavenOptionsPage;
import top.marchand.oxygen.maven.project.support.impl.FilteredTreeModel;
import top.marchand.oxygen.maven.project.support.impl.MavenTreeCellRenderer;
import top.marchand.oxygen.maven.project.support.impl.nodes.AbstractMavenParentNode;
import top.marchand.oxygen.maven.project.support.impl.nodes.HasIcon;
import top.marchand.oxygen.maven.project.support.impl.nodes.ImageHandler;
import top.marchand.oxygen.maven.project.support.impl.nodes.MavenFileNode;

public class DlgNewFile
extends JDialog {
    private final FilteredTreeModel treeModel;
    private AbstractAction cancelAction = null;
    private AbstractAction okAction = null;
    private static final Logger LOGGER = Logger.getLogger(DlgNewFile.class);
    private final DefaultTreeModel modelToUpdate;
    private final Path targetPath;
    private final AbstractMavenParentNode node;
    private final Processor proc;
    private final TreeSelectionModel selectionModel;
    private Template currentTemplate;
    private JTextField dfFilename;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JButton pbCancel;
    private JButton pkOk;
    private JTree tree;

    public DlgNewFile(Window owner, Path targetpath, AbstractMavenParentNode node, DefaultTreeModel modelToUpdate, Processor proc) {
        super(owner, Dialog.ModalityType.APPLICATION_MODAL);
        this.targetPath = targetpath;
        this.node = node;
        this.modelToUpdate = modelToUpdate;
        this.proc = proc;
        this.selectionModel = new DefaultTreeSelectionModel();
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode();
        this.treeModel = new FilteredTreeModel(rootNode){

            @Override
            public DefaultMutableTreeNode createRootNode() {
                return new DefaultMutableTreeNode();
            }
        };
        this._initComponents();
    }

    private void _initComponents() {
        this.setTitle("New File...");
        this.initComponents();
        this.tree.setCellRenderer(new MavenTreeCellRenderer());
        this.setLocationRelativeTo(this.getParent());
        this.loadModel();
        this.selectionModel.setSelectionMode(1);
        this.tree.setSelectionModel(this.selectionModel);
        this.tree.addTreeSelectionListener(e -> {
            TreePath lead = e.getPath();
            if (lead != null && this.tree.isPathSelected(lead)) {
                Object o = ((DefaultMutableTreeNode)lead.getLastPathComponent()).getUserObject();
                if (o instanceof Template) {
                    this.currentTemplate = (Template)o;
                    String filename = this.currentTemplate.getFilename();
                    if (filename == null || filename.isEmpty()) {
                        filename = "no-name." + this.currentTemplate.getExtension();
                    }
                    this.dfFilename.setText(filename);
                } else {
                    this.currentTemplate = null;
                }
            } else {
                this.dfFilename.setText("");
                this.currentTemplate = null;
            }
        });
    }

    protected void loadModel() {
        TemplateContainerTreeNode recentsNode = new TemplateContainerTreeNode("Recents", true);
        TemplateContainerTreeNode templatesNode = new TemplateContainerTreeNode("Templates", true);
        InputStream is = this.getClass().getResourceAsStream("/top/marchand/oxygen/templates/templates.xml");
        if (is == null) {
            LOGGER.error((Object)"templates.xml not found.");
            return;
        }
        try {
            String[] recent;
            XdmNode rootNode = this.proc.newDocumentBuilder().build((Source)new StreamSource(is));
            XPathSelector xps = this.proc.newXPathCompiler().compile("/templates/template").load();
            HashMap<String, Template> templates = new HashMap<String, Template>();
            xps.setContextItem((XdmItem)rootNode);
            for (XdmNode tp2 : xps.evaluate()) {
                Template template = new Template();
                XdmSequenceIterator childs = tp2.axisIterator(Axis.CHILD);
                block19: while (childs.hasNext()) {
                    XdmNode child = (XdmNode)childs.next();
                    if (!XdmNodeKind.ELEMENT.equals((Object)child.getNodeKind())) continue;
                    switch (child.getNodeName().getLocalName()) {
                        case "name": {
                            template.setName(child.getStringValue());
                            continue block19;
                        }
                        case "file": {
                            template.setFile(child.getStringValue());
                            continue block19;
                        }
                        case "description": {
                            template.setDescription(child.getStringValue());
                            continue block19;
                        }
                        case "extension": {
                            template.setExtension(child.getStringValue());
                            continue block19;
                        }
                        case "filename": {
                            template.setFilename(child.getStringValue());
                            continue block19;
                        }
                        case "icon": {
                            template.setIcon(child.getStringValue());
                            continue block19;
                        }
                    }
                    LOGGER.warn((Object)("Unexpected node in templates : " + child.getNodeName()));
                }
                if (template.getName() != null && template.getFile() != null) {
                    templates.put(template.getName(), template);
                    continue;
                }
                LOGGER.warn((Object)"template node doesn't have name");
            }
            for (String s : recent = MavenOptionsPage.INSTANCE.getRecentTemplates().split(",")) {
                Template tr = (Template)templates.get(s);
                if (tr == null) continue;
                recentsNode.add(new TemplateTreeNode(tr, false));
            }
            templates.values().forEach(tp -> templatesNode.add(new TemplateTreeNode(tp, false)));
        }
        catch (SaxonApiException ex) {
            LOGGER.error((Object)"while loading templates model", (Throwable)ex);
        }
        ((DefaultMutableTreeNode)this.treeModel.getRoot()).add(recentsNode);
        ((DefaultMutableTreeNode)this.treeModel.getRoot()).add(templatesNode);
        this.tree.setModel(this.treeModel);
        this.tree.expandPath(new TreePath(new Object[]{this.treeModel.getRoot(), recentsNode}));
        this.tree.expandPath(new TreePath(new Object[]{this.treeModel.getRoot(), templatesNode}));
        LOGGER.info((Object)"template model loaded");
    }

    private void initComponents() {
        this.pkOk = new JButton();
        this.pbCancel = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tree = new JTree();
        this.jLabel2 = new JLabel();
        this.dfFilename = new JTextField();
        this.setDefaultCloseOperation(2);
        this.pkOk.setText("Ok");
        this.pkOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgNewFile.this.okPressed(evt);
            }
        });
        this.pbCancel.setText("Cancel");
        this.pbCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgNewFile.this.cancelPressed(evt);
            }
        });
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.jScrollPane1.setViewportView(this.tree);
        this.jLabel2.setText("File name");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dfFilename, -2, 229, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pbCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pkOk, -2, 53, -2)).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 292, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pkOk).addComponent(this.pbCancel).addComponent(this.jLabel2).addComponent(this.dfFilename, -2, -1, -2))));
        this.pack();
    }

    private void okPressed(ActionEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        Path fileToCreate = this.targetPath.resolve(this.dfFilename.getText());
        if (fileToCreate.toFile().exists()) {
            JOptionPane.showMessageDialog(this, "This file already exists:\n" + fileToCreate.toString(), "File already exists", 2);
            this.dfFilename.requestFocus();
            return;
        }
        try (OutputStream wr = Files.newOutputStream(fileToCreate, new OpenOption[0]);
             InputStream is = this.getClass().getResourceAsStream(this.currentTemplate.getFile());){
            byte[] buffer = new byte[2048];
            int read = is.read(buffer);
            while (read > 0) {
                wr.write(buffer, 0, read);
                read = is.read(buffer);
            }
        }
        catch (IOException ex) {
            LOGGER.error((Object)("While creating " + fileToCreate.toString()), (Throwable)ex);
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error creating " + fileToCreate.toString(), 0);
            this.setCursor(Cursor.getDefaultCursor());
            return;
        }
        MavenOptionsPage.INSTANCE.setRecentTemplateName(this.currentTemplate.getName());
        MavenFileNode fileNode = new MavenFileNode(fileToCreate);
        this.node.add(fileNode);
        PluginWorkspaceProvider.getPluginWorkspace().open(fileNode.getFileUrl());
        this.setCursor(Cursor.getDefaultCursor());
        this.setVisible(false);
        this.modelToUpdate.nodeStructureChanged(this.node);
    }

    private void cancelPressed(ActionEvent evt) {
        this.setVisible(false);
    }

    @Override
    protected JRootPane createRootPane() {
        this.cancelAction = new AbstractAction("Annuler"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DlgNewFile.this.setVisible(false);
            }
        };
        this.okAction = new AbstractAction("Ok"){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgNewFile.this.okPressed(e);
            }
        };
        KeyStroke ks = KeyStroke.getKeyStroke(27, 0);
        JRootPane rp = new JRootPane();
        rp.registerKeyboardAction(this.cancelAction, "CANCEL", ks, 2);
        rp.registerKeyboardAction(this.okAction, "OK", KeyStroke.getKeyStroke(10, 0), 2);
        return rp;
    }

    private class TemplateContainerTreeNode
    extends DefaultMutableTreeNode
    implements HasIcon {
        public TemplateContainerTreeNode(Object userObject) {
            super(userObject);
        }

        public TemplateContainerTreeNode(Object userObject, boolean allowsChildren) {
            super(userObject, allowsChildren);
        }

        @Override
        public Icon getIcon() {
            return ((DefaultTreeCellRenderer)DlgNewFile.this.tree.getCellRenderer()).getOpenIcon();
        }
    }

    private class TemplateTreeNode
    extends DefaultMutableTreeNode
    implements HasIcon {
        public TemplateTreeNode(Object userObject) {
            super(userObject);
        }

        public TemplateTreeNode(Object userObject, boolean allowsChildren) {
            super(userObject, allowsChildren);
        }

        @Override
        public Icon getIcon() {
            if (this.getUserObject() instanceof HasIcon) {
                return ((HasIcon)this.getUserObject()).getIcon();
            }
            return null;
        }
    }

    private class Template
    implements HasIcon {
        private String name;
        private String file;
        private String description;
        private String extension;
        private String filename;
        private String icon;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getFile() {
            return this.file;
        }

        public void setFile(String file) {
            this.file = file;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public String getExtension() {
            return this.extension;
        }

        public void setExtension(String extension) {
            this.extension = extension;
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        @Override
        public Icon getIcon() {
            if (this.icon != null) {
                return ImageHandler.getInstance().get(this.icon);
            }
            return null;
        }

        public void setIcon(String icon) {
            this.icon = icon;
        }

        public String toString() {
            return this.name + (this.description != null ? " [" + this.description + "]" : "");
        }
    }
}

