/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.oxygen.maven.project.support.impl;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import ro.sync.exml.workspace.api.PluginWorkspace;

public class MavenOptionView
extends JPanel {
    private final PluginWorkspace pluginWorkspace;
    private String installDirReport;
    private static final Logger LOGGER = Logger.getLogger(MavenOptionView.class);
    private JTextField dfMavenInstallDir;
    private JLabel famfamLink;
    private JLabel jLabel2;
    private JLabel lblMavenDir;
    private JLabel lblReport;
    private JButton pbChooseInstallDir;

    public MavenOptionView(PluginWorkspace pluginWorkspace) {
        this.pluginWorkspace = pluginWorkspace;
        this.initComponents();
    }

    public void setMavenInstallDir(String location) {
        this.dfMavenInstallDir.setText(location);
    }

    public String getMavenInstallDir() {
        return this.dfMavenInstallDir.getText();
    }

    private void initComponents() {
        this.lblMavenDir = new JLabel();
        this.dfMavenInstallDir = new JTextField();
        this.pbChooseInstallDir = new JButton();
        this.lblReport = new JLabel();
        this.famfamLink = new JLabel();
        this.jLabel2 = new JLabel();
        this.lblMavenDir.setText("Maven install directory");
        this.dfMavenInstallDir.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                MavenOptionView.this.dfMavenInstallDirFocusGained(evt);
            }
        });
        this.dfMavenInstallDir.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MavenOptionView.this.dfMavenInstallDirPropertyChange(evt);
            }
        });
        this.pbChooseInstallDir.setText("...");
        this.pbChooseInstallDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MavenOptionView.this.pbChooseInstallDirActionPerformed(evt);
            }
        });
        this.famfamLink.setText("Some icons are from mjames@gmail.com");
        this.famfamLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                MavenOptionView.this.famfamLinkMouseClicked(evt);
            }
        });
        this.jLabel2.setForeground(new Color(0, 102, 255));
        this.jLabel2.setText("http://www.famfamfam.com/lab/icons/silk/");
        this.jLabel2.setCursor(new Cursor(12));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.famfamLink).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lblReport, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.lblMavenDir).addGap(25, 25, 25).addComponent(this.dfMavenInstallDir, -1, 272, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pbChooseInstallDir, -2, 46, -2).addGap(2, 2, 2)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lblMavenDir).addComponent(this.dfMavenInstallDir, -2, -1, -2).addComponent(this.pbChooseInstallDir)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lblReport, -2, 20, -2).addComponent(this.famfamLink)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void pbChooseInstallDirActionPerformed(ActionEvent evt) {
        String ret = this.getDirectory("Maven install directory");
        if (ret != null && !ret.isEmpty()) {
            this.dfMavenInstallDir.setText(ret);
        }
    }

    private String getDirectory(String title) {
        JFileChooser chooser = new JFileChooser();
        chooser.setCurrentDirectory(new File("."));
        chooser.setDialogTitle("Maven installation  directory");
        chooser.setFileSelectionMode(1);
        chooser.setAcceptAllFileFilterUsed(false);
        if (chooser.showOpenDialog(this) == 0) {
            return chooser.getSelectedFile().toURI().toString();
        }
        return null;
    }

    private void dfMavenInstallDirPropertyChange(PropertyChangeEvent evt) {
        try {
            String text = this.pluginWorkspace.getUtilAccess().expandEditorVariables(this.dfMavenInstallDir.getText(), null);
            if (text == null || text.isEmpty()) {
                this.installDirReport = "Maven install directory must be defined";
                this.setErrorMarker(this.dfMavenInstallDir, true);
            } else {
                URI uri = new URI(text);
                this.setErrorMarker(this.dfMavenInstallDir, false);
                this.installDirReport = text;
                this.dfMavenInstallDirFocusGained(null);
            }
        }
        catch (URISyntaxException ex) {
            this.installDirReport = ex.getLocalizedMessage();
            this.setErrorMarker(this.dfMavenInstallDir, true);
        }
    }

    private void dfMavenInstallDirFocusGained(FocusEvent evt) {
        this.lblReport.setText(this.installDirReport);
    }

    private void famfamLinkMouseClicked(MouseEvent evt) {
        Desktop desktop;
        Desktop desktop2 = desktop = Desktop.isDesktopSupported() ? Desktop.getDesktop() : null;
        if (desktop != null && desktop.isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(new URI(this.famfamLink.getText()));
            }
            catch (IOException | URISyntaxException e) {
                LOGGER.error((Object)"Opening famfam link");
            }
        }
    }

    private void setErrorMarker(JTextField fld, boolean isError) {
        if (isError) {
            fld.setBackground(Color.red);
        } else {
            fld.setBackground(UIManager.getColor("TextField.background"));
        }
    }
}

