/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.oxygen.maven.project.support.impl.nodes;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.UIManager;
import top.marchand.oxygen.maven.project.support.impl.nodes.AbstractMavenParentNode;
import top.marchand.oxygen.maven.project.support.impl.nodes.ImageHandler;
import top.marchand.oxygen.maven.project.support.impl.nodes.MavenFileNode;
import top.marchand.oxygen.maven.project.support.impl.nodes.MavenPackageNode;

public class MavenDirectoryNode
extends AbstractMavenParentNode {
    private final String value;
    private final Path directory;
    private final HashMap<String, MavenPackageNode> packages;
    private static final List<String> VALID_PARENT_DIRS = Arrays.asList("main", "site", "test");

    public MavenDirectoryNode(Path directory) {
        this.directory = directory;
        this.value = directory.getName(directory.getNameCount() - 1).toString();
        this.packages = new HashMap();
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Icon getIcon() {
        if (this.getParent() != null && VALID_PARENT_DIRS.contains(this.getParent().toString())) {
            switch (this.getValue().toLowerCase()) {
                case "ant": {
                    return ImageHandler.getInstance().get("AntIcon16.png");
                }
                case "css": {
                    return ImageHandler.getInstance().get("CssIcon16.png");
                }
                case "dtd": {
                    return ImageHandler.getInstance().get("DtdIcon16.png");
                }
                case "epub": {
                    return ImageHandler.getInstance().get("EpubIcon16.png");
                }
                case "fo": {
                    return ImageHandler.getInstance().get("FoIcon16.png");
                }
                case "gaulois": 
                case "pipes": 
                case "pipe": {
                    return ImageHandler.getInstance().get("gaulois2.png");
                }
                case "html": {
                    return ImageHandler.getInstance().get("HtmlIcon16.png");
                }
                case "js": 
                case "javascript": {
                    return ImageHandler.getInstance().get("JsIcon16.png");
                }
                case "json": {
                    return ImageHandler.getInstance().get("JsonIcon16.png");
                }
                case "md": {
                    return ImageHandler.getInstance().get("MDIcon16.png");
                }
                case "nvdl": {
                    return ImageHandler.getInstance().get("NVDLIcon16.png");
                }
                case "rnc": {
                    return ImageHandler.getInstance().get("RncIcon16.png");
                }
                case "grammars": 
                case "xsd": 
                case "rng": {
                    return ImageHandler.getInstance().get("RngIcon16.png");
                }
                case "sch": {
                    return ImageHandler.getInstance().get("SchIcon16.png");
                }
                case "sql": {
                    return ImageHandler.getInstance().get("SqlIcon16.png");
                }
                case "wsdl": {
                    return ImageHandler.getInstance().get("WsdlIcon16.png");
                }
                case "xproc": {
                    return ImageHandler.getInstance().get("XProcIcon16.png");
                }
                case "xspec": {
                    return ImageHandler.getInstance().get("XSpecIcon16.png");
                }
                case "xsl": {
                    return ImageHandler.getInstance().get("XslIcon16.png");
                }
            }
        }
        if (this.isLeaf()) {
            return (Icon)UIManager.get("Tree.closedIcon");
        }
        return null;
    }

    public Path getDirectory() {
        return this.directory;
    }

    public void addPackageEntry(String packageName, Path file) {
        MavenPackageNode pack = this.packages.get(packageName);
        if (pack == null) {
            pack = new MavenPackageNode(packageName);
            this.packages.put(packageName, pack);
            this.add(pack);
        }
        pack.add(new MavenFileNode(file));
    }

    @Override
    public void removeAllChildren() {
        super.removeAllChildren();
        this.packages.clear();
    }
}

