/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.xml.extfunctions.basex;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import org.basex.examples.api.BaseXClient;

public class BaseXQuery
extends ExtensionFunctionDefinition {
    public static final String EXT_NAMESPACE_URI = "top:marchand:xml:extfunctions";
    public static final String FUNCTION_NAME = "basex-query";
    public static final String EXT_NS_COMMON_PREFIX = "efl-ext";

    public StructuredQName getFunctionQName() {
        return new StructuredQName(EXT_NS_COMMON_PREFIX, EXT_NAMESPACE_URI, FUNCTION_NAME);
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public Sequence call(XPathContext xpc, Sequence[] sqncs) throws XPathException {
                String xquery = ((StringValue)sqncs[0].head()).getStringValue();
                TinyElementImpl basexNode = (TinyElementImpl)sqncs[1].head();
                String server = null;
                String port = null;
                String user = null;
                String password = null;
                Processor proc = new Processor(xpc.getConfiguration());
                AxisIterator iterator = basexNode.iterateAxis((byte)3);
                NodeInfo ni = iterator.next();
                while (ni != null) {
                    switch (ni.getLocalPart()) {
                        case "server": {
                            server = ni.getStringValue();
                            break;
                        }
                        case "port": {
                            port = ni.getStringValue();
                            break;
                        }
                        case "user": {
                            user = ni.getStringValue();
                            break;
                        }
                        case "password": {
                            password = ni.getStringValue();
                            break;
                        }
                        default: {
                            throw new XPathException("child elements of basex must be server, port, user and password");
                        }
                    }
                    ni = iterator.next();
                }
                try {
                    BaseXClient session = new BaseXClient(server, Integer.parseInt(port), user, password);
                    ArrayList result = new ArrayList();
                    DocumentBuilder builder = proc.newDocumentBuilder();
                    BaseXClient.Query query = session.query(xquery);
                    BaseXSequenceIterator it = new BaseXSequenceIterator(query, builder);
                    return new LazySequence((SequenceIterator)it);
                }
                catch (IOException ex) {
                    throw new XPathException((Throwable)ex);
                }
            }
        };
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING, SequenceType.SINGLE_ELEMENT_NODE};
    }

    public SequenceType getResultType(SequenceType[] sts) {
        return SequenceType.ANY_SEQUENCE;
    }

    private class BaseXSequenceIterator
    implements SequenceIterator,
    AutoCloseable {
        private final BaseXClient.Query query;
        private final DocumentBuilder builder;

        public BaseXSequenceIterator(BaseXClient.Query query, DocumentBuilder builder) {
            this.query = query;
            this.builder = builder;
        }

        public Item next() throws XPathException {
            try {
                if (this.query.more()) {
                    StreamSource source = new StreamSource(new ByteArrayInputStream(this.query.next().getBytes(BaseXClient.UTF8)));
                    XdmNode node = this.builder.build((Source)source);
                    return node.getUnderlyingNode();
                }
                return null;
            }
            catch (IOException | SaxonApiException ex) {
                throw new XPathException(ex);
            }
        }

        @Override
        public void close() {
            try {
                this.query.close();
            }
            catch (IOException ex) {
                Logger.getLogger(BaseXQuery.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        public SequenceIterator getAnother() throws XPathException {
            return null;
        }

        public int getProperties() {
            return 0;
        }
    }
}

