/*
 * Decompiled with CFR 0.152.
 */
package org.basex.examples.api;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;

public final class BaseXClient
implements Closeable {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    private final OutputStream out;
    private final BufferedInputStream in;
    private final Socket socket = new Socket();
    private String info;

    public BaseXClient(String host, int port, String username, String password) throws IOException {
        String nonce;
        String code;
        this.socket.connect(new InetSocketAddress(host, port), 5000);
        this.in = new BufferedInputStream(this.socket.getInputStream());
        this.out = this.socket.getOutputStream();
        String[] response = this.receive().split(":");
        if (response.length > 1) {
            code = username + ':' + response[0] + ':' + password;
            nonce = response[1];
        } else {
            code = password;
            nonce = response[0];
        }
        this.send(username);
        this.send(BaseXClient.md5(BaseXClient.md5(code) + nonce));
        if (!this.ok()) {
            throw new IOException("Access denied.");
        }
    }

    public void execute(String command, OutputStream output) throws IOException {
        this.send(command);
        BaseXClient.receive(this.in, output);
        this.info = this.receive();
        if (!this.ok()) {
            throw new IOException(this.info);
        }
    }

    public String execute(String command) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.execute(command, os);
        return new String(os.toByteArray(), UTF8);
    }

    public Query query(String query) throws IOException {
        return new Query(query);
    }

    public void create(String name, InputStream input) throws IOException {
        this.send(8, name, input);
    }

    public void add(String path, InputStream input) throws IOException {
        this.send(9, path, input);
    }

    public void replace(String path, InputStream input) throws IOException {
        this.send(12, path, input);
    }

    public void store(String path, InputStream input) throws IOException {
        this.send(13, path, input);
    }

    public String info() {
        return this.info;
    }

    @Override
    public void close() throws IOException {
        this.send("exit");
        this.out.flush();
        this.socket.close();
    }

    private boolean ok() throws IOException {
        this.out.flush();
        return this.in.read() == 0;
    }

    private String receive() throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        BaseXClient.receive(this.in, os);
        return new String(os.toByteArray(), UTF8);
    }

    private void send(String string) throws IOException {
        this.out.write((string + '\u0000').getBytes(UTF8));
    }

    private static void receive(InputStream input, OutputStream output) throws IOException {
        int b;
        while ((b = input.read()) > 0) {
            output.write(b == 255 ? input.read() : b);
        }
    }

    private void send(int code, String path, InputStream input) throws IOException {
        this.out.write(code);
        this.send(path);
        this.send(input);
    }

    private void send(InputStream input) throws IOException {
        int b;
        BufferedInputStream bis = new BufferedInputStream(input);
        BufferedOutputStream bos = new BufferedOutputStream(this.out);
        while ((b = bis.read()) != -1) {
            if (b == 0 || b == 255) {
                bos.write(255);
            }
            bos.write(b);
        }
        bos.write(0);
        bos.flush();
        this.info = this.receive();
        if (!this.ok()) {
            throw new IOException(this.info);
        }
    }

    private static String md5(String pw) {
        StringBuilder sb = new StringBuilder();
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(pw.getBytes());
            for (byte b : md.digest()) {
                String s = Integer.toHexString(b & 0xFF);
                if (s.length() == 1) {
                    sb.append('0');
                }
                sb.append(s);
            }
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace(System.err);
        }
        return sb.toString();
    }

    public class Query {
        private final String id;
        private ArrayList<byte[]> cache;
        private int pos;

        Query(String query) throws IOException {
            this.id = this.exec(0, query);
        }

        public void bind(String name, String value) throws IOException {
            this.bind(name, value, "");
        }

        public void bind(String name, String value, String type) throws IOException {
            this.cache = null;
            this.exec(3, this.id + '\u0000' + name + '\u0000' + value + '\u0000' + type);
        }

        public void context(String value) throws IOException {
            this.context(value, "");
        }

        public void context(String value, String type) throws IOException {
            this.cache = null;
            this.exec(14, this.id + '\u0000' + value + '\u0000' + type);
        }

        public boolean more() throws IOException {
            if (this.cache == null) {
                BaseXClient.this.out.write(4);
                BaseXClient.this.send(this.id);
                this.cache = new ArrayList();
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                while (BaseXClient.this.in.read() > 0) {
                    BaseXClient.receive(BaseXClient.this.in, os);
                    this.cache.add(os.toByteArray());
                    os.reset();
                }
                if (!BaseXClient.this.ok()) {
                    throw new IOException(BaseXClient.this.receive());
                }
                this.pos = 0;
            }
            if (this.pos < this.cache.size()) {
                return true;
            }
            this.cache = null;
            return false;
        }

        public String next() throws IOException {
            String string;
            if (this.more()) {
                int n = this.pos++;
                string = new String((byte[])this.cache.set(n, null), UTF8);
            } else {
                string = null;
            }
            return string;
        }

        public String execute() throws IOException {
            return this.exec(5, this.id);
        }

        public String info() throws IOException {
            return this.exec(6, this.id);
        }

        public String options() throws IOException {
            return this.exec(7, this.id);
        }

        public void close() throws IOException {
            this.exec(2, this.id);
        }

        private String exec(int code, String arg) throws IOException {
            BaseXClient.this.out.write(code);
            BaseXClient.this.send(arg);
            String s = BaseXClient.this.receive();
            if (!BaseXClient.this.ok()) {
                throw new IOException(BaseXClient.this.receive());
            }
            return s;
        }
    }
}

