/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.xml.extfunctions.basex;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.lib.ExtensionFunctionCall;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.LazySequence;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;
import org.basex.examples.api.BaseXClient;

public class BaseXQuery
extends ExtensionFunctionDefinition {
    public static final String EXT_NAMESPACE_URI = "top:marchand:xml:extfunctions";
    public static final String FUNCTION_NAME = "basex-query";
    public static final String EXT_NS_COMMON_PREFIX = "efl-ext";

    public StructuredQName getFunctionQName() {
        return new StructuredQName(EXT_NS_COMMON_PREFIX, EXT_NAMESPACE_URI, FUNCTION_NAME);
    }

    public ExtensionFunctionCall makeCallExpression() {
        return new ExtensionFunctionCall(){

            public Sequence call(XPathContext xpc, Sequence[] sqncs) throws XPathException {
                String[] args = this.checkArgs(xpc, sqncs);
                String xquery = args[0];
                String server = args[1];
                String port = args[2];
                String user = args[3];
                String password = args[4];
                Processor proc = new Processor(xpc.getConfiguration());
                try {
                    BaseXClient session = new BaseXClient(server, Integer.parseInt(port), user, password);
                    DocumentBuilder builder = proc.newDocumentBuilder();
                    BaseXClient.Query query = session.query(xquery);
                    BaseXSequenceIterator it = new BaseXSequenceIterator(query, builder, session);
                    return new LazySequence((SequenceIterator)it);
                }
                catch (IOException ex) {
                    throw new XPathException((Throwable)ex);
                }
            }

            private String[] checkArgs(XPathContext xpc, Sequence[] sqncs) throws XPathException {
                if (sqncs.length == 2) {
                    String server = null;
                    String port = null;
                    String user = null;
                    String password = null;
                    try {
                        TinyElementImpl basexNode = (TinyElementImpl)sqncs[1].head();
                        AxisIterator iterator = basexNode.iterateAxis((byte)3);
                        NodeInfo ni = iterator.next();
                        while (ni != null) {
                            if (ni.getNodeKind() == 1) {
                                switch (ni.getLocalPart()) {
                                    case "server": {
                                        server = ni.getStringValue();
                                        break;
                                    }
                                    case "port": {
                                        port = ni.getStringValue();
                                        break;
                                    }
                                    case "user": {
                                        user = ni.getStringValue();
                                        break;
                                    }
                                    case "password": {
                                        password = ni.getStringValue();
                                        break;
                                    }
                                    default: {
                                        throw new XPathException("child elements of basex must be server, port, user and password");
                                    }
                                }
                            }
                            ni = iterator.next();
                        }
                        return new String[]{((StringValue)sqncs[0].head()).getStringValue(), server, port, user, password};
                    }
                    catch (ClassCastException ex) {
                        throw new XPathException("In two prameters signature, second parameter must be a element()");
                    }
                }
                if (sqncs.length == 5) {
                    try {
                        return new String[]{((StringValue)sqncs[0].head()).getStringValue(), ((StringValue)sqncs[1].head()).getStringValue(), ((StringValue)sqncs[2].head()).getStringValue(), ((StringValue)sqncs[3].head()).getStringValue(), ((StringValue)sqncs[4].head()).getStringValue()};
                    }
                    catch (ClassCastException ex) {
                        throw new XPathException("in 5 parameters signature, all parameters must be xs:string");
                    }
                }
                throw new XPathException("Illegal number of arguments. Args are either (xs:string, element(basex)), or (xs:string, xs:string, xs:string, xs:string, xs:string)");
            }
        };
    }

    public SequenceType[] getArgumentTypes() {
        return new SequenceType[]{SequenceType.SINGLE_STRING, SequenceType.SINGLE_ITEM, SequenceType.OPTIONAL_STRING, SequenceType.OPTIONAL_STRING, SequenceType.OPTIONAL_STRING};
    }

    public SequenceType getResultType(SequenceType[] sts) {
        return SequenceType.ANY_SEQUENCE;
    }

    public int getMinimumNumberOfArguments() {
        return 2;
    }

    public int getMaximumNumberOfArguments() {
        return 5;
    }

    protected class BaseXSequenceIterator
    implements SequenceIterator,
    AutoCloseable {
        private final BaseXClient.Query query;
        private final DocumentBuilder builder;
        private final BaseXClient session;
        private boolean closed = false;

        public BaseXSequenceIterator(BaseXClient.Query query, DocumentBuilder builder, BaseXClient session) {
            this.query = query;
            this.builder = builder;
            this.session = session;
        }

        public Item next() throws XPathException {
            try {
                if (this.query.more()) {
                    StreamSource source = new StreamSource(new ByteArrayInputStream(this.query.next().getBytes(BaseXClient.UTF8)));
                    XdmNode node = this.builder.build((Source)source);
                    return node.getUnderlyingNode();
                }
                this.close();
                return null;
            }
            catch (IOException | SaxonApiException ex) {
                throw new XPathException(ex);
            }
        }

        @Override
        public void close() {
            if (this.closed) {
                return;
            }
            try {
                System.err.println("Closing sequence iterator");
                this.closed = true;
                this.query.close();
                this.session.close();
            }
            catch (IOException ex) {
                Logger.getLogger(BaseXQuery.class.getName()).log(Level.SEVERE, null, ex);
            }
        }

        public int getProperties() {
            return 0;
        }
    }
}

