/*
 * Decompiled with CFR 0.152.
 */
package fr.efl.chaine.xslt;

import de.schlichtherle.truezip.file.TFile;
import de.schlichtherle.truezip.file.TFileInputStream;
import fr.efl.chaine.xslt.ExecutionContext;
import fr.efl.chaine.xslt.GauloisRunException;
import fr.efl.chaine.xslt.InvalidSyntaxException;
import fr.efl.chaine.xslt.SaxonConfigurationFactory;
import fr.efl.chaine.xslt.StepJava;
import fr.efl.chaine.xslt.config.CfgFile;
import fr.efl.chaine.xslt.config.ChooseStep;
import fr.efl.chaine.xslt.config.Config;
import fr.efl.chaine.xslt.config.ConfigUtil;
import fr.efl.chaine.xslt.config.JavaStep;
import fr.efl.chaine.xslt.config.Listener;
import fr.efl.chaine.xslt.config.Output;
import fr.efl.chaine.xslt.config.ParametrableStep;
import fr.efl.chaine.xslt.config.Pipe;
import fr.efl.chaine.xslt.config.Tee;
import fr.efl.chaine.xslt.config.WhenEntry;
import fr.efl.chaine.xslt.config.Xslt;
import fr.efl.chaine.xslt.listener.HttpListener;
import fr.efl.chaine.xslt.utils.ParameterValue;
import fr.efl.chaine.xslt.utils.ParametersMerger;
import fr.efl.chaine.xslt.utils.ParametrableFile;
import fr.efl.chaine.xslt.utils.TeeDebugDestination;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.lib.StandardLogger;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.MessageListener;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.TeeDestination;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import net.sf.saxon.trace.XSLTTraceListener;
import net.sf.saxon.trans.XPathException;
import org.apache.commons.io.output.NullOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlresolver.Resolver;
import top.marchand.xml.protocols.ProtocolInstaller;

public class GauloisPipe {
    private static final Logger LOGGER = LoggerFactory.getLogger(GauloisPipe.class);
    public static final String INSTANCE_DEFAULT_NAME = "instance1";
    private String instanceName;
    private Config config;
    private final Map<String, XsltExecutable> xslCache;
    private Processor processor;
    private final SaxonConfigurationFactory configurationFactory;
    private Class<MessageListener> messageListenerclass;
    private MessageListener messageListener = null;
    private XSLTTraceListener traceListener = null;
    private DocumentCache documentCache;
    private XsltCompiler xsltCompiler;
    private DocumentBuilder builder = null;
    private URIResolver uriResolver;
    private static transient boolean protocolInstalled = false;
    private List<Exception> errors;
    private XPathCompiler xpathCompiler;
    private static final transient String USAGE_PROMPT = "\nUSAGE:\njava " + GauloisPipe.class.getName() + "\n" + "\t--config config.xml\tthe config file to use\n" + "\t--msg-listener package.of.MessageListener The class to use as MessageListener\n" + "\t{--instance-name | -iName} <name>\t\tthe instance name to use in logs\n" + "\t{--output | -o} <outputfile>\t\t\toutput directory\n" + "\t{--nbthreads | -n} <n>\t\t\tnumber of threads to use\n" + "\t{--logFileSize}\t\t\tdisplays intput and output files size in logs as INFO\n" + "\txsl_file[ xsl_file]*\t\tthe XSLs to pipe\n" + "\t[PARAMS p1=xxx[ p2=yyy]*]\tthe params to give to XSLs\n" + "\tFILES file1[ filen]*\t\tthe files to apply pipe on\n.\n" + "\tAn XSL may be specified as this, if it needs specials parameters :\n" + "\t\txsl_file(param1=value1,param2=value2,...)\n" + "\tA source file may be specified as this, if it needs special parameters :\n" + "\t\tfile(param1=value1,param2=value2,...)\n\n" + "\tIt is impossible to override via command-line option something defined in config file, but it is possible to add inputs or templates.\n" + "\tIf a MessageListener is specified, the denoted class must implement net.sf.saxon.s9api.MessageListener";
    private static final int INPUT_XSL = 0;
    private static final int INPUT_PARAMS = 1;
    private static final int INPUT_FILES = 2;
    private static final int INPUT_OUTPUT = 4;
    private static final int INPUT_THREADS = 8;
    private static final int MESSAGE_LISTENER = 15;
    private static final int INSTANCE_NAME = 16;
    private static final int CONFIG = 32;

    public GauloisPipe(SaxonConfigurationFactory configurationFactory) {
        if (!protocolInstalled) {
            ProtocolInstaller.registerAdditionalProtocols();
            protocolInstalled = true;
        }
        this.configurationFactory = configurationFactory;
        Configuration saxonConfig = configurationFactory.getConfiguration();
        saxonConfig.setURIResolver(this.getUriResolver());
        this.xslCache = new HashMap<String, XsltExecutable>();
    }

    public GauloisPipe(SaxonConfigurationFactory configurationFactory, List<String> inputs, String outputDirectory, List<String> templatePaths, int nbThreads, String instanceName) throws InvalidSyntaxException {
        this(configurationFactory);
        this.instanceName = instanceName;
        Config cfg = new Config();
        for (String input : inputs) {
            ConfigUtil.addInputFile(cfg, input);
        }
        ConfigUtil.setOutput(cfg, outputDirectory);
        for (String templatePath : templatePaths) {
            ConfigUtil.addTemplate(cfg, templatePath);
        }
        ConfigUtil.setNbThreads(cfg, Integer.toString(nbThreads));
        cfg.verify();
        this.config = cfg;
        this.documentCache = new DocumentCache(this.config.getMaxDocumentCacheSize());
    }

    public void launch() throws InvalidSyntaxException, FileNotFoundException, SaxonApiException, URISyntaxException, IOException {
        Runtime.getRuntime().addShutdownHook(new Thread(new ErrorCollector(this.errors)));
        long start = System.currentTimeMillis();
        this.errors = Collections.synchronizedList(new ArrayList());
        this.documentCache = new DocumentCache(this.config.getMaxDocumentCacheSize());
        if (this.messageListenerclass != null) {
            try {
                this.messageListener = this.messageListenerclass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                System.err.println("[WARN] Fail to instanciate " + this.messageListenerclass.getName());
                ex.printStackTrace(System.err);
            }
        }
        boolean retCode = true;
        try {
            ArrayList<ParametrableFile> files;
            Configuration saxonConfig = this.configurationFactory.getConfiguration();
            LOGGER.debug("configuration is a " + saxonConfig.getClass().getName());
            this.processor = new Processor(saxonConfig);
            this.xsltCompiler = this.processor.newXsltCompiler();
            this.builder = this.processor.newDocumentBuilder();
            List<CfgFile> sourceFiles = this.config.getSources().getFiles();
            LOGGER.info("[" + this.instanceName + "] works on {} files", (Object)sourceFiles.size());
            if (this.config.getPipe().getTraceOutput() != null) {
                this.traceListener = this.buildTraceListener(this.config.getPipe().getTraceOutput());
            }
            if (this.config.getPipe().getNbThreads() > 1) {
                if (this.config.hasFilesOverMultiThreadLimit()) {
                    files = new ArrayList(sourceFiles.size());
                    for (CfgFile f : this.config.getSources().getFilesOverLimit(this.config.getPipe().getMultithreadMaxSourceSize())) {
                        files.add(this.resolveInputFile(f));
                    }
                    if (!files.isEmpty()) {
                        LOGGER.info("[" + this.instanceName + "] Running mono-thread for {} huge files", (Object)files.size());
                        retCode = this.executesPipeOnMultiThread(this.config.getPipe(), files, 1, this.config.getSources().getListener());
                    }
                }
                files = new ArrayList(sourceFiles.size());
                for (CfgFile f : this.config.getSources().getFilesUnderLimit(this.config.getPipe().getMultithreadMaxSourceSize())) {
                    files.add(this.resolveInputFile(f));
                }
                if (!files.isEmpty() || this.config.getSources().getListener() != null) {
                    LOGGER.info("[" + this.instanceName + "] Running multi-thread for {} regular-size files", (Object)files.size());
                    retCode = this.executesPipeOnMultiThread(this.config.getPipe(), files, this.config.getPipe().getNbThreads(), this.config.getSources().getListener());
                }
            } else {
                files = new ArrayList<ParametrableFile>(sourceFiles.size());
                for (CfgFile f : sourceFiles) {
                    files.add(this.resolveInputFile(f));
                }
                LOGGER.info("[" + this.instanceName + "] Running mono-thread on all {} files", (Object)files.size());
                retCode = this.executesPipeOnMultiThread(this.config.getPipe(), files, 1, this.config.getSources().getListener());
            }
        }
        catch (Throwable e) {
            LOGGER.warn("[" + this.instanceName + "] " + e.getMessage(), e);
            throw e;
        }
        finally {
            if (!retCode) {
                throw new SaxonApiException("An error occurs. See previous logs.");
            }
        }
        try {
            if (this.config.getSources().getListener() == null) {
                long duration = System.currentTimeMillis() - start;
                Duration duree = DatatypeFactory.newInstance().newDuration(duration);
                LOGGER.info("[" + this.instanceName + "] Process terminated: " + duree.toString());
            }
        }
        catch (Exception ex) {
            LOGGER.info("[" + this.instanceName + "] Process terminated.");
        }
    }

    public int getDocumentCacheSize() {
        return this.documentCache.size();
    }

    public int getXsltCacheSize() {
        return this.xslCache.size();
    }

    private ParametrableFile resolveInputFile(CfgFile file) {
        ParametrableFile ret = new ParametrableFile(file.getSource());
        ret.getParameters().putAll(file.getParams());
        return ret;
    }

    private boolean executesPipeOnMultiThread(final Pipe pipe, List<ParametrableFile> inputs, int nbThreads, Listener listener) {
        ExecutorService service;
        ExecutorService executorService = service = nbThreads == 1 ? Executors.newSingleThreadExecutor() : Executors.newFixedThreadPool(nbThreads);
        if (this.xslCache.isEmpty() && !inputs.isEmpty()) {
            try {
                XsltTransformer transformer = this.buildTransformer(pipe, inputs.get(0).getFile(), inputs.get(0).getFile().toURI().toURL().toExternalForm(), ParametersMerger.merge(inputs.get(0).getParameters(), this.config.getParams()), this.messageListener, null, new boolean[0]);
            }
            catch (InvalidSyntaxException | FileNotFoundException | MalformedURLException | URISyntaxException | SaxonApiException ex) {
                String msg = "while pre-compiling for a multi-thread use...";
                LOGGER.error(msg);
                this.errors.add(new GauloisRunException(msg, ex));
            }
        }
        Iterator<ParametrableFile> ex = inputs.iterator();
        while (ex.hasNext()) {
            ParametrableFile pf;
            final ParametrableFile fpf = pf = ex.next();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        GauloisPipe.this.execute(pipe, fpf, GauloisPipe.this.messageListener);
                    }
                    catch (InvalidSyntaxException | FileNotFoundException | MalformedURLException | URISyntaxException | SaxonApiException ex) {
                        String msg = "[" + GauloisPipe.this.instanceName + "] while processing " + fpf.getFile().getName();
                        LOGGER.error(msg, ex);
                        GauloisPipe.this.errors.add(new GauloisRunException(msg, fpf.getFile()));
                    }
                }
            };
            service.execute(r);
        }
        if (listener == null) {
            service.shutdown();
            try {
                service.awaitTermination(5L, TimeUnit.HOURS);
                return true;
            }
            catch (InterruptedException ex2) {
                LOGGER.error("[" + this.instanceName + "] multi-thread processing interrupted, 5 hour limit exceed.");
                return false;
            }
        }
        ExecutionContext context = new ExecutionContext(this, pipe, this.messageListener, service);
        final HttpListener httpListener = new HttpListener(listener.getPort(), listener.getStopKeyword(), context);
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                httpListener.run();
            }
        };
        new Thread(runner).start();
        return true;
    }

    @Deprecated
    private boolean executesPipeOnMonoThread(Pipe pipe, List<ParametrableFile> inputs) {
        boolean ret = true;
        for (ParametrableFile inputFile : inputs) {
            try {
                this.execute(pipe, inputFile, this.messageListener);
            }
            catch (InvalidSyntaxException | FileNotFoundException | MalformedURLException | URISyntaxException | SaxonApiException ex) {
                LOGGER.error("[" + this.instanceName + "] while mono-thread processing of " + inputFile.getFile().getName(), ex);
                ret = false;
            }
        }
        return ret;
    }

    public List<Exception> getErrors() {
        return this.errors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Pipe pipe, ParametrableFile input, MessageListener listener) throws SaxonApiException, MalformedURLException, InvalidSyntaxException, URISyntaxException, FileNotFoundException {
        boolean avoidCache = input.getAvoidCache();
        long start = System.currentTimeMillis();
        String key = input.getFile().getAbsolutePath().intern();
        XdmNode source = (XdmNode)this.documentCache.get(key);
        if (source == null || avoidCache) {
            if (!avoidCache && this.documentCache.isLoading(this.instanceName)) {
                source = this.documentCache.waitForLoading(key);
            }
            if (source == null || avoidCache) {
                String string = key;
                synchronized (string) {
                    if (!avoidCache) {
                        source = (XdmNode)this.documentCache.get(key);
                    }
                    if (source == null) {
                        this.documentCache.setLoading(key);
                        if (this.config.isLogFileSize()) {
                            LOGGER.info("[" + this.instanceName + "] " + input.toString() + " as input: " + input.getFile().length());
                        }
                        source = this.builder.build(input.getFile());
                        if (!avoidCache && this.config.getSources().getFileUsage(input.getFile()) > 1) {
                            LOGGER.debug("[" + this.instanceName + "] caching " + key);
                            this.documentCache.put(key, source);
                        } else {
                            this.documentCache.ignoreLoading(key);
                            if (avoidCache) {
                                LOGGER.trace("[" + this.instanceName + "] " + key + " exclued from cache");
                            } else {
                                LOGGER.trace("[" + this.instanceName + "] " + key + " used only once, no cache");
                            }
                        }
                    }
                }
            }
        }
        HashMap<String, ParameterValue> parameters = ParametersMerger.addInputInParameters(ParametersMerger.merge(input.getParameters(), this.config.getParams()), input.getFile());
        XsltTransformer transformer = this.buildTransformer(pipe, input.getFile(), input.getFile().toURI().toURL().toExternalForm(), parameters, listener, source, new boolean[0]);
        LOGGER.debug("[" + this.instanceName + "] transformer build");
        transformer.setInitialContextNode(source);
        transformer.transform();
        long duration = System.currentTimeMillis() - start;
        String distinctName = input.toString();
        try {
            Duration duree = DatatypeFactory.newInstance().newDuration(duration);
            LOGGER.info("[" + this.instanceName + "] - " + distinctName + " - transform terminated: " + duree.toString());
        }
        catch (Exception ex) {
            LOGGER.info("[" + this.instanceName + "] - " + distinctName + " - transform terminated");
        }
    }

    private XsltTransformer buildTransformer(Pipe pipe, File inputFile, String inputFileUri, HashMap<String, ParameterValue> parameters, MessageListener listener, XdmNode documentTree, boolean ... isFake) throws InvalidSyntaxException, URISyntaxException, MalformedURLException, SaxonApiException, FileNotFoundException {
        LOGGER.trace("in buildTransformer(Pipe,...)");
        XsltTransformer first = null;
        Iterator<ParametrableStep> it = pipe.getXslts();
        StepJava previousTransformer = null;
        block2: while (it.hasNext()) {
            LOGGER.trace("...in buildTransformer.tee.while");
            ParametrableStep step = it.next();
            if (step instanceof Xslt) {
                XsltTransformer currentTransformer;
                Xslt xsl = (Xslt)step;
                Object currentDestination = currentTransformer = this.getXsltTransformer(xsl.getHref(), parameters);
                if (xsl.isTraceToAdd()) {
                    currentTransformer.setTraceListener((TraceListener)this.traceListener);
                }
                if (listener != null) {
                    LOGGER.trace(xsl.getHref() + " setting messageListener " + listener);
                    currentTransformer.setMessageListener(listener);
                }
                for (ParameterValue pv : xsl.getParams()) {
                    String value = ParametersMerger.processParametersReplacement(pv.getValue(), parameters);
                    LOGGER.trace("Setting parameter (" + pv.getKey() + "," + value + ")");
                    currentTransformer.setParameter(new QName(pv.getKey()), (XdmValue)new XdmAtomicValue(value));
                }
                for (ParameterValue pv : parameters.values()) {
                    currentTransformer.setParameter(new QName(pv.getKey()), (XdmValue)new XdmAtomicValue(ParametersMerger.processParametersReplacement(pv.getValue(), parameters)));
                }
                if (xsl.isDebug()) {
                    Serializer debug = this.processor.newSerializer(new File(xsl.getId() + "-" + inputFile.getName()));
                    currentDestination = new TeeDebugDestination((Destination)debug);
                    currentTransformer.setDestination((Destination)currentDestination);
                }
                if (first == null) {
                    first = currentTransformer;
                }
                if (previousTransformer != null) {
                    this.assignStepToDestination(previousTransformer, (Destination)currentDestination);
                }
                previousTransformer = currentDestination;
                LOGGER.trace(xsl.getHref() + " constructed and added to pipe");
                continue;
            }
            if (step instanceof ChooseStep) {
                ChooseStep cStep = (ChooseStep)step;
                XPathCompiler xpc = this.getXPathCompiler();
                if (documentTree == null) continue;
                for (WhenEntry when : cStep.getConditions()) {
                    XPathSelector select = xpc.compile(when.getTest()).load();
                    select.setContextItem((XdmItem)documentTree);
                    XdmValue result = select.evaluate();
                    if (result.size() != 1) {
                        throw new InvalidSyntaxException(when.getTest() + " does not produce a xs:boolean result");
                    }
                    if (!"true".equals(result.itemAt(0).getStringValue())) continue;
                    Pipe fakePipe = new Pipe();
                    for (ParametrableStep innerStep : when.getSteps()) {
                        fakePipe.addXslt(innerStep);
                    }
                    XsltTransformer currentDestination = this.buildTransformer(fakePipe, inputFile, inputFileUri, parameters, listener, documentTree, true);
                    if (previousTransformer != null) {
                        this.assignStepToDestination(previousTransformer, (Destination)currentDestination);
                    }
                    previousTransformer = currentDestination;
                    continue block2;
                }
                continue;
            }
            if (step instanceof JavaStep) {
                JavaStep javaStep = (JavaStep)step;
                try {
                    StepJava stepJava = javaStep.getStepClass().newInstance();
                    for (ParameterValue pv : javaStep.getParams()) {
                        stepJava.setParameter(new QName(pv.getKey()), (XdmValue)new XdmAtomicValue(ParametersMerger.processParametersReplacement(pv.getValue(), parameters)));
                    }
                    for (ParameterValue pv : parameters.values()) {
                        stepJava.setParameter(new QName(pv.getKey()), (XdmValue)new XdmAtomicValue(ParametersMerger.processParametersReplacement(pv.getValue(), parameters)));
                    }
                    if (previousTransformer != null) {
                        this.assignStepToDestination(previousTransformer, stepJava);
                    }
                    previousTransformer = stepJava;
                    continue;
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    throw new InvalidSyntaxException(ex);
                }
            }
            if (!(step instanceof Tee)) continue;
            throw new InvalidSyntaxException("A tee can not be the root of a pipe");
        }
        Destination nextStep = null;
        if (pipe.getTee() != null) {
            LOGGER.trace("after having construct xslts, build tee");
            nextStep = this.buildTransformer(pipe.getTee(), inputFile, inputFileUri, parameters, listener, documentTree);
        } else if (pipe.getOutput() != null) {
            LOGGER.trace("after having construct xslts, build output");
            nextStep = this.buildSerializer(pipe.getOutput(), inputFile, parameters);
        }
        if (nextStep != null) {
            this.assignStepToDestination(previousTransformer, nextStep);
        } else if (isFake.length == 0 || !isFake[0]) {
            throw new InvalidSyntaxException("Pipe " + pipe.toString() + " has no terminal Step.");
        }
        return first;
    }

    private void assignStepToDestination(Object assignee, Destination assigned) throws IllegalArgumentException {
        if (assignee == null) {
            throw new IllegalArgumentException("assignee must not be null");
        }
        if (assigned == null) {
            throw new IllegalArgumentException("assigned must not be null");
        }
        if (assignee instanceof XsltTransformer) {
            ((XsltTransformer)assignee).setDestination(assigned);
        } else if (assignee instanceof StepJava) {
            ((StepJava)assignee).setDestination(assigned);
        } else if (assignee instanceof TeeDebugDestination) {
            ((TeeDebugDestination)assignee).setDestination(assigned);
        } else {
            throw new IllegalArgumentException("assignee must be either a XsltTransformer or a StepJava instance");
        }
    }

    private XsltTransformer getXsltTransformer(String href, HashMap<String, ParameterValue> parameters) throws MalformedURLException, SaxonApiException, URISyntaxException, FileNotFoundException {
        String __href = ParametersMerger.processParametersReplacement(href, parameters);
        LOGGER.debug("loading " + __href);
        XsltExecutable xsl = this.xslCache.get(__href);
        if (xsl == null) {
            LOGGER.trace(__href + " not in cache");
            try {
                InputStream input;
                File f;
                if (__href.startsWith("file:")) {
                    f = new File(new URI(__href));
                    input = new FileInputStream(f);
                } else if (__href.startsWith("jar:")) {
                    String jarUri;
                    String xslUri = href.substring(href.indexOf("!") + 1);
                    if (!xslUri.startsWith("/")) {
                        xslUri = "/" + xslUri;
                    }
                    if ((jarUri = href.substring(4, href.length() - xslUri.length() - 1)).startsWith("file://")) {
                        jarUri = jarUri.substring(7);
                    } else if (jarUri.startsWith("file:")) {
                        jarUri = jarUri.substring(5);
                    }
                    TFile f2 = new TFile(jarUri + xslUri);
                    input = new TFileInputStream((File)f2);
                } else if (__href.startsWith("cp:")) {
                    input = GauloisPipe.class.getResourceAsStream(__href.substring(3));
                } else {
                    f = new File(__href);
                    input = new FileInputStream(f);
                }
                LOGGER.trace("input is " + input);
                StreamSource source = new StreamSource(input);
                source.setSystemId(__href);
                xsl = this.xsltCompiler.compile((Source)source);
                this.xslCache.put(__href, xsl);
            }
            catch (SaxonApiException ex) {
                LOGGER.error("while compiling " + __href);
                LOGGER.error("SaxonAPIException: " + href + ": [" + ex.getErrorCode() + "]:" + ex.getMessage());
                if (ex.getCause() != null) {
                    LOGGER.error(ex.getCause().getMessage());
                }
                throw ex;
            }
            catch (FileNotFoundException | URISyntaxException ex) {
                LOGGER.error("while compiling " + __href);
                throw ex;
            }
        }
        return xsl.load();
    }

    private Destination buildTransformer(Tee tee, File inputFile, String inputFileUri, HashMap<String, ParameterValue> parameters, MessageListener listener, XdmNode documentTree) throws InvalidSyntaxException, URISyntaxException, MalformedURLException, SaxonApiException, FileNotFoundException {
        LOGGER.trace("in buildTransformer(Tee,...)");
        ArrayList<Object> dests = new ArrayList<Object>();
        if (tee == null) {
            throw new InvalidSyntaxException("tee est null !");
        }
        if (tee.getPipes() == null) {
            throw new InvalidSyntaxException("tee.getPipes() est null !");
        }
        for (Pipe pipe : tee.getPipes()) {
            dests.add(this.buildShortPipeTransformer(pipe, inputFile, inputFileUri, parameters, listener, documentTree));
        }
        while (dests.size() > 1) {
            Destination d2;
            Destination d1 = (Destination)dests.remove(0);
            if (d1 == (d2 = (Destination)dests.remove(0))) {
                throw new IllegalArgumentException("d1 et d2 sont le meme destination");
            }
            dests.add(new TeeDestination(d2, d1));
        }
        return (Destination)dests.get(0);
    }

    private Destination buildShortPipeTransformer(Pipe pipe, File inputFile, String inputFileUri, HashMap<String, ParameterValue> parameters, MessageListener listener, XdmNode documentTree) throws InvalidSyntaxException, URISyntaxException, MalformedURLException, SaxonApiException, FileNotFoundException {
        if (!pipe.getXslts().hasNext()) {
            if (pipe.getOutput() != null) {
                return this.buildSerializer(pipe.getOutput(), inputFile, parameters);
            }
            return this.buildTransformer(pipe.getTee(), inputFile, inputFileUri, parameters, listener, documentTree);
        }
        return this.buildTransformer(pipe, inputFile, inputFileUri, parameters, listener, documentTree, new boolean[0]);
    }

    private Destination buildSerializer(Output output, File inputFile, HashMap<String, ParameterValue> parameters) throws InvalidSyntaxException, URISyntaxException {
        if (output.isNullOutput()) {
            return this.processor.newSerializer((OutputStream)new NullOutputStream());
        }
        if (output.isConsoleOutput()) {
            return this.processor.newSerializer((OutputStream)("out".equals(output.getConsole()) ? System.out : System.err));
        }
        final File destinationFile = output.getDestinationFile(inputFile, parameters);
        final Serializer ret = this.processor.newSerializer(destinationFile);
        Properties outputProps = output.getOutputProperties();
        for (Object key : outputProps.keySet()) {
            ret.setOutputProperty(Output.VALID_OUTPUT_PROPERTIES.get(key.toString()).getSaxonProperty(), outputProps.getProperty(key.toString()));
        }
        if (this.config.isLogFileSize()) {
            Destination dest = new Destination(){

                public Receiver getReceiver(Configuration c) throws SaxonApiException {
                    return new ProxyReceiver(ret.getReceiver(c)){

                        public void close() throws XPathException {
                            super.close();
                            LOGGER.info("[" + GauloisPipe.this.instanceName + "] Written " + destinationFile.getAbsolutePath() + ": " + destinationFile.length());
                        }
                    };
                }

                public void close() throws SaxonApiException {
                    ret.close();
                }
            };
            return dest;
        }
        return ret;
    }

    protected URIResolver buildUriResolver(URIResolver defaultUriResolver) {
        return new Resolver();
    }

    public void doPostCloseService(ExecutionContext context) {
        try {
            context.getService().awaitTermination(5L, TimeUnit.HOURS);
            if (this.config.getSources().getListener().getJavastep() != null) {
                JavaStep javaStep = this.config.getSources().getListener().getJavastep();
                try {
                    StepJava stepJava = javaStep.getStepClass().newInstance();
                    for (ParameterValue pv : javaStep.getParams()) {
                        stepJava.setParameter(new QName(pv.getKey()), (XdmValue)new XdmAtomicValue(pv.getValue()));
                    }
                    for (ParameterValue pv : this.config.getParams().values()) {
                        stepJava.setParameter(new QName(pv.getKey()), (XdmValue)new XdmAtomicValue(pv.getValue()));
                    }
                    Receiver r = stepJava.getReceiver(this.configurationFactory.getConfiguration());
                    r.open();
                    r.close();
                }
                catch (IllegalAccessException | InstantiationException | SaxonApiException | XPathException ex) {
                    LOGGER.error("while preparing doPostCloseService", ex);
                }
            }
        }
        catch (InterruptedException ex) {
            LOGGER.error("[" + this.instanceName + "] multi-thread processing interrupted, 5 hour limit exceed.");
        }
    }

    public static void main(String[] args) {
        if (!protocolInstalled) {
            ProtocolInstaller.registerAdditionalProtocols();
            protocolInstalled = true;
        }
        LOGGER.info("Additionals protocols installed");
        GauloisPipe gauloisPipe = new GauloisPipe(new SaxonConfigurationFactory(){
            Configuration configuration = Configuration.newConfiguration();

            @Override
            public Configuration getConfiguration() {
                return this.configuration;
            }
        });
        try {
            LOGGER.debug("gauloisPipe instanciated");
            Config config = gauloisPipe.parseCommandLine(args);
            gauloisPipe.setConfig(config);
            gauloisPipe.setInstanceName(config.__instanceName);
        }
        catch (InvalidSyntaxException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            System.exit(1);
        }
        try {
            gauloisPipe.launch();
        }
        catch (InvalidSyntaxException | IOException | URISyntaxException | SaxonApiException ex) {
            LOGGER.error(ex.getMessage(), ex);
            gauloisPipe.getErrors().add((Exception)ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    public Config parseCommandLine(String[] args) throws InvalidSyntaxException {
        inputFiles = new ArrayList<String>();
        inputParams = new ArrayList<String>();
        inputXsls = new ArrayList<String>();
        nbThreads = null;
        inputOutput = null;
        configFileName = null;
        __instanceName = "instance1";
        logFileSize = false;
        skipSchemaValidation = false;
        inputMode = -1;
        block36: for (String argument : args) {
            if (null == argument) ** GOTO lbl-1000
            var16_19 = argument;
            var17_20 = -1;
            switch (var16_19.hashCode()) {
                case -1942098554: {
                    if (!var16_19.equals("PARAMS")) break;
                    var17_20 = 0;
                    break;
                }
                case 66896471: {
                    if (!var16_19.equals("FILES")) break;
                    var17_20 = 1;
                    break;
                }
                case 87217: {
                    if (!var16_19.equals("XSL")) break;
                    var17_20 = 2;
                    break;
                }
                case 1394501281: {
                    if (!var16_19.equals("--output")) break;
                    var17_20 = 3;
                    break;
                }
                case 1506: {
                    if (!var16_19.equals("-o")) break;
                    var17_20 = 4;
                    break;
                }
                case 1190650325: {
                    if (!var16_19.equals("--nbthreads")) break;
                    var17_20 = 5;
                    break;
                }
                case 1505: {
                    if (!var16_19.equals("-n")) break;
                    var17_20 = 6;
                    break;
                }
                case 1949636384: {
                    if (!var16_19.equals("--msg-listener")) break;
                    var17_20 = 7;
                    break;
                }
                case 711179043: {
                    if (!var16_19.equals("--instance-name")) break;
                    var17_20 = 8;
                    break;
                }
                case 1387701895: {
                    if (!var16_19.equals("-iName")) break;
                    var17_20 = 9;
                    break;
                }
                case 1045221602: {
                    if (!var16_19.equals("--config")) break;
                    var17_20 = 10;
                    break;
                }
                case -2094996127: {
                    if (!var16_19.equals("--logFileSize")) break;
                    var17_20 = 11;
                    break;
                }
                case -1377122759: {
                    if (!var16_19.equals("--skipSchemaValidation")) break;
                    var17_20 = 12;
                }
            }
            switch (var17_20) {
                case 0: {
                    inputMode = 1;
                    continue block36;
                }
                case 1: {
                    inputMode = 2;
                    continue block36;
                }
                case 2: {
                    inputMode = 0;
                    continue block36;
                }
                case 3: 
                case 4: {
                    inputMode = 4;
                    continue block36;
                }
                case 5: 
                case 6: {
                    inputMode = 8;
                    continue block36;
                }
                case 7: {
                    inputMode = 15;
                    continue block36;
                }
                case 8: 
                case 9: {
                    inputMode = 16;
                    continue block36;
                }
                case 10: {
                    inputMode = 32;
                }
                case 11: {
                    logFileSize = true;
                }
                case 12: {
                    skipSchemaValidation = true;
                }
                default: lbl-1000:
                // 2 sources

                {
                    switch (inputMode) {
                        case 2: {
                            inputFiles.add(argument);
                            continue block36;
                        }
                        case 1: {
                            inputParams.add(argument);
                            continue block36;
                        }
                        case 0: {
                            inputXsls.add(argument);
                            continue block36;
                        }
                        case 8: {
                            nbThreads = argument;
                            continue block36;
                        }
                        case 4: {
                            inputOutput = argument;
                            continue block36;
                        }
                        case 16: {
                            __instanceName = argument;
                            continue block36;
                        }
                        case 32: {
                            configFileName = argument;
                        }
                    }
                }
            }
        }
        inputParameters = new HashMap<String, ParameterValue>(inputParams.size());
        for (String paramPattern : inputParams) {
            pv = ConfigUtil.parseParameterPattern(paramPattern);
            inputParameters.put(pv.getKey(), pv);
        }
        GauloisPipe.LOGGER.debug("parameters from command line are : " + inputParameters);
        if (configFileName != null) {
            config = this.parseConfig(configFileName, inputParameters, this.configurationFactory.getConfiguration(), skipSchemaValidation);
            GauloisPipe.LOGGER.debug("computed parameters in config are :" + config.getParams());
        } else {
            config = new Config();
        }
        for (String inputFile : inputFiles) {
            ConfigUtil.addInputFile(config, inputFile);
        }
        for (String inputXsl : inputXsls) {
            ConfigUtil.addTemplate(config, inputXsl);
        }
        if (nbThreads != null) {
            ConfigUtil.setNbThreads(config, nbThreads);
        }
        if (inputOutput != null) {
            ConfigUtil.setOutput(config, inputOutput);
        }
        config.setLogFileSize(logFileSize);
        config.skipSchemaValidation(skipSchemaValidation);
        config.verify();
        GauloisPipe.LOGGER.debug("merged parameters into config are : " + config.getParams());
        config.__instanceName = __instanceName;
        return config;
    }

    private Config parseConfig(String fileName, HashMap<String, ParameterValue> inputParameters, Configuration saxonConfig, boolean skipSchemaValidation) throws InvalidSyntaxException {
        try {
            return new ConfigUtil(saxonConfig, this.getUriResolver(), fileName, skipSchemaValidation).buildConfig(inputParameters);
        }
        catch (SaxonApiException ex) {
            throw new InvalidSyntaxException(ex);
        }
    }

    public URIResolver getUriResolver() {
        if (this.uriResolver == null) {
            this.uriResolver = this.buildUriResolver(this.configurationFactory.getConfiguration().getURIResolver());
        }
        return this.uriResolver;
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public String getInstanceName() {
        return this.instanceName;
    }

    private XSLTTraceListener buildTraceListener(String outputDest) {
        net.sf.saxon.lib.Logger logger;
        if (outputDest == null) {
            return null;
        }
        switch (outputDest) {
            case "#default": {
                logger = this.configurationFactory.getConfiguration().getLogger();
                break;
            }
            case "#logger": {
                logger = new net.sf.saxon.lib.Logger(){

                    public void println(String string, int i) {
                        switch (i) {
                            case 0: {
                                LOGGER.debug(string);
                            }
                            case 1: {
                                LOGGER.info(string);
                            }
                            case 2: {
                                LOGGER.warn(string);
                            }
                            case 3: {
                                LOGGER.error(string);
                            }
                        }
                    }

                    public StreamResult asStreamResult() {
                        return new StreamResult(System.out);
                    }
                };
                break;
            }
            default: {
                try {
                    logger = new StandardLogger(new File(outputDest));
                    break;
                }
                catch (FileNotFoundException ex) {
                    LOGGER.error("while creating traceListener output. Traces will be logged to standard output", (Throwable)ex);
                    logger = this.configurationFactory.getConfiguration().getLogger();
                }
            }
        }
        XSLTTraceListener tracer = new XSLTTraceListener();
        tracer.setOutputDestination(logger);
        return tracer;
    }

    private XPathCompiler getXPathCompiler() {
        if (this.xpathCompiler == null) {
            this.xpathCompiler = this.processor.newXPathCompiler();
            for (String prefix : this.config.getNamespaces().getMappings().keySet()) {
                this.xpathCompiler.declareNamespace(prefix, this.config.getNamespaces().getMappings().get(prefix));
            }
        }
        return this.xpathCompiler;
    }

    private class ErrorCollector
    implements Runnable {
        private final List<Exception> errorsContainer;

        public ErrorCollector(List<Exception> errorsContainer) {
            this.errorsContainer = errorsContainer;
        }

        @Override
        public void run() {
            if (this.errorsContainer == null || this.errorsContainer.isEmpty()) {
                LOGGER.info("Gaulois-Pipe is exiting without error");
            } else {
                for (Exception ex : this.errorsContainer) {
                    LOGGER.error("", (Throwable)ex);
                }
                LOGGER.info("Gaulois-Pipe is exiting with error");
                Runtime.getRuntime().halt(this.errorsContainer.size());
            }
        }
    }

    private class DocumentCache
    extends LinkedHashMap<String, XdmNode> {
        private final int cacheSize;
        private List<String> loading;

        public DocumentCache(int cacheSize) {
            if (cacheSize < 1) {
                throw new IllegalArgumentException("cacheSize must be at least 1");
            }
            this.cacheSize = cacheSize;
            this.loading = new ArrayList<String>(10);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, XdmNode> eldest) {
            boolean ret;
            boolean bl = ret = this.size() == this.cacheSize;
            if (ret) {
                LOGGER.debug("removing entry from documentCache : " + eldest.getKey());
            }
            return ret;
        }

        public void setLoading(String key) {
            this.loading.add(key);
        }

        public void ignoreLoading(String key) {
            this.loading.remove(key);
        }

        public boolean isLoading(String key) {
            return this.loading.contains(key);
        }

        @Override
        public XdmNode put(String key, XdmNode value) {
            XdmNode ret = super.put(key, value);
            this.loading.remove(key);
            return ret;
        }

        public XdmNode waitForLoading(String key) {
            long endDate = System.currentTimeMillis() + 2000L;
            while (this.isLoading(key)) {
                try {
                    Thread.sleep(100L);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                if (System.currentTimeMillis() <= endDate) continue;
                return null;
            }
            return (XdmNode)this.get(key);
        }
    }
}

