/*
 * Decompiled with CFR 0.152.
 */
package fr.efl.chaine.xslt.config;

import fr.efl.chaine.xslt.InvalidSyntaxException;
import fr.efl.chaine.xslt.StepJava;
import fr.efl.chaine.xslt.config.ParametrableStep;
import fr.efl.chaine.xslt.utils.ParameterValue;
import java.util.Collection;
import java.util.HashMap;
import net.sf.saxon.s9api.QName;

public class JavaStep
implements ParametrableStep {
    static final QName QNAME = new QName("http://efl.fr/chaine/saxon-pipe/config", "java");
    static final QName ATTR_CLASS = new QName("class");
    private String className;
    private HashMap<String, ParameterValue> params = new HashMap();
    private Class clazz;

    public JavaStep() {
    }

    public JavaStep(String className) {
        this();
        this.className = className;
    }

    @Override
    public Collection<ParameterValue> getParams() {
        return this.params.values();
    }

    @Override
    public void addParameter(ParameterValue param) {
        if (param != null) {
            this.params.put(param.getKey(), param);
        }
    }

    @Override
    public void verify() throws InvalidSyntaxException {
        try {
            this.clazz = Class.forName(this.className);
            if (!JavaStep.isDerivedFrom(this.clazz, StepJava.class)) {
                throw new InvalidSyntaxException("La classe " + this.className + " n'impl\u00e9mente pas " + StepJava.class.getName());
            }
        }
        catch (InvalidSyntaxException | ClassNotFoundException ex) {
            throw new InvalidSyntaxException(ex);
        }
    }

    public Class<StepJava> getStepClass() {
        return this.clazz;
    }

    private static boolean isDerivedFrom(Class toTest, Class isA) {
        Class hierarch;
        for (hierarch = toTest; hierarch != null && !hierarch.equals(isA); hierarch = hierarch.getSuperclass()) {
        }
        return hierarch != null;
    }

    @Override
    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("java class=").append(this.className).append("\n");
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

