/*
 * Decompiled with CFR 0.152.
 */
package fr.efl.chaine.xslt.config;

import fr.efl.chaine.xslt.InvalidSyntaxException;
import fr.efl.chaine.xslt.config.CfgFile;
import fr.efl.chaine.xslt.config.Listener;
import fr.efl.chaine.xslt.config.Verifiable;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.saxon.s9api.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sources
implements Verifiable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Sources.class);
    static final QName QNAME = new QName("http://efl.fr/chaine/saxon-pipe/config", "sources");
    static final QName ATTR_ORDERBY = new QName("orderBy");
    static final QName ATTR_SORT = new QName("sort");
    private final String orderBy;
    private final String sort;
    private final List<CfgFile> files;
    private long maxFileSize = 0L;
    private Map<File, Integer> hrefCount;
    private Listener listener;

    public Sources(String orderBy, String sort) throws InvalidSyntaxException {
        if (orderBy == null) {
            orderBy = "size";
        }
        if (sort == null) {
            sort = "desc";
        }
        if (!("size".equals(orderBy) || "name".equals(orderBy) || "define".equals(orderBy))) {
            throw new InvalidSyntaxException("orderBy must be one of (size,name,define)");
        }
        this.orderBy = orderBy;
        if (!("define".equals(orderBy) || "asc".equals(sort) || "desc".equals(sort))) {
            throw new InvalidSyntaxException("sort must be one of (asc,desc)");
        }
        this.sort = sort;
        this.files = new ArrayList<CfgFile>();
        this.hrefCount = new HashMap<File, Integer>();
    }

    public Sources(String orderBy) throws InvalidSyntaxException {
        this(orderBy, "desc");
    }

    public Sources() throws InvalidSyntaxException {
        this("size");
    }

    public List<CfgFile> getFiles() {
        return this.getFiles(this.orderBy, this.sort);
    }

    private static Comparator<CfgFile> getComparator(final String orderBy, final String sort) {
        return new Comparator<CfgFile>(){

            @Override
            public int compare(CfgFile t, CfgFile t1) {
                long ret;
                long l = ret = "name".equals(orderBy) ? (long)t.getSource().getName().compareTo(t1.getSource().getName()) : t.getSource().length() - t1.getSource().length();
                if ("desc".equals(sort)) {
                    ret = -ret;
                }
                if (ret == 0L) {
                    return (int)ret;
                }
                if (ret < 0L) {
                    return -1;
                }
                return 1;
            }
        };
    }

    private List<CfgFile> getFiles(String orderBy, String sort) {
        LOGGER.trace("getFiles({}, {})", (Object)orderBy, (Object)sort);
        if ("define".equals(orderBy)) {
            return this.files;
        }
        LOGGER.trace("getFiles() sort {} files with orderBy={} and sort={}", new Object[]{this.files.size(), orderBy, sort});
        ArrayList<CfgFile> ret = new ArrayList<CfgFile>(this.files);
        Collections.sort(ret, Sources.getComparator(orderBy, sort));
        LOGGER.trace("getFiles() return {} files", (Object)ret.size());
        return ret;
    }

    public void addFile(CfgFile file) {
        long fileLength = file.getSource().length();
        LOGGER.info("adding file {} with length {}", (Object)file, (Object)fileLength);
        this.files.add(file);
        this.maxFileSize = Math.max(this.maxFileSize, fileLength);
        Integer count = this.hrefCount.get(file.getSource());
        if (count == null) {
            count = 1;
        } else {
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
        }
        this.hrefCount.put(file.getSource(), count);
    }

    public void addFiles(Collection<CfgFile> files) {
        for (CfgFile file : files) {
            this.addFile(file);
        }
    }

    public int getFileUsage(File f) {
        Integer ret = this.hrefCount.get(f);
        return ret == null ? 0 : ret;
    }

    @Override
    public void verify() throws InvalidSyntaxException {
        if (this.files.isEmpty()) {
            LOGGER.warn("No input file to process. If you have used a pattern to find files, check your regex.");
        }
        for (CfgFile f : this.files) {
            f.verify();
        }
        if (this.listener != null) {
            this.listener.verify();
        }
    }

    public boolean hasFileOverLimit(long limit) {
        return this.maxFileSize > limit;
    }

    public List<CfgFile> getFilesOverLimit(long limit) {
        List<CfgFile> files = this.getFiles("size", "asc");
        ArrayList<CfgFile> ret = new ArrayList<CfgFile>(files.size());
        for (CfgFile file : files) {
            if (file.getSource().length() <= limit) break;
            ret.add(file);
        }
        Collections.sort(files, Sources.getComparator(this.orderBy, this.sort));
        LOGGER.debug("getFilesOverLimit() -> {}", (Object)ret.size());
        return ret;
    }

    public List<CfgFile> getFilesUnderLimit(long limit) {
        List<CfgFile> files = this.getFiles("size", "asc");
        ArrayList<CfgFile> ret = new ArrayList<CfgFile>(files.size());
        for (CfgFile file : files) {
            if (file.getSource().length() > limit) break;
            ret.add(file);
        }
        Collections.sort(files, Sources.getComparator(this.orderBy, this.sort));
        LOGGER.debug("getFilesUnderLimit() -> {}", (Object)ret.size());
        return ret;
    }

    public Listener getListener() {
        return this.listener;
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }
}

