/*
 * Decompiled with CFR 0.152.
 */
package fr.efl.chaine.xslt.config;

import fr.efl.chaine.xslt.InvalidSyntaxException;
import fr.efl.chaine.xslt.config.Pipe;
import fr.efl.chaine.xslt.config.Verifiable;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.s9api.QName;

public class Tee
implements Verifiable {
    static final QName QNAME = new QName("http://efl.fr/chaine/saxon-pipe/config", "tee");
    static final QName PIPE = new QName("http://efl.fr/chaine/saxon-pipe/config", "pipe");
    private List<Pipe> pipes = new ArrayList<Pipe>();

    public List<Pipe> getPipes() {
        return this.pipes;
    }

    public void addPipe(Pipe pipe) {
        this.pipes.add(pipe);
    }

    @Override
    public void verify() throws InvalidSyntaxException {
        if (this.pipes.size() < 2) {
            throw new InvalidSyntaxException("At least 2 sub-pipes are required");
        }
        for (Pipe pipe : this.pipes) {
            pipe.verify();
        }
    }

    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("tee").append("\n");
        String _p = prefix.concat("  ");
        for (Pipe pipe : this.pipes) {
            sb.append(pipe.toString(_p));
        }
        return sb.toString();
    }
}

