/*
 * Decompiled with CFR 0.152.
 */
package fr.efl.chaine.xslt.config;

import de.schlichtherle.truezip.file.TFile;
import fr.efl.chaine.xslt.GauloisPipe;
import fr.efl.chaine.xslt.InvalidSyntaxException;
import fr.efl.chaine.xslt.config.ParametrableStep;
import fr.efl.chaine.xslt.utils.ParameterValue;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import net.sf.saxon.s9api.QName;

public class Xslt
implements ParametrableStep {
    static final QName QNAME = new QName("http://efl.fr/chaine/saxon-pipe/config", "xslt");
    static final QName ATTR_HREF = new QName("href");
    static final QName ATTR_TRACE_ACTIVE = new QName("traceActive");
    static final QName ATTR_DEBUG = new QName("debug");
    static final QName ATTR_ID = new QName("id");
    private String href;
    private HashMap<String, ParameterValue> params = new HashMap();
    private boolean traceToAdd = false;
    private File file;
    private boolean debug;
    private String id;

    public Xslt() {
    }

    public Xslt(String href) {
        this();
        this.href = href;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    @Override
    public Collection<ParameterValue> getParams() {
        return this.params.values();
    }

    @Override
    public void addParameter(ParameterValue param) {
        if (param != null) {
            this.params.put(param.getKey(), param);
        }
    }

    private File getFile() throws URISyntaxException {
        if (this.file == null) {
            if (this.href.startsWith("file:")) {
                this.file = new File(new URI(this.href));
            } else if (this.href.startsWith("jar:")) {
                String jarUri;
                String xslUri = this.href.substring(this.href.indexOf("!") + 1);
                if (!xslUri.startsWith("/")) {
                    xslUri = "/" + xslUri;
                }
                if ((jarUri = this.href.substring(4, this.href.length() - xslUri.length() - 1)).startsWith("file://")) {
                    jarUri = jarUri.substring(7);
                } else if (jarUri.startsWith("file:")) {
                    jarUri = jarUri.substring(5);
                }
                this.file = new TFile(jarUri + xslUri);
            } else if (!this.href.startsWith("cp:")) {
                this.file = new File(this.href);
            }
        }
        return this.file;
    }

    @Override
    public void verify() throws InvalidSyntaxException {
        try {
            if (!this.href.contains("$[")) {
                if (!this.href.startsWith("cp:")) {
                    File xslFile = this.getFile();
                    if (xslFile instanceof TFile) {
                        TFile tf = (TFile)xslFile;
                        if (!tf.canRead()) {
                            throw new InvalidSyntaxException(tf.getAbsolutePath() + " is not readable");
                        }
                    } else if (!xslFile.exists() || !xslFile.isFile()) {
                        throw new InvalidSyntaxException(this.getFile().getAbsolutePath() + " does not exists or is not a regular file");
                    }
                } else {
                    URL url = GauloisPipe.class.getResource(this.href.substring(3));
                    if (url == null) {
                        throw new InvalidSyntaxException("Unable to load " + this.href + " from classpath. Did you start with a '/' ?");
                    }
                }
            }
        }
        catch (URISyntaxException ex) {
            throw new InvalidSyntaxException(ex);
        }
    }

    public boolean isTraceToAdd() {
        return this.traceToAdd;
    }

    void setTraceToAdd(boolean traceToAdd) {
        this.traceToAdd = traceToAdd;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("xslt href=").append(this.href);
        if (this.id != null) {
            sb.append(" id=").append(this.id);
        }
        sb.append("\n");
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

