/*
 * Decompiled with CFR 0.152.
 */
package fr.efl.chaine.xslt.listener;

import fr.efl.chaine.xslt.ExecutionContext;
import fr.efl.chaine.xslt.listener.ListenerServlet;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpListener {
    static final transient String CONTEXT_ENTRY = "CTX_KEY";
    static final transient String STOP_ENTRY = "STOP_KEY";
    static final transient String LISTENER = "__XX__LISTENER__XX__";
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpListener.class);
    private final int port;
    private final String stopKeyWord;
    private final ExecutionContext execCtx;
    private Server jettyServer;

    public HttpListener(int port, String stopKeyWord, ExecutionContext context) {
        this.port = port;
        this.stopKeyWord = stopKeyWord;
        this.execCtx = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.jettyServer = new Server(this.port);
        ServletContextHandler context = new ServletContextHandler(0);
        context.getServletContext().setAttribute(STOP_ENTRY, (Object)this.stopKeyWord);
        context.getServletContext().setAttribute(CONTEXT_ENTRY, (Object)this.execCtx);
        context.getServletContext().setAttribute(LISTENER, (Object)this);
        context.setContextPath("");
        context.addServlet(new ServletHolder(ListenerServlet.class), "/*");
        this.jettyServer.setHandler((Handler)context);
        try {
            this.jettyServer.start();
            this.jettyServer.join();
        }
        catch (Exception ex) {
            LOGGER.error("While starting", (Throwable)ex);
            try {
                this.jettyServer.stop();
            }
            catch (Exception exception) {
            }
            finally {
                this.jettyServer.destroy();
            }
        }
    }

    void stop() {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                try {
                    HttpListener.this.jettyServer.stop();
                    try {
                        HttpListener.this.execCtx.getService().awaitTermination(5L, TimeUnit.HOURS);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    LOGGER.info("asynchronous processing terminated, JVM is going to terminate");
                }
                catch (Exception ex) {
                    LOGGER.error("while stopping", (Throwable)ex);
                }
            }
        };
        new Thread(runner).start();
    }
}

