/*
 * Decompiled with CFR 0.152.
 */
package fr.efl.chaine.xslt.listener;

import fr.efl.chaine.xslt.ExecutionContext;
import fr.efl.chaine.xslt.GauloisRunException;
import fr.efl.chaine.xslt.InvalidSyntaxException;
import fr.efl.chaine.xslt.listener.HttpListener;
import fr.efl.chaine.xslt.utils.ParameterValue;
import fr.efl.chaine.xslt.utils.ParametrableFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.RejectedExecutionException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.saxon.s9api.SaxonApiException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListenerServlet.class);
    private ExecutionContext context;
    private String stopKeyword;
    private String sSizeLimit;

    public void init() throws ServletException {
        super.init();
        this.context = (ExecutionContext)this.getServletContext().getAttribute("CTX_KEY");
        this.stopKeyword = this.getServletContext().getAttribute("STOP_KEY").toString();
        if (this.context == null) {
            throw new ServletException("context must not be null");
        }
        if (!this.context.isValid()) {
            LOGGER.error("context is invalid: " + this.context.getErrorMessage());
            throw new ServletException(this.context.getErrorMessage());
        }
        if (this.stopKeyword == null || this.stopKeyword.length() == 0) {
            throw new ServletException("stopKeyword must not be null or empty");
        }
        this.sSizeLimit = this.context.getPipe().getMultithreadMaxSourceSize() < 1024 ? Integer.toString(this.context.getPipe().getMultithreadMaxSourceSize()) + "b" : (this.context.getPipe().getMultithreadMaxSourceSize() < 0x100000 ? Integer.toString(this.context.getPipe().getMultithreadMaxSourceSize() / 1024) + "kb" : Integer.toString(this.context.getPipe().getMultithreadMaxSourceSize() / 1024 / 1024) + "mb");
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap<String, ParameterValue> parameters = new HashMap<String, ParameterValue>();
        String sUrl = null;
        Enumeration enumer = req.getParameterNames();
        while (enumer.hasMoreElements()) {
            String paramName = (String)enumer.nextElement();
            if ("url".equals(paramName)) {
                sUrl = req.getParameter(paramName);
                continue;
            }
            if (paramName != null) {
                parameters.put(paramName, new ParameterValue(paramName, req.getParameter(paramName)));
                continue;
            }
            LOGGER.info("received null parameter with value=" + req.getParameter(paramName));
        }
        if (sUrl == null) {
            resp.sendError(400, "url parameter must be provided");
        } else if (this.context.getService().isShutdown()) {
            resp.sendError(403, "The service has been shutdown, no other file will be accepted");
        } else {
            URL url = new URL(sUrl);
            if (!"file".equals(url.getProtocol())) {
                resp.sendError(403, "Only file: protocol are allowed.");
            } else {
                File inputFile = new File(sUrl.substring(5));
                try {
                    if (inputFile.length() > (long)this.context.getPipe().getMultithreadMaxSourceSize()) {
                        resp.sendError(403, sUrl + " size exceeds " + this.sSizeLimit);
                    } else {
                        final ExecutionContext iCtx = this.context;
                        final ParametrableFile fpf = new ParametrableFile(inputFile);
                        fpf.getParameters().putAll(parameters);
                        Runnable r = new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    iCtx.getGaulois().execute(iCtx.getPipe(), fpf, iCtx.getMsgListener());
                                }
                                catch (InvalidSyntaxException | FileNotFoundException | MalformedURLException | URISyntaxException | SaxonApiException ex) {
                                    String msg = "[" + iCtx.getGaulois().getInstanceName() + "] while processing " + fpf.getFile().getName();
                                    LOGGER.error(msg, ex);
                                    iCtx.getGaulois().getErrors().add(new GauloisRunException(msg, fpf.getFile()));
                                }
                            }
                        };
                        try {
                            iCtx.getService().execute(r);
                            resp.getWriter().println("OK");
                            resp.getWriter().flush();
                            resp.getWriter().close();
                        }
                        catch (RejectedExecutionException ex) {
                            resp.sendError(403, ex.getMessage());
                        }
                    }
                }
                catch (IOException ex) {
                    resp.sendError(404, sUrl + " is not a regular file");
                }
            }
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String keyword = req.getParameter("keyword");
        if (!this.stopKeyword.equals(keyword)) {
            resp.sendError(401, "You are not authorized to terminate GauloisPipe. Do you have the correct keyword ?");
        } else {
            this.context.getService().shutdown();
            this.context.getGaulois().doPostCloseService(this.context);
            HttpListener listener = (HttpListener)this.getServletContext().getAttribute("__XX__LISTENER__XX__");
            resp.setStatus(200);
            resp.getWriter().println("Server stopped");
            resp.getWriter().flush();
            resp.getWriter().close();
            listener.stop();
        }
    }
}

