/*
 * Decompiled with CFR 0.152.
 */
package fr.efl.chaine.xslt.utils;

import fr.efl.chaine.xslt.GauloisPipe;
import fr.efl.chaine.xslt.utils.MultiThreadRunner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class MultiThreadEngine<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GauloisPipe.class);
    private static final int SLEEP_DURATION = 1000;
    private final int nbThreads;
    private final MultiThreadRunner<T> runner;
    private final String instanceName;

    public MultiThreadEngine(int nbThreads, MultiThreadRunner<T> runner, String instanceName) {
        this.nbThreads = nbThreads;
        this.runner = runner;
        this.instanceName = instanceName;
    }

    public void execute(List<T> inputs) {
        LOGGER.info("[" + this.instanceName + "] Execute pipe on {} inputs", (Object)inputs.size());
        final ArrayBlockingQueue<T> inputsQueue = new ArrayBlockingQueue<T>(inputs.size(), true, inputs);
        ArrayList<Thread> threads = new ArrayList<Thread>(this.nbThreads);
        final boolean[] ends = new boolean[this.nbThreads];
        Arrays.fill(ends, false);
        int i = 0;
        while (i < this.nbThreads) {
            final int index = i++;
            threads.add(new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object input = inputsQueue.poll();
                        while (input != null) {
                            LOGGER.info("[" + MultiThreadEngine.this.instanceName + "] Remaining inputs size is {} - {}", (Object)inputsQueue.size(), input);
                            MultiThreadEngine.this.runner.run(input);
                            input = inputsQueue.poll();
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage(), (Throwable)e);
                    }
                    finally {
                        ends[index] = true;
                    }
                }
            }));
        }
        for (Thread thread : threads) {
            thread.start();
        }
        while (this.notFinish(ends)) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                LOGGER.warn("[" + this.instanceName + "] " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean notFinish(boolean[] ends) {
        for (boolean end : ends) {
            if (end) continue;
            return true;
        }
        return false;
    }
}

