/*
 * Decompiled with CFR 0.152.
 */
package fr.efl.chaine.xslt.utils;

import fr.efl.chaine.xslt.utils.ParameterValue;
import java.io.File;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParametersMerger {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParametersMerger.class);

    public static HashMap<String, ParameterValue> merge(HashMap<String, ParameterValue> highPriority, HashMap<String, ParameterValue> lowPriority) {
        HashMap<String, ParameterValue> ret = new HashMap<String, ParameterValue>();
        ret.putAll(highPriority);
        for (ParameterValue pv : lowPriority.values()) {
            if (ret.containsKey(pv.getKey())) continue;
            ret.put(pv.getKey(), pv);
        }
        for (ParameterValue pv : ret.values()) {
            pv.setValue(ParametersMerger.processParametersReplacement(pv.getValue(), ret));
        }
        return ret;
    }

    public static String processParametersReplacement(String initialValue, HashMap<String, ParameterValue> parameters) {
        String ret = initialValue;
        if (ret.contains("$[")) {
            for (ParameterValue pv : parameters.values()) {
                if ((ret = ret.replaceAll("\\$\\[" + pv.getKey() + "\\]", pv.getValue())).contains("$[")) continue;
                break;
            }
        }
        return ret;
    }

    public static HashMap<String, ParameterValue> addInputInParameters(HashMap<String, ParameterValue> parameters, File inputFile) {
        HashMap<String, ParameterValue> fileParams = new HashMap<String, ParameterValue>();
        String name = inputFile.getName();
        String basename = name.substring(0, name.lastIndexOf("."));
        String extension = name.substring(basename.length() + 1);
        fileParams.put("input-basename", new ParameterValue("input-basename", basename));
        fileParams.put("input-name", new ParameterValue("input-name", name));
        fileParams.put("input-extension", new ParameterValue("input-extension", extension));
        return ParametersMerger.merge(parameters, fileParams);
    }
}

