/*
 * Decompiled with CFR 0.152.
 */
package fr.efl.chaine.xslt.config;

import fr.efl.chaine.xslt.InvalidSyntaxException;
import fr.efl.chaine.xslt.config.Namespaces;
import fr.efl.chaine.xslt.config.Pipe;
import fr.efl.chaine.xslt.config.Sources;
import fr.efl.chaine.xslt.config.Verifiable;
import fr.efl.chaine.xslt.utils.ParameterValue;
import java.util.HashMap;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config
implements Verifiable {
    public static final int MAX_DOCUMENT_CACHE_SIZE = 1;
    static final QName ATTR_DOCUMENT_CACHE_SIZE = new QName("documentCacheSize");
    static final String NS = "http://efl.fr/chaine/saxon-pipe/config";
    static final QName PARAMS_CHILD = new QName("http://efl.fr/chaine/saxon-pipe/config", "params");
    private Pipe pipe;
    private final HashMap<String, ParameterValue> params = new HashMap();
    private Sources sources;
    private int maxDocumentCacheSize = 1;
    private static final Logger LOGGER = LoggerFactory.getLogger(Config.class);
    private boolean logFileSize;
    private boolean skipSchemaValidation;
    public Namespaces namespaces;
    public transient String __instanceName;

    public Config(XdmNode node) {
        String val = node.getAttributeValue(ATTR_DOCUMENT_CACHE_SIZE);
        if (val != null) {
            try {
                this.maxDocumentCacheSize = Integer.parseInt(val);
            }
            catch (Exception ex) {
                LOGGER.warn(val + " n'est pas une valeur acceptable pour la taille maximale du cache de documents. " + 1 + " sera utilis\u00e9");
            }
        }
    }

    public Config() {
    }

    public Pipe getPipe() {
        return this.pipe;
    }

    void setPipe(Pipe pipe) {
        this.pipe = pipe;
    }

    public HashMap<String, ParameterValue> getParams() {
        return this.params;
    }

    public void addParameter(ParameterValue p) {
        if (p != null) {
            this.params.put(p.getKey(), p);
        }
    }

    public Sources getSources() {
        return this.sources;
    }

    void setSources(Sources sources) {
        this.sources = sources;
    }

    @Override
    public void verify() throws InvalidSyntaxException {
        if (this.pipe == null) {
            throw new InvalidSyntaxException("No pipe defined");
        }
        this.pipe.verify();
        if (this.sources == null) {
            throw new InvalidSyntaxException("No input file defined");
        }
        this.sources.verify();
        if (this.namespaces != null) {
            this.namespaces.verify();
        }
    }

    public boolean hasFilesOverMultiThreadLimit() {
        return this.getSources().hasFileOverLimit(this.getPipe().getMultithreadMaxSourceSize());
    }

    public int getMaxDocumentCacheSize() {
        return this.maxDocumentCacheSize;
    }

    public void setMaxDocumentCacheSize(int maxDocumentCacheSize) {
        this.maxDocumentCacheSize = maxDocumentCacheSize;
    }

    public boolean isLogFileSize() {
        return this.logFileSize;
    }

    public void setLogFileSize(boolean logFileSize) {
        this.logFileSize = logFileSize;
    }

    public void skipSchemaValidation(boolean skipSchemaValidation) {
        this.skipSchemaValidation = skipSchemaValidation;
    }

    public Namespaces getNamespaces() {
        return this.namespaces;
    }

    public void setNamespaces(Namespaces namespaces) {
        this.namespaces = namespaces;
    }
}

