/*
 * Decompiled with CFR 0.152.
 */
package fr.efl.chaine.xslt;

import fr.efl.chaine.xslt.GauloisPipe;
import fr.efl.chaine.xslt.config.Pipe;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import net.sf.saxon.s9api.MessageListener;

public class ExecutionContext
implements Serializable {
    private final Pipe pipe;
    private final MessageListener msgListener;
    private final ExecutorService service;
    private final GauloisPipe gaulois;

    public ExecutionContext(GauloisPipe gaulois, Pipe pipe, MessageListener msgListener, ExecutorService service) {
        this.pipe = pipe;
        this.msgListener = msgListener;
        this.service = service;
        this.gaulois = gaulois;
    }

    public Pipe getPipe() {
        return this.pipe;
    }

    public MessageListener getMsgListener() {
        return this.msgListener;
    }

    public ExecutorService getService() {
        return this.service;
    }

    public boolean isValid() {
        return this.gaulois != null && this.pipe != null && this.service != null && !this.service.isTerminated();
    }

    public GauloisPipe getGaulois() {
        return this.gaulois;
    }

    public String getErrorMessage() {
        if (this.pipe == null) {
            return "context must have a non null pipe";
        }
        if (this.gaulois == null) {
            return "context must have a non null GauloisPipe";
        }
        if (this.service == null) {
            return "context must have a non null service";
        }
        if (this.service.isTerminated()) {
            return "context must not have a terminated service";
        }
        return null;
    }
}

