/*
 * Decompiled with CFR 0.152.
 */
package fr.efl.chaine.xslt.config;

import fr.efl.chaine.xslt.InvalidSyntaxException;
import fr.efl.chaine.xslt.config.ParametrableStep;
import fr.efl.chaine.xslt.utils.ParameterValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.saxon.s9api.QName;

public class WhenEntry
implements ParametrableStep {
    public static final QName QNAME = new QName("http://efl.fr/chaine/saxon-pipe/config", "when");
    public static final QName QN_OTHERWISE = new QName("http://efl.fr/chaine/saxon-pipe/config", "otherwise");
    public static final QName ATTR_TEST = new QName("test");
    private String test;
    private final List<ParametrableStep> steps = new ArrayList<ParametrableStep>();

    public WhenEntry() {
    }

    public WhenEntry(String test) {
        this();
        this.test = test;
    }

    public String getTest() {
        return this.test;
    }

    public List<ParametrableStep> getSteps() {
        return this.steps;
    }

    public void addStep(ParametrableStep step) {
        this.steps.add(step);
    }

    @Override
    public Collection<ParameterValue> getParams() {
        return null;
    }

    @Override
    public void addParameter(ParameterValue param) {
    }

    @Override
    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("when test=\"").append(this.test).append("\"\n");
        String _p = prefix + "  ";
        for (ParametrableStep step : this.steps) {
            step.toString(_p);
        }
        return sb.toString();
    }

    @Override
    public void verify() throws InvalidSyntaxException {
        if (this.test == null || this.test.length() == 0) {
            throw new InvalidSyntaxException("when/@test must be a XPath expression that returns null");
        }
        for (ParametrableStep step : this.steps) {
            step.verify();
        }
    }
}

