/*
 * Decompiled with CFR 0.152.
 */
package fr.efl.chaine.xslt.utils;

import fr.efl.chaine.xslt.StepJava;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.trans.XPathException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileAppenderStep
extends StepJava {
    public static final QName FILE_NAME = new QName("filePath");
    public static final QName VALUE = new QName("value");
    public static final QName LINE_SEPARATOR = new QName("lineSeparator");
    public static final QName ENCODING = new QName("encoding");
    private static final Logger LOGGER = LoggerFactory.getLogger(FileAppenderStep.class);
    private Receiver underlyingReceiver;

    public Receiver getReceiver(Configuration c) throws SaxonApiException {
        this.underlyingReceiver = new FileAppenderReceiver(this.getNextReceiver(c));
        return this.underlyingReceiver;
    }

    @Override
    public void close() throws SaxonApiException {
    }

    static String getLineSeparator(XdmValue in) {
        if (in == null) {
            return System.getProperty("line.separator");
        }
        String sIn = in.toString();
        if (sIn.isEmpty()) {
            return "";
        }
        return sIn.replaceAll("CR", "\r").replaceAll("LF", "\n");
    }

    static Charset getCharset(XdmValue value) {
        if (value == null) {
            return Charset.forName("UTF-8");
        }
        String in = value.toString();
        if (Charset.isSupported(in)) {
            return Charset.forName(in);
        }
        return Charset.forName("UTF-8");
    }

    private class FileAppenderReceiver
    extends ProxyReceiver {
        public FileAppenderReceiver(Receiver nextReceiver) {
            super(nextReceiver);
        }

        public void close() throws XPathException {
            super.close();
            String fileName = FileAppenderStep.this.getParameter(FILE_NAME).toString();
            String value = FileAppenderStep.this.getParameter(VALUE).toString();
            String lineSeparator = FileAppenderStep.getLineSeparator(FileAppenderStep.this.getParameter(LINE_SEPARATOR));
            Charset encoding = FileAppenderStep.getCharset(FileAppenderStep.this.getParameter(ENCODING));
            File f = new File(fileName);
            try {
                FileOutputStream fos = new FileOutputStream(f, true);
                try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, encoding);){
                    osw.append(value);
                    osw.append(lineSeparator);
                    osw.flush();
                }
            }
            catch (IOException ex) {
                LOGGER.error("while writting to " + fileName, (Throwable)ex);
            }
        }
    }
}

