/*
 * Decompiled with CFR 0.152.
 */
package fr.efl.chaine.xslt.utils;

import fr.efl.chaine.xslt.StepJava;
import fr.efl.chaine.xslt.utils.FileAppenderStep;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileAppenderTerminalStep
extends StepJava {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileAppenderTerminalStep.class);

    public Receiver getReceiver(Configuration c) throws SaxonApiException {
        return new FileAppenderTerminalReceiver();
    }

    @Override
    public void close() throws SaxonApiException {
    }

    private class FileAppenderTerminalReceiver
    implements Receiver {
        private PipelineConfiguration pipelineConfiuration;
        private String systemId;

        private FileAppenderTerminalReceiver() {
        }

        public void setPipelineConfiguration(PipelineConfiguration pc) {
            this.pipelineConfiuration = pc;
        }

        public PipelineConfiguration getPipelineConfiguration() {
            return this.pipelineConfiuration;
        }

        public void setSystemId(String ssId) {
            this.systemId = ssId;
        }

        public void open() throws XPathException {
        }

        public void startDocument(int i) throws XPathException {
        }

        public void endDocument() throws XPathException {
        }

        public void setUnparsedEntity(String string, String string1, String string2) throws XPathException {
        }

        public void startElement(NodeName nn, SchemaType st, Location lctn, int i) throws XPathException {
        }

        public void namespace(NamespaceBinding nb, int i) throws XPathException {
        }

        public void attribute(NodeName nn, SimpleType st, CharSequence cs, Location lctn, int i) throws XPathException {
        }

        public void startContent() throws XPathException {
        }

        public void endElement() throws XPathException {
        }

        public void characters(CharSequence cs, Location lctn, int i) throws XPathException {
        }

        public void processingInstruction(String string, CharSequence cs, Location lctn, int i) throws XPathException {
        }

        public void comment(CharSequence cs, Location lctn, int i) throws XPathException {
        }

        public void close() throws XPathException {
            String fileName = FileAppenderTerminalStep.this.getParameter(FileAppenderStep.FILE_NAME).toString();
            String value = FileAppenderTerminalStep.this.getParameter(FileAppenderStep.VALUE).toString();
            String lineSeparator = FileAppenderStep.getLineSeparator(FileAppenderTerminalStep.this.getParameter(FileAppenderStep.LINE_SEPARATOR));
            Charset encoding = FileAppenderStep.getCharset(FileAppenderTerminalStep.this.getParameter(FileAppenderStep.ENCODING));
            File f = new File(fileName);
            try {
                FileOutputStream fos = new FileOutputStream(f, true);
                try (OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, encoding);){
                    osw.append(value);
                    osw.append(lineSeparator);
                    osw.flush();
                }
            }
            catch (IOException ex) {
                LOGGER.error("while writting to " + fileName, (Throwable)ex);
            }
        }

        public boolean usesTypeAnnotations() {
            return false;
        }

        public String getSystemId() {
            return this.systemId;
        }
    }
}

