/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.xml.gaulois.impl;

import fr.efl.chaine.xslt.SaxonConfigurationFactory;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.lib.ExtensionFunctionDefinition;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSaxonConfigurationFactory
extends SaxonConfigurationFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultSaxonConfigurationFactory.class);
    private Configuration configuration;

    public DefaultSaxonConfigurationFactory() {
        this.__initConfiguration();
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration;
    }

    private void __initConfiguration() {
        this.configuration = Configuration.newConfiguration();
        ClassLoader cl = this.getClass().getClassLoader();
        if (cl instanceof URLClassLoader) {
            Processor proc = new Processor(this.configuration);
            DocumentBuilder builder = proc.newDocumentBuilder();
            XPathCompiler xpCompiler = proc.newXPathCompiler();
            URLClassLoader ucl = (URLClassLoader)cl;
            try {
                Enumeration<URL> enumer = ucl.findResources("META-INF/services/top.marchand.xml.gaulois.xml");
                while (enumer.hasMoreElements()) {
                    URL url = enumer.nextElement();
                    LOGGER.debug("loading service " + url.toExternalForm());
                    XdmNode document = builder.build((Source)new StreamSource(url.openStream()));
                    XPathSelector selector = xpCompiler.compile("/gaulois-services/saxon/extensions/function").load();
                    selector.setContextItem((XdmItem)document);
                    XdmSequenceIterator it = selector.evaluate().iterator();
                    while (it.hasNext()) {
                        String className = it.next().getStringValue();
                        try {
                            Class<?> clazz = Class.forName(className);
                            if (this.extendsClass(clazz, ExtensionFunctionDefinition.class)) {
                                Class<?> cle = clazz;
                                this.configuration.registerExtensionFunction((ExtensionFunctionDefinition)cle.newInstance());
                                LOGGER.debug(className + "registered as Saxon extension function");
                                continue;
                            }
                            LOGGER.warn(className + " does not extends " + ExtensionFunctionDefinition.class.getName());
                        }
                        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
                            LOGGER.warn("unable to load extension function " + className);
                        }
                    }
                }
            }
            catch (IOException | SaxonApiException ex) {
                LOGGER.error("while looking for resources in /META-INF/services/top.marchand.xml.gaulois/", ex);
            }
        }
    }

    private boolean extendsClass(Class toCheck, Class inheritor) {
        if (toCheck.equals(inheritor)) {
            return true;
        }
        if (toCheck.equals(Object.class)) {
            return false;
        }
        return this.extendsClass(toCheck.getSuperclass(), inheritor);
    }
}

