/*
 * Decompiled with CFR 0.152.
 */
package fr.efl.chaine.xslt.config;

import fr.efl.chaine.xslt.GauloisPipe;
import fr.efl.chaine.xslt.InvalidSyntaxException;
import fr.efl.chaine.xslt.config.ParametrableStep;
import fr.efl.chaine.xslt.utils.ParameterValue;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import net.sf.saxon.s9api.QName;

public class Xslt
implements ParametrableStep {
    static final QName QNAME = new QName("http://efl.fr/chaine/saxon-pipe/config", "xslt");
    static final QName ATTR_HREF = new QName("href");
    static final QName ATTR_TRACE_ACTIVE = new QName("traceActive");
    static final QName ATTR_DEBUG = new QName("debug");
    static final QName ATTR_ID = new QName("id");
    private String href;
    private HashMap<QName, ParameterValue> params = new HashMap();
    private boolean traceToAdd = false;
    private File file;
    private boolean debug;
    private String id;

    public Xslt() {
    }

    public Xslt(String href) {
        this();
        this.href = href;
    }

    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    @Override
    public Collection<ParameterValue> getParams() {
        return this.params.values();
    }

    @Override
    public void addParameter(ParameterValue param) {
        if (param != null) {
            this.params.put(param.getKey(), param);
        }
    }

    private File getFile() throws URISyntaxException {
        if (this.file == null) {
            if (this.href.startsWith("jar:")) {
                this.file = new File(new URI(this.href));
            } else if (!this.href.startsWith("cp:")) {
                this.file = new File(this.href);
            }
        }
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void verify() throws InvalidSyntaxException {
        block15: {
            try {
                if (this.href.contains("$[")) break block15;
                if (this.href.startsWith("jar:")) {
                    try {
                        InputStream is = new URL(this.href).openStream();
                        Throwable throwable = null;
                        if (is != null) {
                            if (throwable != null) {
                                try {
                                    is.close();
                                }
                                catch (Throwable x2) {
                                    throwable.addSuppressed(x2);
                                }
                            } else {
                                is.close();
                            }
                        }
                        break block15;
                    }
                    catch (Exception ex) {
                        throw new InvalidSyntaxException("Unable to load " + this.href + ". Either jar file does not exist, or entry does not exist in.");
                    }
                }
                if (this.href.startsWith("cp:")) {
                    URL url = GauloisPipe.class.getResource(this.href.substring(3));
                    if (url == null) {
                        throw new InvalidSyntaxException("Unable to load " + this.href + " from classpath. Did you start with a '/' ?");
                    }
                } else {
                    File xslFile = this.getFile();
                    if (!xslFile.exists() || !xslFile.isFile()) {
                        throw new InvalidSyntaxException(this.getFile().getAbsolutePath() + " does not exists or is not a regular file");
                    }
                }
            }
            catch (URISyntaxException ex) {
                throw new InvalidSyntaxException(ex);
            }
        }
    }

    public boolean isTraceToAdd() {
        return this.traceToAdd;
    }

    void setTraceToAdd(boolean traceToAdd) {
        this.traceToAdd = traceToAdd;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("xslt href=").append(this.href);
        if (this.id != null) {
            sb.append(" id=").append(this.id);
        }
        sb.append("\n");
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

