/*
 * Decompiled with CFR 0.152.
 */
package fr.efl.chaine.xslt.config;

import fr.efl.chaine.xslt.InvalidSyntaxException;
import fr.efl.chaine.xslt.config.JavaStep;
import fr.efl.chaine.xslt.config.Verifiable;
import java.io.Serializable;
import net.sf.saxon.s9api.QName;

public class Listener
implements Verifiable,
Serializable {
    public static final int DEFAULT_PORT = 8888;
    public static final transient QName QName = new QName("http://efl.fr/chaine/saxon-pipe/config", "listener");
    public static final transient QName ATTR_PORT = new QName("port");
    public static final transient QName ATTR_STOP = new QName("stopKeyword");
    private final int port;
    private final String stopKeyword;
    private JavaStep javastep;

    public Listener(int port, String stopKeyword) {
        this.port = port;
        this.stopKeyword = stopKeyword;
    }

    public Listener(String stopKeyword) {
        this(8888, stopKeyword);
    }

    @Override
    public void verify() throws InvalidSyntaxException {
        if (this.stopKeyword == null || this.stopKeyword.length() < 3) {
            throw new InvalidSyntaxException("STOP keyword must be at least 3 chars length");
        }
        if (this.javastep != null) {
            this.javastep.verify();
        }
    }

    public int getPort() {
        return this.port;
    }

    public String getStopKeyword() {
        return this.stopKeyword;
    }

    public JavaStep getJavastep() {
        return this.javastep;
    }

    public void setJavastep(JavaStep javastep) {
        this.javastep = javastep;
    }
}

