/*
 * Decompiled with CFR 0.152.
 */
package fr.efl.chaine.xslt.config;

import fr.efl.chaine.xslt.InvalidSyntaxException;
import fr.efl.chaine.xslt.config.Verifiable;
import fr.efl.chaine.xslt.utils.ParameterValue;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Output
implements Verifiable {
    static final QName QNAME = new QName("http://efl.fr/chaine/saxon-pipe/config", "output");
    static final QName QN_CONSOLE = new QName("http://efl.fr/chaine/saxon-pipe/config", "console");
    static final QName ATTR_CONSOLE_WHICH = new QName("which");
    public static final HashMap<String, OutputPropertyEntry> VALID_OUTPUT_PROPERTIES = new HashMap();
    private static final Logger LOGGER = LoggerFactory.getLogger(Output.class);
    private String relativeTo;
    private String relativePath;
    private String absolute;
    private String prefix;
    private String suffix;
    private String name;
    private String console = null;
    private final OutputProperties outputProperties = new OutputProperties(){

        @Override
        public Object defineProperty(String key, String value) throws InvalidSyntaxException {
            if ("id".equals(key)) {
                return value;
            }
            OutputPropertyEntry ope = VALID_OUTPUT_PROPERTIES.get(key);
            if (ope != null) {
                if (ope.isValueValid(value)) {
                    return super.setProperty(key, value);
                }
                throw new InvalidSyntaxException(value + " is no a valid value for " + key);
            }
            throw new InvalidSyntaxException(key + " is not a valid output property");
        }
    };
    private boolean nullOutput = false;

    public void setRelativeTo(String relativeTo) {
        this.relativeTo = relativeTo;
        this.absolute = null;
    }

    public void setRelativePath(String relativePath) {
        this.relativePath = relativePath;
        this.absolute = null;
    }

    public void setAbsolute(String absolute) {
        this.absolute = absolute;
        this.relativePath = null;
        this.relativeTo = null;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public void setName(String name) {
        this.name = name;
    }

    private boolean isAbsolute() {
        return this.absolute != null;
    }

    public void setNull(boolean nullOutput) {
        this.nullOutput = nullOutput;
    }

    public void setOutputProperties(Properties props) throws InvalidSyntaxException {
        this.outputProperties.clear();
        for (Object key : props.keySet()) {
            this.outputProperties.defineProperty((String)key, (String)props.get(key));
        }
    }

    public void setOutputProperty(String key, String value) throws InvalidSyntaxException {
        this.outputProperties.defineProperty(key, value);
    }

    public void unsetOutputProperty(String key) {
        this.outputProperties.remove(key);
    }

    public boolean isNullOutput() {
        return this.nullOutput;
    }

    public Properties getOutputProperties() {
        Properties ret = new Properties();
        for (Object key : this.outputProperties.keySet()) {
            String sKey = key.toString();
            ret.setProperty(sKey, this.outputProperties.getProperty(sKey));
        }
        return ret;
    }

    public String getOutputProperty(String key) {
        return this.outputProperties.getProperty(key);
    }

    public File getDestinationFile(File sourceFile, HashMap<QName, ParameterValue> parameters) throws InvalidSyntaxException, URISyntaxException {
        File ret;
        if (this.isAbsolute()) {
            String __abs = this.absolute;
            int pos = __abs.indexOf("${");
            while (pos >= 0) {
                int closingPos = __abs.indexOf("}", pos);
                String propertyName = __abs.substring(pos + 2, closingPos);
                String propertyValue = System.getProperty(propertyName);
                if (propertyValue != null) {
                    LOGGER.debug("Replace system property {} with value {} in {} produces {}", (Object[])new String[]{propertyName, propertyValue, __abs, __abs.replaceAll("\\$\\{" + propertyName + "\\}", Matcher.quoteReplacement(propertyValue))});
                    __abs = __abs.replaceAll("\\$\\{" + propertyName + "\\}", Matcher.quoteReplacement(propertyValue));
                } else {
                    LOGGER.warn("System property " + propertyName + " is not defined");
                }
                pos = __abs.indexOf("${", pos + 1);
            }
            for (ParameterValue pv : parameters.values()) {
                LOGGER.debug("replacing $[" + pv.getKey() + "]");
                __abs = __abs.replaceAll("\\$\\[" + pv.getKey() + "\\]", pv.getValue());
            }
            File directory = __abs.startsWith("file:") ? new File(new URI(__abs)) : new File(__abs);
            ret = new File(directory, this.getFileName(sourceFile, parameters));
        } else {
            File directory = null;
            if ("source-file".equals(this.relativeTo)) {
                directory = sourceFile.getParentFile();
            } else if (this.relativeTo.startsWith("${")) {
                directory = new File(System.getProperty(this.relativeTo.substring(2).substring(0, this.relativeTo.length() - 3)));
            } else {
                throw new InvalidSyntaxException("folder/@to must be either source-file or ${xxx} where xxx is a system-property name. " + this.relativeTo + " is not a valid value");
            }
            directory = new File(directory, this.relativePath);
            ret = new File(directory, this.getFileName(sourceFile, parameters));
        }
        return ret;
    }

    private String getFileName(File sourceFile, HashMap<QName, ParameterValue> parameters) {
        String filename = (this.prefix != null ? this.prefix : "") + this.name + (this.suffix != null ? this.suffix : "");
        String sourceName = sourceFile.getName();
        int ix = sourceName.lastIndexOf(".");
        String extension = sourceName.substring(ix);
        String basename = sourceName.substring(0, ix);
        String ret = filename.replaceAll("\\$\\{name\\}", sourceName).replaceAll("\\$\\{basename\\}", basename).replaceAll("\\$\\{extension\\}", extension);
        for (ParameterValue pv : parameters.values()) {
            ret = ret.replaceAll("\\$\\[" + pv.getKey() + "\\]", pv.getValue());
        }
        return ret;
    }

    @Override
    public void verify() throws InvalidSyntaxException {
        if (this.nullOutput) {
            return;
        }
        if (this.isConsoleOutput()) {
            return;
        }
        if (!(this.isAbsolute() || this.relativePath != null && this.relativeTo != null)) {
            throw new InvalidSyntaxException("output is neither absolute nor relative");
        }
        if (this.name == null) {
            throw new InvalidSyntaxException("no strategy to calculate output filename is defined");
        }
    }

    public String toString() {
        return "Output{relativeTo=" + this.relativeTo + ", relativePath=" + this.relativePath + ", absolute=" + this.absolute + ", prefix=" + this.prefix + ", suffix=" + this.suffix + ", name=" + this.name + '}';
    }

    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(this.toString());
        return sb.toString();
    }

    public String getConsole() {
        return this.console;
    }

    public void setConsole(String console) throws InvalidSyntaxException {
        if (!"out".equals(console) && !"err".equals(console) && console != null) {
            throw new InvalidSyntaxException("Only out, err and null are valid values for console");
        }
        this.console = console;
    }

    public boolean isConsoleOutput() {
        return this.getConsole() != null;
    }

    static {
        VALID_OUTPUT_PROPERTIES.put("byte-order-mark", new OutputPropertyEntry(Serializer.Property.BYTE_ORDER_MARK, "yes", "no"));
        VALID_OUTPUT_PROPERTIES.put("cdata-section-elements", new OutputPropertyEntry(Serializer.Property.CDATA_SECTION_ELEMENTS, new String[0]));
        VALID_OUTPUT_PROPERTIES.put("doctype-public", new OutputPropertyEntry(Serializer.Property.DOCTYPE_PUBLIC, new String[0]));
        VALID_OUTPUT_PROPERTIES.put("doctype-system", new OutputPropertyEntry(Serializer.Property.DOCTYPE_SYSTEM, new String[0]));
        VALID_OUTPUT_PROPERTIES.put("encoding", new OutputPropertyEntry(Serializer.Property.ENCODING, new String[0]));
        VALID_OUTPUT_PROPERTIES.put("escape-uri-attributes", new OutputPropertyEntry(Serializer.Property.ESCAPE_URI_ATTRIBUTES, "yes", "no"));
        VALID_OUTPUT_PROPERTIES.put("include-content-type", new OutputPropertyEntry(Serializer.Property.INCLUDE_CONTENT_TYPE, "yes", "no"));
        VALID_OUTPUT_PROPERTIES.put("indent", new OutputPropertyEntry(Serializer.Property.INDENT, "yes", "no"));
        VALID_OUTPUT_PROPERTIES.put("media-type", new OutputPropertyEntry(Serializer.Property.MEDIA_TYPE, new String[0]));
        VALID_OUTPUT_PROPERTIES.put("method", new OutputPropertyEntry(Serializer.Property.METHOD, "xml", "html", "xhtml", "text"));
        VALID_OUTPUT_PROPERTIES.put("normalization-form", new OutputPropertyEntry(Serializer.Property.NORMALIZATION_FORM, "NFC", "NFD", "NFKC", "NFKD", "none"));
        VALID_OUTPUT_PROPERTIES.put("omit-xml-declaration", new OutputPropertyEntry(Serializer.Property.OMIT_XML_DECLARATION, "yes", "no"));
        VALID_OUTPUT_PROPERTIES.put("saxon-attribute-order", new OutputPropertyEntry(Serializer.Property.SAXON_ATTRIBUTE_ORDER, new String[0]));
        VALID_OUTPUT_PROPERTIES.put("saxon-character-representation", new OutputPropertyEntry(Serializer.Property.SAXON_CHARACTER_REPRESENTATION, new String[0]));
        VALID_OUTPUT_PROPERTIES.put("saxon-double-space", new OutputPropertyEntry(Serializer.Property.SAXON_DOUBLE_SPACE, new String[0]));
        VALID_OUTPUT_PROPERTIES.put("saxon-implicit-result-document", new OutputPropertyEntry(Serializer.Property.SAXON_IMPLICIT_RESULT_DOCUMENT, new String[0]));
        VALID_OUTPUT_PROPERTIES.put("saxon-indent-spaces", new OutputPropertyEntry(Serializer.Property.SAXON_INDENT_SPACES, new String[0]));
        VALID_OUTPUT_PROPERTIES.put("saxon-line-length", new OutputPropertyEntry(Serializer.Property.SAXON_LINE_LENGTH, new String[0]));
        VALID_OUTPUT_PROPERTIES.put("saxon-recognize-binary", new OutputPropertyEntry(Serializer.Property.SAXON_RECOGNIZE_BINARY, "yes", "no"));
        VALID_OUTPUT_PROPERTIES.put("saxon-suppress-inndentation", new OutputPropertyEntry(Serializer.Property.SAXON_SUPPRESS_INDENTATION, new String[0]));
        VALID_OUTPUT_PROPERTIES.put("standalone", new OutputPropertyEntry(Serializer.Property.STANDALONE, "yes", "no"));
        VALID_OUTPUT_PROPERTIES.put("undeclare-prefixes", new OutputPropertyEntry(Serializer.Property.UNDECLARE_PREFIXES, new String[0]));
        VALID_OUTPUT_PROPERTIES.put("use-character-maps", new OutputPropertyEntry(Serializer.Property.USE_CHARACTER_MAPS, new String[0]));
        VALID_OUTPUT_PROPERTIES.put("version", new OutputPropertyEntry(Serializer.Property.VERSION, "1.0", "1.1"));
    }

    public abstract class OutputProperties
    extends Properties {
        public abstract Object defineProperty(String var1, String var2) throws InvalidSyntaxException;
    }

    public static class OutputPropertyEntry {
        Serializer.Property saxonProp;
        List<String> validValuesList;

        public OutputPropertyEntry(Serializer.Property saxonProp, String ... values) {
            this.saxonProp = saxonProp;
            if (values != null && values.length > 0) {
                Arrays.sort(values);
                this.validValuesList = Arrays.asList(values);
            }
        }

        public Serializer.Property getSaxonProperty() {
            return this.saxonProp;
        }

        public boolean isValueValid(String value) {
            if (this.validValuesList == null || this.validValuesList.isEmpty()) {
                return true;
            }
            if (value == null) {
                return false;
            }
            return this.validValuesList.contains(value);
        }
    }
}

