/*
 * Decompiled with CFR 0.152.
 */
package fr.efl.chaine.xslt.config;

import fr.efl.chaine.xslt.InvalidSyntaxException;
import fr.efl.chaine.xslt.config.JavaStep;
import fr.efl.chaine.xslt.config.Output;
import fr.efl.chaine.xslt.config.ParametrableStep;
import fr.efl.chaine.xslt.config.Tee;
import fr.efl.chaine.xslt.config.Verifiable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.saxon.s9api.QName;

public class Pipe
implements Verifiable {
    static final QName QNAME = new QName("http://efl.fr/chaine/saxon-pipe/config", "pipe");
    static final String ATTR_NB_THREADS = "nbThreads";
    static final String ATTR_MAX = "mutiThreadMaxSourceSize";
    static final String ATTR_TRACE = "traceOutput";
    private int multithreadMaxSourceSize = 0xA00000;
    private int nbThreads = 1;
    private String traceOutput;
    private final List<ParametrableStep> xslts = new ArrayList<ParametrableStep>();
    private Output output;
    private Tee tee;
    private Tee parentTee = null;

    public Pipe() {
    }

    public Pipe(Tee parent) {
        this();
        this.parentTee = parent;
    }

    public int getMultithreadMaxSourceSize() {
        return this.multithreadMaxSourceSize;
    }

    void setMultithreadMaxSourceSize(int multithreadMaxSourceSize) {
        this.multithreadMaxSourceSize = multithreadMaxSourceSize;
    }

    public int getNbThreads() {
        return this.nbThreads;
    }

    void setNbThreads(int nbThreads) {
        this.nbThreads = nbThreads;
    }

    public Iterator<ParametrableStep> getXslts() {
        return this.xslts.iterator();
    }

    public void addXslt(ParametrableStep xsl) throws InvalidSyntaxException {
        if (this.output != null || this.tee != null) {
            throw new InvalidSyntaxException("xsl|javaStep elements must not be added after a output or a tee element");
        }
        this.xslts.add(xsl);
    }

    @Override
    public void verify() throws InvalidSyntaxException {
        for (ParametrableStep x : this.xslts) {
            x.verify();
        }
        if (!this.xslts.isEmpty() && this.xslts.get(0) instanceof JavaStep && this.parentTee == null) {
            throw new InvalidSyntaxException("A java step must not be the first step of a pipe. Please a identity XSL to start pipe.");
        }
        if (this.tee != null) {
            this.tee.verify();
        }
        if (this.output != null) {
            this.output.verify();
        }
    }

    public Output getOutput() {
        return this.output;
    }

    public void setOutput(Output output) throws InvalidSyntaxException {
        if (this.tee != null) {
            throw new InvalidSyntaxException("a pipe must be terminated either by a tee or by an output");
        }
        this.output = output;
    }

    public Tee getTee() {
        return this.tee;
    }

    public void setTee(Tee tee) throws InvalidSyntaxException {
        if (this.output != null) {
            throw new InvalidSyntaxException("a pipe must be terminated either by a tee or by an output");
        }
        this.tee = tee;
    }

    public boolean isFinal() {
        return this.output != null;
    }

    public boolean isStraight() {
        return this.tee == null;
    }

    public String getTraceOutput() {
        return this.traceOutput;
    }

    void setTraceOutput(String traceOutput) {
        this.traceOutput = traceOutput;
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        String _p = prefix + "  ";
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append("pipe\n");
        for (ParametrableStep ps : this.xslts) {
            sb.append(ps.toString(_p));
        }
        if (this.output != null) {
            sb.append(this.output.toString(_p));
        }
        if (this.tee != null) {
            sb.append(this.tee.toString(_p));
        }
        return sb.toString();
    }
}

