/*
 * Decompiled with CFR 0.152.
 */
package fr.efl.chaine.xslt.config;

import fr.efl.chaine.xslt.InvalidSyntaxException;
import fr.efl.chaine.xslt.config.CfgFile;
import fr.efl.chaine.xslt.config.ChooseStep;
import fr.efl.chaine.xslt.config.Config;
import fr.efl.chaine.xslt.config.JavaStep;
import fr.efl.chaine.xslt.config.Listener;
import fr.efl.chaine.xslt.config.Namespaces;
import fr.efl.chaine.xslt.config.Output;
import fr.efl.chaine.xslt.config.Pipe;
import fr.efl.chaine.xslt.config.Sources;
import fr.efl.chaine.xslt.config.Tee;
import fr.efl.chaine.xslt.config.WhenEntry;
import fr.efl.chaine.xslt.config.Xslt;
import fr.efl.chaine.xslt.utils.ParameterValue;
import fr.efl.chaine.xslt.utils.ParametersMerger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ConfigUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigUtil.class);
    private static final QName CONFIG_EL = new QName("http://efl.fr/chaine/saxon-pipe/config", "config");
    private static final QName PARAM_NAME = new QName("name");
    private static final QName PARAM_VALUE = new QName("value");
    private static final QName QN_PATTERN = new QName("pattern");
    private static final QName QN_RECURSE = new QName("recurse");
    private static final QName QN_PARAM = new QName("http://efl.fr/chaine/saxon-pipe/config", "param");
    private static final QName QN_NULL = new QName("http://efl.fr/chaine/saxon-pipe/config", "null");
    private final File currentDir;
    private final Configuration saxonConfig;
    private final URIResolver uriResolver;
    private final String configUri;
    private final boolean skipSchemaValidation;
    private boolean __isConfigUriTrueURI = false;

    public ConfigUtil(Configuration saxonConfig, URIResolver uriResolver, String configUri) throws InvalidSyntaxException {
        this(saxonConfig, uriResolver, configUri, false, System.getProperty("user.dir"));
    }

    public ConfigUtil(Configuration saxonConfig, URIResolver uriResolver, String configUri, boolean skipSchemaValidation, String currentDir) throws InvalidSyntaxException {
        this.saxonConfig = saxonConfig;
        this.uriResolver = uriResolver;
        this.skipSchemaValidation = skipSchemaValidation;
        Pattern pattern = Pattern.compile("[a-z].+:.+");
        if (pattern.matcher(configUri).matches()) {
            try {
                URL url = new URL(configUri);
                InputStream is = url.openStream();
                if (is == null) {
                    throw new InvalidSyntaxException(configUri + " not found or can not be open");
                }
                this.__isConfigUriTrueURI = true;
            }
            catch (IOException ex) {
                throw new InvalidSyntaxException(configUri + " not found or can not be open");
            }
        } else {
            File file = new File(configUri);
            if (!file.exists() && !file.isFile()) {
                throw new InvalidSyntaxException(configUri + " not found or not a regular file");
            }
        }
        this.configUri = configUri;
        this.currentDir = new File(currentDir);
    }

    public Config buildConfig(HashMap<QName, ParameterValue> inputParameters) throws SaxonApiException, InvalidSyntaxException {
        try {
            Processor processor = new Processor(this.saxonConfig);
            if (!this.skipSchemaValidation) {
                try {
                    System.setProperty("javax.xml.validation.SchemaFactory:http://www.w3.org/2001/XMLSchema/v1.1", "org.apache.xerces.jaxp.validation.XMLSchema11Factory");
                    SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema/v1.1");
                    Source schemaSource = this.saxonConfig.getURIResolver().resolve("cp:/fr/efl/chaine/xslt/schemas/gaulois-pipe_config.xsd", null);
                    Schema schema = schemaFactory.newSchema(schemaSource);
                    SchemaValidationErrorListener errListener = new SchemaValidationErrorListener();
                    Validator validator = schema.newValidator();
                    validator.setErrorHandler(errListener);
                    SAXSource saxSource = new SAXSource(this.__isConfigUriTrueURI ? new InputSource(new URL(this.configUri).openStream()) : new InputSource(new FileInputStream(new File(this.configUri))));
                    validator.validate(saxSource);
                    if (errListener.hasErrors()) {
                        throw new InvalidSyntaxException(this.configUri + " does not respect gaulois-pipe schema");
                    }
                }
                catch (IOException | TransformerException | SAXException ex) {
                    LOGGER.error("while verifying schema conformity", (Throwable)ex);
                }
                catch (Error er) {
                    LOGGER.error("java.protocol.handler.pkgs=" + System.getProperty("java.protocol.handler.pkgs"));
                    LOGGER.error("while parsing config", (Throwable)er);
                    throw er;
                }
            }
            XdmNode configRoot = this.__isConfigUriTrueURI ? processor.newDocumentBuilder().build(this.uriResolver.resolve(this.configUri, null)) : processor.newDocumentBuilder().build(new File(this.configUri));
            XPathSelector xs = processor.newXPathCompiler().compile("/*").load();
            xs.setContextItem((XdmItem)configRoot);
            XdmNode root = (XdmNode)xs.evaluateSingle();
            if (CONFIG_EL.equals((Object)root.getNodeName())) {
                XdmSequenceIterator outputIt;
                Config config = new Config(root);
                XdmSequenceIterator it = root.axisIterator(Axis.CHILD, Namespaces.QNAME);
                Namespaces namespaces = new Namespaces();
                while (it.hasNext()) {
                    XdmNode ns = (XdmNode)it.next();
                    XdmSequenceIterator itm = ns.axisIterator(Axis.CHILD, Namespaces.QN_MAPPING);
                    while (itm.hasNext()) {
                        XdmNode node = (XdmNode)itm.next();
                        String prefix = node.getAttributeValue(Namespaces.ATTR_PREFIX);
                        String uri = node.getAttributeValue(Namespaces.ATTR_URI);
                        namespaces.getMappings().put(prefix, uri);
                    }
                }
                config.setNamespaces(namespaces);
                it.close();
                HashMap<QName, ParameterValue> configParameters = new HashMap<QName, ParameterValue>();
                it = root.axisIterator(Axis.CHILD, Config.PARAMS_CHILD);
                while (it.hasNext()) {
                    XdmNode params = (XdmNode)it.next();
                    XdmSequenceIterator itp = params.axisIterator(Axis.CHILD, new QName("http://efl.fr/chaine/saxon-pipe/config", "param"));
                    while (itp.hasNext()) {
                        ParameterValue pv = this.buildParameter((XdmNode)itp.next(), inputParameters);
                        configParameters.put(pv.getKey(), pv);
                    }
                }
                config.getParams().putAll(ParametersMerger.merge(inputParameters, configParameters));
                config.setPipe(this.buildPipe((XdmNode)root.axisIterator(Axis.CHILD, Pipe.QNAME).next(), config.getParams()));
                XdmSequenceIterator sourceIterator = root.axisIterator(Axis.CHILD, Sources.QNAME);
                if (sourceIterator.hasNext()) {
                    config.setSources(this.buildSources((XdmNode)sourceIterator.next(), config.getParams()));
                }
                if ((outputIt = root.axisIterator(Axis.CHILD, Output.QNAME)).hasNext()) {
                    LOGGER.warn("Defining <output/> in config is now deprecated - but still works. You should define it in <pipe/>");
                    if (config.getPipe().getOutput() == null) {
                        config.getPipe().setOutput(this.buildOutput((XdmNode)outputIt.next(), config.getParams()));
                    } else {
                        throw new InvalidSyntaxException("Using output outside of pipe is deprecated but supported, only if pipe has no output defined");
                    }
                }
                return config;
            }
            throw new InvalidSyntaxException("The file " + this.configUri + " does not respect schema saxon-pipe_config.xsd");
        }
        catch (TransformerException ex) {
            throw new InvalidSyntaxException(this.configUri + " can not be read.");
        }
    }

    private Pipe buildPipe(XdmNode pipeNode, HashMap<QName, ParameterValue> parameters) throws IllegalStateException, InvalidSyntaxException {
        return this.buildPipe(pipeNode, parameters, null);
    }

    private Pipe buildPipe(XdmNode pipeNode, HashMap<QName, ParameterValue> parameters, Tee parentTee) throws IllegalStateException, InvalidSyntaxException {
        LOGGER.trace("buildPipe on " + pipeNode.getNodeName());
        Pipe pipe = new Pipe(parentTee);
        try {
            int nbThreads = Integer.parseInt(this.resolveEscapes(pipeNode.getAttributeValue(new QName("nbThreads")), parameters));
            pipe.setNbThreads(nbThreads);
        }
        catch (Throwable nbThreads) {
            // empty catch block
        }
        try {
            int max = Integer.parseInt(this.resolveEscapes(pipeNode.getAttributeValue(new QName("mutiThreadMaxSourceSize")), parameters));
            pipe.setMultithreadMaxSourceSize(max);
        }
        catch (Throwable max) {
            // empty catch block
        }
        pipe.setTraceOutput(this.resolveEscapes(pipeNode.getAttributeValue(new QName("traceOutput")), parameters));
        XdmSequenceIterator it = pipeNode.axisIterator(Axis.CHILD);
        while (it.hasNext()) {
            XdmItem item = it.next();
            if (!(item instanceof XdmNode)) continue;
            XdmNode node = (XdmNode)item;
            if (Xslt.QNAME.equals((Object)node.getNodeName())) {
                pipe.addXslt(this.buildXslt(node, parameters));
                continue;
            }
            if (JavaStep.QNAME.equals((Object)node.getNodeName())) {
                pipe.addXslt(this.buildJavaStep(node, parameters));
                continue;
            }
            if (ChooseStep.QNAME.equals((Object)node.getNodeName())) {
                pipe.addXslt(this.buildChooseStep(node, parameters));
                continue;
            }
            if (Tee.QNAME.equals((Object)node.getNodeName())) {
                pipe.setTee(this.buildTee(node, parameters));
                continue;
            }
            if (Output.QNAME.equals((Object)node.getNodeName())) {
                pipe.setOutput(this.buildOutput(node, parameters));
                continue;
            }
            if (node.getNodeKind() == XdmNodeKind.TEXT || node.getNodeKind() == XdmNodeKind.COMMENT) continue;
            throw new InvalidSyntaxException(node.getNodeKind().toString() + " - " + node.getNodeName() + ": unexpected element in " + Pipe.QNAME);
        }
        return pipe;
    }

    private Tee buildTee(XdmNode teeNode, HashMap<QName, ParameterValue> parameters) throws InvalidSyntaxException {
        LOGGER.trace("buildTee on " + teeNode.getNodeName());
        Tee tee = new Tee();
        XdmSequenceIterator seq = teeNode.axisIterator(Axis.CHILD, Pipe.QNAME);
        while (seq.hasNext()) {
            XdmNode node = (XdmNode)seq.next();
            Pipe pipe = this.buildPipe(node, parameters, tee);
            tee.addPipe(pipe);
        }
        return tee;
    }

    private Sources buildSources(XdmNode sourcesNode, HashMap<QName, ParameterValue> parameters) throws InvalidSyntaxException {
        String orderBy = sourcesNode.getAttributeValue(Sources.ATTR_ORDERBY);
        String sort = sourcesNode.getAttributeValue(Sources.ATTR_SORT);
        LOGGER.trace("buildSources from {} with orderBy={} and sort={}", new Object[]{sourcesNode.getNodeName(), orderBy, sort});
        Sources sources = new Sources(orderBy, sort);
        XdmSequenceIterator it = sourcesNode.axisIterator(Axis.CHILD);
        while (it.hasNext()) {
            XdmNode node = (XdmNode)it.next();
            LOGGER.trace("buildSource from {}", (Object)node.getNodeName());
            if (CfgFile.QNAME.equals((Object)node.getNodeName())) {
                try {
                    CfgFile localFile = this.buildFile(node, parameters);
                    LOGGER.trace("add source {}", (Object)localFile);
                    sources.addFile(localFile);
                    continue;
                }
                catch (URISyntaxException ex) {
                    LOGGER.error(ex.getMessage(), (Throwable)ex);
                    throw new InvalidSyntaxException(ex);
                }
            }
            if (CfgFile.QN_FOLDER.equals((Object)node.getNodeName())) {
                Collection<CfgFile> files = this.buildFolderContent(node, parameters);
                LOGGER.trace("buildSources from folder contains {} files", (Object)files.size());
                sources.addFiles(files);
                continue;
            }
            if (!Listener.QName.equals((Object)node.getNodeName())) continue;
            sources.setListener(this.buildListener(node, parameters));
        }
        return sources;
    }

    private Listener buildListener(XdmNode listenerNode, HashMap<QName, ParameterValue> parameters) throws InvalidSyntaxException {
        String tmp = this.resolveEscapes(listenerNode.getAttributeValue(Listener.ATTR_PORT), parameters);
        int port = 8888;
        try {
            port = Integer.parseInt(tmp);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String stopKeyword = this.resolveEscapes(listenerNode.getAttributeValue(Listener.ATTR_STOP), parameters);
        Listener list = new Listener(port, stopKeyword);
        XdmSequenceIterator it = listenerNode.axisIterator(Axis.CHILD, JavaStep.QNAME);
        if (it.hasNext()) {
            list.setJavastep(this.buildJavaStep((XdmNode)it.next(), parameters));
        }
        return list;
    }

    private Xslt buildXslt(XdmNode xsltNode, HashMap<QName, ParameterValue> parameters) {
        LOGGER.trace("buildXslt on {}", (Object)xsltNode.getNodeName());
        Xslt ret = new Xslt(this.resolveEscapes(xsltNode.getAttributeValue(Xslt.ATTR_HREF), parameters));
        if ("true".equals(xsltNode.getAttributeValue(Xslt.ATTR_TRACE_ACTIVE))) {
            ret.setTraceToAdd(true);
        }
        if ("true".equals(xsltNode.getAttributeValue(Xslt.ATTR_DEBUG))) {
            ret.setDebug(true);
            ret.setId(xsltNode.getAttributeValue(Xslt.ATTR_ID));
        }
        XdmSequenceIterator it = xsltNode.axisIterator(Axis.CHILD, QN_PARAM);
        while (it.hasNext()) {
            ret.addParameter(this.buildParameter((XdmNode)it.next(), parameters));
        }
        return ret;
    }

    private JavaStep buildJavaStep(XdmNode javaNode, HashMap<QName, ParameterValue> parameters) throws InvalidSyntaxException {
        LOGGER.trace("buildJavaStep on {}", (Object)javaNode.getNodeName());
        JavaStep ret = new JavaStep(this.resolveEscapes(javaNode.getAttributeValue(JavaStep.ATTR_CLASS), parameters));
        XdmSequenceIterator it = javaNode.axisIterator(Axis.CHILD, QN_PARAM);
        while (it.hasNext()) {
            ret.addParameter(this.buildParameter((XdmNode)it.next(), parameters));
        }
        return ret;
    }

    private ChooseStep buildChooseStep(XdmNode chooseNode, HashMap<QName, ParameterValue> parameters) throws InvalidSyntaxException {
        XdmNode whenNode;
        LOGGER.trace("buildChooseStep on {}", (Object)chooseNode.getNodeName());
        ChooseStep chooseStep = new ChooseStep();
        XdmSequenceIterator it = chooseNode.axisIterator(Axis.CHILD, WhenEntry.QNAME);
        while (it.hasNext()) {
            whenNode = (XdmNode)it.next();
            chooseStep.addWhen(this.buildWhen(whenNode, parameters));
        }
        it = chooseNode.axisIterator(Axis.CHILD, WhenEntry.QN_OTHERWISE);
        while (it.hasNext()) {
            whenNode = (XdmNode)it.next();
            chooseStep.addWhen(this.buildWhen(whenNode, parameters));
        }
        return chooseStep;
    }

    private WhenEntry buildWhen(XdmNode whenNode, HashMap<QName, ParameterValue> parameters) throws InvalidSyntaxException {
        String test = whenNode.getAttributeValue(WhenEntry.ATTR_TEST);
        if ((test == null || test.length() == 0) && WhenEntry.QN_OTHERWISE.equals((Object)whenNode.getNodeName())) {
            test = "true()";
        }
        WhenEntry when = new WhenEntry(test);
        XdmSequenceIterator it = whenNode.axisIterator(Axis.CHILD);
        while (it.hasNext()) {
            XdmItem item = it.next();
            if (!(item instanceof XdmNode)) continue;
            XdmNode node = (XdmNode)item;
            if (Xslt.QNAME.equals((Object)node.getNodeName())) {
                when.addStep(this.buildXslt(node, parameters));
                continue;
            }
            if (JavaStep.QNAME.equals((Object)node.getNodeName())) {
                when.addStep(this.buildJavaStep(node, parameters));
                continue;
            }
            if (ChooseStep.QNAME.equals((Object)node.getNodeName())) {
                when.addStep(this.buildChooseStep(node, parameters));
                continue;
            }
            if (node.getNodeKind() == XdmNodeKind.TEXT || node.getNodeKind() == XdmNodeKind.COMMENT) continue;
            throw new InvalidSyntaxException(node.getNodeKind().toString() + " - " + node.getNodeName() + ": unexpected element in " + Pipe.QNAME);
        }
        return when;
    }

    private ParameterValue buildParameter(XdmNode param, HashMap<QName, ParameterValue> parameters) {
        LOGGER.trace("buildParameter on " + param.getNodeName());
        ParameterValue pv = new ParameterValue(ConfigUtil.resolveQName(param.getAttributeValue(PARAM_NAME)), this.resolveEscapes(param.getAttributeValue(PARAM_VALUE), parameters));
        if (parameters.containsKey(pv.getKey())) {
            return parameters.get(pv.getKey());
        }
        return pv;
    }

    public static QName resolveQName(String name) {
        if (name == null) {
            return null;
        }
        if (name.length() == 0) {
            return null;
        }
        if (name.startsWith("Q{")) {
            return QName.fromEQName((String)name);
        }
        if (name.startsWith("{")) {
            return QName.fromClarkName((String)name);
        }
        return new QName(name);
    }

    private CfgFile buildFile(XdmNode node, HashMap<QName, ParameterValue> parameters) throws URISyntaxException {
        File f;
        String href = node.getAttributeValue(CfgFile.ATTR_HREF);
        LOGGER.trace("buildFile from {} with href={}", (Object)node.getNodeName(), (Object)href);
        href = this.resolveEscapes(href, parameters);
        if (href.startsWith("file:")) {
            f = new File(new URI(href));
        } else {
            f = new File(href);
            if (!f.exists()) {
                f = new File(this.currentDir, href);
            }
        }
        LOGGER.trace("buildFile on {}", (Object)f.getName());
        CfgFile ret = new CfgFile(f);
        XdmSequenceIterator it = node.axisIterator(Axis.CHILD, QN_PARAM);
        while (it.hasNext()) {
            ret.addParameter(this.buildParameter((XdmNode)it.next(), parameters));
        }
        ParameterValue relativeFile = new ParameterValue(ParametersMerger.INPUT_RELATIVE_FILE, f.toURI().toString());
        ret.addParameter(relativeFile);
        ParameterValue relativeDir = new ParameterValue(ParametersMerger.INPUT_RELATIVE_DIR, f.getParentFile().toURI().toString());
        ret.addParameter(relativeDir);
        return ret;
    }

    String resolveEscapes(String input, HashMap<QName, ParameterValue> params) {
        LOGGER.debug("resolveEscapes in " + input + " with " + params);
        if (input == null) {
            return input;
        }
        String ret = input;
        return ParametersMerger.processParametersReplacement(ret, params);
    }

    private Collection<CfgFile> buildFolderContent(XdmNode node, HashMap<QName, ParameterValue> parameters) throws InvalidSyntaxException {
        File dir;
        LOGGER.trace("buildFolderContent on " + node.getNodeName());
        String pattern = this.resolveEscapes(node.getAttributeValue(QN_PATTERN), parameters);
        boolean recurse = this.getBooleanValue(node.getAttributeValue(QN_RECURSE));
        HashMap<QName, ParameterValue> params = new HashMap<QName, ParameterValue>();
        XdmSequenceIterator it = node.axisIterator(Axis.CHILD, QN_PARAM);
        while (it.hasNext()) {
            ParameterValue p = this.buildParameter((XdmNode)it.next(), parameters);
            params.put(p.getKey(), p);
        }
        if (pattern == null) {
            pattern = "$.*^";
        }
        final Pattern regex = Pattern.compile(pattern);
        LOGGER.trace("checking filenames to " + regex.toString());
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String filename) {
                boolean match = regex.matcher(filename).matches();
                if (!match) {
                    LOGGER.trace(filename + " not matched");
                }
                return match;
            }
        };
        String fileName = this.resolveEscapes(node.getAttributeValue(CfgFile.ATTR_HREF), parameters);
        try {
            dir = new File(new URI(fileName));
        }
        catch (IllegalArgumentException | URISyntaxException ex) {
            dir = new File(this.currentDir, fileName);
        }
        if (!dir.isDirectory()) {
            throw new InvalidSyntaxException(dir.getAbsolutePath() + " is not a valid directory");
        }
        LOGGER.trace("dir=" + dir + ", filter=" + filter + ", recurse=" + recurse);
        List<CfgFile> files = this.getFilesFromDirectory(dir, filter, recurse);
        Path dirPath = dir.toPath();
        for (CfgFile sourceFile : files) {
            for (ParameterValue p : params.values()) {
                sourceFile.addParameter(p);
            }
            ParameterValue relativeFile = new ParameterValue(ParametersMerger.INPUT_RELATIVE_FILE, this.makeAsUri(dirPath.relativize(sourceFile.getSource().toPath())));
            sourceFile.addParameter(relativeFile);
            ParameterValue relativeDir = new ParameterValue(ParametersMerger.INPUT_RELATIVE_DIR, this.makeAsUri(dirPath.relativize(sourceFile.getSource().getParentFile().toPath())));
            sourceFile.addParameter(relativeDir);
        }
        return files;
    }

    private String makeAsUri(Path p) {
        return p.toString().replaceAll("\\\\", "/");
    }

    private Output buildOutput(XdmNode node, HashMap<QName, ParameterValue> parameters) throws InvalidSyntaxException {
        LOGGER.trace("buildOutput from {}", (Object)node.getNodeName());
        Output ret = new Output();
        XdmSequenceIterator attributes = node.axisIterator(Axis.ATTRIBUTE);
        while (attributes.hasNext()) {
            XdmNode attr = (XdmNode)attributes.next();
            ret.setOutputProperty(attr.getNodeName().getLocalName(), this.resolveEscapes(attr.getStringValue(), parameters));
        }
        boolean nullOutput = node.axisIterator(Axis.CHILD, QN_NULL).hasNext();
        if (nullOutput) {
            ret.setNull(true);
        } else {
            XdmSequenceIterator consoleIterator = node.axisIterator(Axis.CHILD, Output.QN_CONSOLE);
            if (consoleIterator.hasNext()) {
                XdmNode console = (XdmNode)consoleIterator.next();
                String sConsole = console.getAttributeValue(Output.ATTR_CONSOLE_WHICH);
                if (sConsole == null) {
                    sConsole = "out";
                }
                ret.setConsole(sConsole);
            } else {
                XdmNode folder = (XdmNode)node.axisIterator(Axis.CHILD, CfgFile.QN_FOLDER).next();
                String relative = this.resolveEscapes(folder.getAttributeValue(new QName("relative")), parameters);
                String temp = folder.getAttributeValue(new QName("to"));
                String to = this.resolveEscapes(temp, parameters);
                String absolute = this.resolveEscapes(folder.getAttributeValue(new QName("absolute")), parameters);
                if (relative != null) {
                    ret.setRelativePath(relative);
                }
                if (to != null) {
                    ret.setRelativeTo(to);
                }
                if (absolute != null) {
                    ret.setAbsolute(absolute);
                }
                XdmNode filename = (XdmNode)node.axisIterator(Axis.CHILD, new QName("http://efl.fr/chaine/saxon-pipe/config", "fileName")).next();
                String prefix = this.resolveEscapes(filename.getAttributeValue(new QName("prefix")), parameters);
                String name = this.resolveEscapes(filename.getAttributeValue(new QName("name")), parameters);
                String suffix = this.resolveEscapes(filename.getAttributeValue(new QName("suffix")), parameters);
                if (prefix != null) {
                    ret.setPrefix(prefix);
                }
                if (name != null) {
                    ret.setName(name);
                }
                if (suffix != null) {
                    ret.setSuffix(suffix);
                }
            }
        }
        return ret;
    }

    List<CfgFile> getFilesFromDirectory(File directory, FilenameFilter filter, boolean recurse) {
        File[] files = directory.listFiles();
        ArrayList<CfgFile> ret = new ArrayList<CfgFile>();
        for (File f : files) {
            if (f.isDirectory() && recurse) {
                ret.addAll(this.getFilesFromDirectory(f, filter, recurse));
                continue;
            }
            if (!filter.accept(f.getParentFile(), f.getName())) continue;
            ret.add(new CfgFile(f));
        }
        return ret;
    }

    private boolean getBooleanValue(String v) {
        return "true".equals(v) || "1".equals(v) || "yes".equals(v);
    }

    public static void addConfigParameter(Config config, String parameterPattern) throws InvalidSyntaxException {
        config.addParameter(ConfigUtil.parseParameterPattern(parameterPattern));
    }

    public static ParameterValue parseParameterPattern(String parameterPattern) throws InvalidSyntaxException {
        String[] dec = parameterPattern.split("=");
        if (dec.length != 2) {
            throw new InvalidSyntaxException(parameterPattern + " is not a valid parameter declaration");
        }
        return new ParameterValue(ConfigUtil.resolveQName(dec[0]), dec[1]);
    }

    public static void setNbThreads(Config config, String argument) throws InvalidSyntaxException {
        try {
            if (config.getPipe() == null) {
                Pipe pipe = new Pipe();
                pipe.setNbThreads(Integer.parseInt(argument));
                config.setPipe(pipe);
            }
        }
        catch (Exception ex) {
            throw new InvalidSyntaxException(ex);
        }
    }

    public static void addInputFile(Config config, String argument) throws InvalidSyntaxException {
        Sources sources = config.getSources();
        if (sources == null) {
            sources = new Sources();
            config.setSources(sources);
        }
        sources.addFile(ConfigUtil.resolveInputFile(argument));
    }

    public static void addTemplate(Config config, String argument) throws InvalidSyntaxException {
        Pipe pipe = config.getPipe();
        if (pipe == null) {
            pipe = new Pipe();
            config.setPipe(pipe);
        }
        pipe.addXslt(ConfigUtil.resolveTemplate(argument));
    }

    public static void setOutput(Config config, String argument) throws InvalidSyntaxException {
        if (config.getPipe() == null) {
            Output output = new Output();
            output.setAbsolute(argument);
            output.setName("${name}");
            config.getPipe().setOutput(output);
        }
    }

    private static Xslt resolveTemplate(String path) {
        int index = path.indexOf("(");
        String filePath = index > 0 ? path.substring(0, index) : path;
        String sParams = index > 0 ? path.substring(index + 1, path.length() - 1).trim() : "";
        Xslt ret = new Xslt(filePath);
        for (ParameterValue p : ConfigUtil.getParametersOfTemplate(sParams)) {
            ret.addParameter(p);
        }
        return ret;
    }

    private static CfgFile resolveInputFile(String path) {
        int index = path.indexOf("(");
        String filePath = index > 0 ? path.substring(0, index) : path;
        String sParams = index > 0 ? path.substring(index + 1, path.length() - 1).trim() : "";
        CfgFile ret = new CfgFile(new File(filePath));
        for (ParameterValue p : ConfigUtil.getParametersOfTemplate(sParams)) {
            ret.addParameter(p);
        }
        ParameterValue relativeFile = new ParameterValue(ParametersMerger.INPUT_RELATIVE_FILE, ret.getSource().toURI().toString());
        ret.addParameter(relativeFile);
        ParameterValue relativeDir = new ParameterValue(ParametersMerger.INPUT_RELATIVE_DIR, ret.getSource().getParentFile().toURI().toString());
        ret.addParameter(relativeDir);
        return ret;
    }

    private static List<ParameterValue> getParametersOfTemplate(String s) {
        String[] entries;
        ArrayList<ParameterValue> ret = new ArrayList<ParameterValue>();
        for (String entry : entries = s.split(",")) {
            String[] ps = entry.split("=");
            if (ps.length != 2) continue;
            ParameterValue p = new ParameterValue(ConfigUtil.resolveQName(ps[0]), ps[1]);
            ret.add(p);
        }
        return ret;
    }

    private class SchemaValidationErrorListener
    implements ErrorHandler {
        private boolean errors = false;

        private SchemaValidationErrorListener() {
        }

        public boolean hasErrors() {
            return this.errors;
        }

        @Override
        public void warning(SAXParseException exception) throws SAXException {
            LOGGER.warn("validating configFile: " + exception.getMessage());
        }

        @Override
        public void error(SAXParseException exception) throws SAXException {
            LOGGER.warn("validating configFile: " + exception.getMessage());
            this.errors = true;
        }

        @Override
        public void fatalError(SAXParseException exception) throws SAXException {
            LOGGER.warn("validating configFile: " + exception.getMessage());
            this.errors = true;
        }
    }
}

