/*
 * Decompiled with CFR 0.152.
 */
package fr.efl.chaine.xslt.utils;

import fr.efl.chaine.xslt.utils.ParameterValue;
import java.io.File;
import java.util.HashMap;
import java.util.regex.Matcher;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmAtomicValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.marchand.xml.gaulois.config.typing.DatatypeFactory;

public class ParametersMerger {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParametersMerger.class);
    public static final QName INPUT_BASENAME = new QName("input-basename");
    public static final QName INPUT_NAME = new QName("input-name");
    public static final QName INPUT_EXTENSION = new QName("input-extension");
    public static final QName INPUT_ABSOLUTE = new QName("input-absolute");
    public static final QName INPUT_RELATIVE_FILE = new QName("input-relative-file");
    public static final QName INPUT_RELATIVE_DIR = new QName("input-relative-dir");

    public static HashMap<QName, ParameterValue> merge(HashMap<QName, ParameterValue> highPriority, HashMap<QName, ParameterValue> lowPriority) {
        HashMap<QName, ParameterValue> ret = new HashMap<QName, ParameterValue>();
        ret.putAll(highPriority);
        for (ParameterValue pv : lowPriority.values()) {
            if (ret.containsKey(pv.getKey())) continue;
            ret.put(pv.getKey(), pv);
        }
        for (ParameterValue pv : ret.values()) {
            if (pv.isAbstract()) continue;
            pv.setValue(ParametersMerger.processParametersReplacement(pv.getValue(), ret));
        }
        return ret;
    }

    public static Object processParametersReplacement(Object initialValue, HashMap<QName, ParameterValue> parameters) {
        if (initialValue instanceof String) {
            String ret = initialValue.toString();
            if (ret.contains("$[")) {
                for (ParameterValue pv : parameters.values()) {
                    if (pv.getValue() instanceof String) {
                        try {
                            ret = ret.replaceAll("\\$\\[" + pv.getKey() + "\\]", Matcher.quoteReplacement(pv.getValue().toString()));
                        }
                        catch (IllegalArgumentException ex) {
                            LOGGER.error("while replacing " + pv.getKey() + " -> " + pv.getValue(), (Throwable)ex);
                            throw ex;
                        }
                    }
                    if (ret.contains("$[")) continue;
                    break;
                }
            }
            return ret;
        }
        return initialValue;
    }

    public static String processParametersReplacement(String initialValue, HashMap<QName, ParameterValue> parameters) {
        String ret = initialValue;
        if (ret.contains("$[")) {
            for (ParameterValue pv : parameters.values()) {
                if (pv.getValue() instanceof String) {
                    try {
                        ret = ret.replaceAll("\\$\\[" + pv.getKey() + "\\]", Matcher.quoteReplacement(pv.getValue().toString()));
                    }
                    catch (IllegalArgumentException ex) {
                        LOGGER.error("while replacing " + pv.getKey() + " -> " + pv.getValue(), (Throwable)ex);
                        throw ex;
                    }
                } else if (pv.getValue() instanceof XdmAtomicValue) {
                    String replacer = Matcher.quoteReplacement(((XdmAtomicValue)pv.getValue()).toString());
                    ret = ret.replaceAll("\\$\\[" + pv.getKey() + "\\]", replacer);
                }
                if (ret.contains("$[")) continue;
                break;
            }
        }
        return ret;
    }

    public static HashMap<QName, ParameterValue> addInputInParameters(HashMap<QName, ParameterValue> parameters, File inputFile, DatatypeFactory factory) {
        HashMap<QName, ParameterValue> fileParams = new HashMap<QName, ParameterValue>();
        String name = inputFile.getName();
        String basename = name.substring(0, name.lastIndexOf("."));
        String extension = name.substring(basename.length() + 1);
        fileParams.put(INPUT_BASENAME, new ParameterValue(INPUT_BASENAME, basename, factory.XS_STRING));
        fileParams.put(INPUT_NAME, new ParameterValue(INPUT_NAME, name, factory.XS_STRING));
        fileParams.put(INPUT_EXTENSION, new ParameterValue(INPUT_EXTENSION, extension, factory.XS_STRING));
        fileParams.put(INPUT_ABSOLUTE, new ParameterValue(INPUT_ABSOLUTE, inputFile.getAbsolutePath(), factory.XS_STRING));
        return ParametersMerger.merge(parameters, fileParams);
    }
}

