/*
 * Decompiled with CFR 0.152.
 */
package fr.efl.chaine.xslt.config;

import fr.efl.chaine.xslt.InvalidSyntaxException;
import fr.efl.chaine.xslt.config.Verifiable;
import fr.efl.chaine.xslt.utils.ParameterValue;
import java.io.File;
import java.util.HashMap;
import net.sf.saxon.s9api.QName;

public class CfgFile
implements Verifiable {
    static final QName QNAME = new QName("http://efl.fr/chaine/saxon-pipe/config", "file");
    static final QName QN_FOLDER = new QName("http://efl.fr/chaine/saxon-pipe/config", "folder");
    static final QName ATTR_HREF = new QName("href");
    private final File source;
    private final HashMap<QName, ParameterValue> params;

    public CfgFile(File source) {
        this.source = source;
        this.params = new HashMap();
    }

    public void addParameter(ParameterValue param) {
        if (param == null) {
            return;
        }
        this.params.put(param.getKey(), param);
    }

    public File getSource() {
        return this.source;
    }

    public HashMap<QName, ParameterValue> getParams() {
        return this.params;
    }

    @Override
    public void verify() throws InvalidSyntaxException {
        if (!this.getSource().exists() || !this.getSource().isFile()) {
            throw new InvalidSyntaxException(this.getSource().getAbsolutePath() + " does no exists or is not a regular file.");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.source.getAbsolutePath());
        if (this.params.size() > 0) {
            sb.append("[");
            for (ParameterValue pv : this.params.values()) {
                sb.append("(").append(pv.getKey()).append(",").append(pv.getValue()).append("),");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append("]");
        }
        return sb.toString();
    }
}

