/*
 * Decompiled with CFR 0.152.
 */
package fr.efl.chaine.xslt.utils;

import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.XdmValue;
import top.marchand.xml.gaulois.config.typing.Datatype;

public class ParameterValue {
    private final QName key;
    private Object value;
    private Datatype datatype;
    private boolean abstractParam;

    public ParameterValue(QName key, Object value, Datatype datatype) {
        this.key = key;
        this.setValue(value);
        this.setDatatype(datatype);
    }

    public ParameterValue(QName key, Datatype datatype) {
        this.key = key;
        this.setDatatype(datatype);
        this.abstractParam = true;
    }

    public QName getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        if (value instanceof String) {
            this.value = value;
            this.abstractParam = false;
        } else if (value instanceof XdmValue) {
            this.value = value;
            this.abstractParam = false;
        } else if (value == null) {
            this.value = value;
            this.abstractParam = false;
        } else {
            throw new IllegalArgumentException("Only String or XdmValue are acceptable values for parameters");
        }
    }

    public String toString() {
        return "[" + this.getKey() + "=" + (this.abstractParam ? "<abstract>" : this.getValue()) + "]";
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public void setDatatype(Datatype datatype) {
        this.datatype = datatype;
    }

    public boolean isAbstract() {
        return this.abstractParam;
    }
}

