/*
 * Decompiled with CFR 0.152.
 */
package fr.efl.chaine.xslt.utils;

import fr.efl.chaine.xslt.GauloisPipe;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class GauloisPipeURIResolver
implements URIResolver {
    private final URIResolver defaultUriResolver;
    private static final Logger LOGGER = LoggerFactory.getLogger(GauloisPipeURIResolver.class);
    private static final String UNIX_DOUBLE_SLASH = "//";
    private static final String UNIX_SIMPLE_SLASH = "/";
    private static final String EMPTY_STRING = "";
    private static final String UNIX_FILE_PROTOCOL = "file:/";
    private static final String WINDOWS_FILE_PROTOCOL = "file:\\";
    private final Map<String, String> uriMapping;
    private final Map<Resolvee, File> alreadyResolved;

    public GauloisPipeURIResolver(URIResolver defaultUriResolver) {
        this(defaultUriResolver, Collections.EMPTY_MAP);
    }

    public GauloisPipeURIResolver(URIResolver defaultUriResolver, Map<String, String> uriMapping) {
        this.defaultUriResolver = defaultUriResolver;
        this.uriMapping = new HashMap<String, String>(uriMapping);
        this.alreadyResolved = new HashMap<Resolvee, File>();
    }

    @Override
    public Source resolve(String href, String base) throws TransformerException {
        Resolvee resolvee = new Resolvee(href, base);
        LOGGER.info("URIResolver on href=\"{}\" and base=\"{}\"", (Object)href, (Object)base);
        File ret = this.alreadyResolved.get(resolvee);
        if (ret != null) {
            try {
                StreamSource s = new StreamSource(new FileInputStream(ret));
                s.setSystemId(ret);
                LOGGER.debug("resolved from already served");
            }
            catch (FileNotFoundException s) {
                // empty catch block
            }
        }
        try {
            File file;
            URI hrefUri = new URI(href);
            LOGGER.info(href + " isAbsolute() ? " + hrefUri.isAbsolute());
            if (EMPTY_STRING.equals(href)) {
                return this.defaultUriResolver.resolve(href, base);
            }
            if (href.startsWith("cp:")) {
                InputStream is = GauloisPipe.class.getResourceAsStream(href.substring(3));
                StreamSource sr = new StreamSource(is);
                sr.setSystemId(href);
                return sr;
            }
            try {
                URI uri = new URI(href);
                file = new File(uri);
            }
            catch (IllegalArgumentException | NullPointerException | URISyntaxException e) {
                file = new File(href);
            }
            String filename = href.substring(href.lastIndexOf(47) + 1);
            if (this.uriMapping.containsKey(filename)) {
                LOGGER.debug("Target file {} from uriMapping {}", (Object)filename, (Object)this.uriMapping.get(filename));
                file = new File(this.uriMapping.get(filename));
            } else if (System.getProperty(filename) != null) {
                LOGGER.debug("Target file {} from property {}", (Object)filename, (Object)System.getProperty(filename));
                file = new File(System.getProperty(filename));
            } else {
                if (!file.exists()) {
                    String path;
                    if (base == null || base.isEmpty()) {
                        path = href;
                    } else {
                        File fBase;
                        File file2 = fBase = base.contains(":") ? new File(new URI(base)) : new File(base);
                        if (fBase.isFile()) {
                            fBase = fBase.getParentFile();
                        }
                        path = fBase.getAbsolutePath() + File.separator + href;
                    }
                    path = path.replace(UNIX_FILE_PROTOCOL, UNIX_SIMPLE_SLASH);
                    path = path.replace(WINDOWS_FILE_PROTOCOL, EMPTY_STRING);
                    LOGGER.debug("Try local file {}", (Object)path);
                    file = new File(path);
                }
                if (!file.exists()) {
                    LOGGER.debug("Not found");
                    LOGGER.debug("Try local file {} in {}", (Object)filename, (Object)System.getProperty("user.dir"));
                    File localFile = new File(filename);
                    if (localFile.exists()) {
                        file = localFile;
                    } else {
                        LOGGER.debug("Local file {} not found in {}", (Object)filename, (Object)System.getProperty("user.dir"));
                        LOGGER.debug("Try local file {} in {}", (Object)filename, (Object)System.getProperty("basedir"));
                        File basedirFile = new File(System.getProperty("basedir"), filename);
                        if (basedirFile.exists()) {
                            file = basedirFile;
                        } else {
                            LOGGER.debug("Local file {} not found in {}", (Object)filename, (Object)System.getProperty("basedir"));
                        }
                    }
                }
            }
            if (file.exists()) {
                LOGGER.debug("Resource found href=\"{}\" and base=\"{}\" is \"{}\"", (Object[])new String[]{href, base, file.getPath()});
                StreamSource s = new StreamSource(new FileInputStream(file));
                s.setSystemId(file);
                this.alreadyResolved.put(resolvee, file);
                return s;
            }
            LOGGER.warn("Resource not found href=\"{}\", base=\"{}\", filename=\"{}\"", (Object[])new String[]{href, base, filename});
            return null;
        }
        catch (FileNotFoundException | URISyntaxException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new TransformerException(e);
        }
    }

    public class Resolvee
    implements Serializable {
        private final String href;
        private final String base;

        public Resolvee(String href, String base) {
            this.href = href;
            this.base = base;
        }

        public int hashCode() {
            int hash = 5;
            hash = 61 * hash + Objects.hashCode(this.href);
            hash = 61 * hash + Objects.hashCode(this.base);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Resolvee other = (Resolvee)obj;
            if (!Objects.equals(this.href, other.href)) {
                return false;
            }
            return Objects.equals(this.base, other.base);
        }
    }
}

