/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.xml.maven.catalog;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import top.marchand.xml.maven.catalog.model.CatalogModel;
import top.marchand.xml.maven.catalog.model.RewriteSystemModel;

@Mojo(name="catalog", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class Catalog
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="catalog.xml")
    private String catalogFileName;
    @Parameter(defaultValue="artifactId:/")
    private String patternUrl;
    @Parameter
    private String rewriteToProtocol;
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;
    private DependencyNode rootNode;
    private static final transient String LOG_PREFIX = "[catalog] ";
    private static final transient String CATALOG_NS = "urn:oasis:names:tc:entity:xmlns:xml:catalog";
    private static final String[] ACCEPTABLE_JAR_WITH_DEPENDENCIES_CLASSIFIERS = new String[]{"jar-with-dependencies", "jar-with-dependencies-and-model"};

    public void execute() throws MojoExecutionException {
        if (this.rewriteToProtocol != null && !this.rewriteToProtocol.endsWith(":/")) {
            this.rewriteToProtocol = this.rewriteToProtocol.concat(":/");
        }
        if (!this.patternUrl.endsWith(":/")) {
            throw new MojoExecutionException("Illegal patternUrl value. patternUrl must end with :/");
        }
        try {
            final ArrayList<String> classpaths = new ArrayList<String>(this.project.getCompileClasspathElements().size());
            for (Object i : this.project.getCompileClasspathElements()) {
                classpaths.add(i.toString());
            }
            this.getLog().debug((CharSequence)("[catalog] classpaths=" + classpaths));
            try {
                this.rootNode = this.dependencyGraphBuilder.buildDependencyGraph(this.project, this.buildArtifactFilter());
                final CatalogModel catalog = new CatalogModel();
                DependencyNodeVisitor visitor = new DependencyNodeVisitor(){

                    public boolean visit(DependencyNode dn) {
                        Catalog.this.getLog().debug((CharSequence)("[catalog] Visiting " + dn.toNodeString()));
                        if (!dn.getArtifact().equals(Catalog.this.project.getArtifact())) {
                            Catalog.this.processDependency(dn, classpaths, catalog);
                        }
                        return true;
                    }

                    public boolean endVisit(DependencyNode dn) {
                        return true;
                    }
                };
                this.rootNode.accept(visitor);
                this.writeCatalog(catalog);
                this.getLog().debug((CharSequence)(LOG_PREFIX + catalog.toString()));
            }
            catch (IOException | XMLStreamException | DependencyGraphBuilderException ex) {
                this.getLog().error((CharSequence)(LOG_PREFIX + ex.getMessage()), ex);
            }
        }
        catch (DependencyResolutionRequiredException ex) {
            this.getLog().error((CharSequence)(LOG_PREFIX + ex.getMessage()), (Throwable)ex);
        }
    }

    private void processDependency(DependencyNode dn, List<String> classpaths, CatalogModel catalog) {
        String artifactId = dn.getArtifact().getArtifactId();
        String groupId = dn.getArtifact().getGroupId();
        String version = dn.getArtifact().getVersion();
        if (this.rewriteToProtocol != null && this.rewriteToProtocol.length() > 1) {
            RewriteSystemModel rsm = new RewriteSystemModel(this.buildPattern(groupId, artifactId, version), this.rewriteToProtocol);
            if (!catalog.containsUriStartPrefix(rsm.getUriStartPrefix())) {
                catalog.getEntries().add(rsm);
            }
        } else {
            try {
                String jarFileName = null;
                if (this.isInJarWithDependencies(dn)) {
                    this.getLog().debug((CharSequence)(LOG_PREFIX + artifactId + " is in a jar-with-dependencies"));
                    jarFileName = this.getJarFileForJarWithDependency(dn, classpaths);
                } else {
                    this.getLog().debug((CharSequence)(LOG_PREFIX + artifactId + " is in a jar"));
                    String artifactPath = this.constructArtifactPath(dn.getArtifact());
                    this.getLog().debug((CharSequence)("[catalog] artifactPath= " + artifactPath));
                    for (String s : classpaths) {
                        if (!s.contains(artifactPath)) continue;
                        jarFileName = s;
                    }
                }
                this.getLog().debug((CharSequence)(LOG_PREFIX + artifactId + " -> " + jarFileName));
                RewriteSystemModel rsm = new RewriteSystemModel(this.buildPattern(groupId, artifactId, version), "jar:file:" + jarFileName + "!/");
                if (!catalog.containsUriStartPrefix(rsm.getUriStartPrefix())) {
                    catalog.getEntries().add(rsm);
                }
            }
            catch (OverConstrainedVersionException ex) {
                this.getLog().error((CharSequence)(LOG_PREFIX + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    String buildPattern(String groupId, String artifactId, String version) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.patternUrl.length(); ++i) {
            String s = this.patternUrl.substring(i);
            if (s.startsWith("groupId")) {
                sb.append(groupId);
                i += "groupId".length() - 1;
                continue;
            }
            if (s.startsWith("artifactId")) {
                sb.append(artifactId);
                i += "artifactId".length() - 1;
                continue;
            }
            if (s.startsWith("version")) {
                sb.append(version);
                i += "version".length() - 1;
                continue;
            }
            sb.append(s.substring(0, 1));
        }
        return sb.toString();
    }

    private void writeCatalog(CatalogModel catalog) throws FileNotFoundException, XMLStreamException, IOException {
        XMLOutputFactory fact = XMLOutputFactory.newFactory();
        File catalogFile = new File(this.project.getBasedir(), this.catalogFileName);
        File directory = catalogFile.getParentFile();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(catalogFile);){
            XMLStreamWriter writer = fact.createXMLStreamWriter(fos, "UTF-8");
            writer = new IndentingXMLStreamWriter(writer);
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeDTD("<!DOCTYPE catalog PUBLIC \"-//OASIS//DTD Entity Resolution XML Catalog V1.0//EN\" \"http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd\">");
            writer.setDefaultNamespace(CATALOG_NS);
            writer.writeStartElement(CATALOG_NS, "catalog");
            writer.writeAttribute("xmlns", CATALOG_NS);
            for (RewriteSystemModel rsm : catalog.getEntries()) {
                writer.writeStartElement(CATALOG_NS, "rewriteURI");
                writer.writeAttribute("uriStartString", rsm.getUriStartPrefix());
                writer.writeAttribute("rewritePrefix", rsm.getRewritePrefix());
                writer.writeEndElement();
                writer.writeStartElement(CATALOG_NS, "rewriteSystem");
                writer.writeAttribute("systemIdStartString", rsm.getUriStartPrefix());
                writer.writeAttribute("rewritePrefix", rsm.getRewritePrefix());
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            fos.flush();
        }
    }

    private ArtifactFilter buildArtifactFilter() {
        return new ArtifactFilter(){

            public boolean include(Artifact artfct) {
                return true;
            }
        };
    }

    private boolean isInJarWithDependencies(DependencyNode dn) {
        this.getLog().debug((CharSequence)("[catalog]  looking for parentry of " + dn.getArtifact().toString()));
        String classifier = dn.getArtifact().getClassifier();
        this.getLog().debug((CharSequence)("[catalog] classifier=" + classifier));
        if (classifier != null && Arrays.binarySearch(ACCEPTABLE_JAR_WITH_DEPENDENCIES_CLASSIFIERS, classifier) >= 0) {
            this.getLog().debug((CharSequence)"[catalog]  return true");
            return true;
        }
        if (dn.getParent() == null) {
            this.getLog().debug((CharSequence)"[catalog] no parent, return false");
            return false;
        }
        return this.isInJarWithDependencies(dn.getParent());
    }

    private String getJarFileForJarWithDependency(DependencyNode dn, List<String> classpthElements) throws OverConstrainedVersionException {
        if (dn == null) {
            return null;
        }
        String lastFound = null;
        block0: for (DependencyNode currentDn = dn; currentDn != null; currentDn = currentDn.getParent()) {
            String classifier = currentDn.getArtifact().getClassifier();
            if (classifier != null && Arrays.binarySearch(ACCEPTABLE_JAR_WITH_DEPENDENCIES_CLASSIFIERS, classifier) < 0) continue;
            String artifactPath = this.constructArtifactPath(currentDn.getArtifact());
            for (String s : classpthElements) {
                if (!s.contains(artifactPath)) continue;
                lastFound = s;
                continue block0;
            }
        }
        return lastFound;
    }

    private String constructArtifactPath(Artifact art) throws OverConstrainedVersionException {
        Object[] groups = art.getGroupId().split("\\.");
        this.getLog().debug((CharSequence)("[catalog] groups=" + Arrays.toString(groups)));
        Object[] artifacts = art.getArtifactId().split("\\.");
        this.getLog().debug((CharSequence)("[catalog] artifacts=" + Arrays.toString(artifacts)));
        Object[] elements = new String[groups.length + artifacts.length + 1];
        System.arraycopy(groups, 0, elements, 0, groups.length);
        System.arraycopy(artifacts, 0, elements, groups.length, artifacts.length);
        this.getLog().debug((CharSequence)("[catalog] artifact.baseVersion=" + art.getBaseVersion()));
        elements[elements.length - 1] = art.getBaseVersion();
        return Joiner.on((String)File.separator).skipNulls().join(elements);
    }

    void setPatternUrl(String patternUrl) {
        this.patternUrl = patternUrl;
    }
}

