/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.xml.maven.catalog;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import top.marchand.xml.maven.catalog.model.CatalogModel;
import top.marchand.xml.maven.catalog.model.RewriteSystemModel;

@Mojo(name="catalog", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class Catalog
extends AbstractMojo {
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="catalog.xml")
    private String catalogFileName;
    @Parameter(defaultValue="artifactId:/")
    private String patternUrl;
    @Parameter
    private String rewriteToProtocol;
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;
    private DependencyNode rootNode;
    private HashMap<File, MyArtifact> dependencyDirs;
    private DocumentBuilder builder;
    private XPathCompiler compiler;
    private static final transient String LOG_PREFIX = "[catalog] ";
    private static final transient String CATALOG_NS = "urn:oasis:names:tc:entity:xmlns:xml:catalog";
    private static final String[] ACCEPTABLE_JAR_WITH_DEPENDENCIES_CLASSIFIERS = new String[]{"jar-with-dependencies", "jar-with-dependencies-and-model"};

    public void execute() throws MojoExecutionException {
        this.dependencyDirs = new HashMap();
        Processor proc = new Processor(Configuration.newConfiguration());
        this.builder = proc.newDocumentBuilder();
        this.compiler = proc.newXPathCompiler();
        if (this.rewriteToProtocol != null && !this.rewriteToProtocol.endsWith(":/")) {
            this.rewriteToProtocol = this.rewriteToProtocol.concat(":/");
        }
        if (!this.patternUrl.endsWith(":/")) {
            throw new MojoExecutionException("Illegal patternUrl value. patternUrl must end with :/");
        }
        try {
            final ArrayList<String> classpaths = new ArrayList<String>(this.project.getCompileClasspathElements().size());
            for (Object i : this.project.getCompileClasspathElements()) {
                classpaths.add(i.toString());
            }
            this.getLog().debug((CharSequence)("[catalog] classpaths=" + classpaths));
            try {
                this.rootNode = this.dependencyGraphBuilder.buildDependencyGraph(this.project, this.buildArtifactFilter());
                final CatalogModel catalog = new CatalogModel();
                DependencyNodeVisitor visitor = new DependencyNodeVisitor(){

                    public boolean visit(DependencyNode dn) {
                        Catalog.this.getLog().debug((CharSequence)("[catalog] Visiting " + dn.toNodeString()));
                        if (!dn.getArtifact().equals(Catalog.this.project.getArtifact())) {
                            Catalog.this.processDependency(dn, classpaths, catalog);
                        }
                        return true;
                    }

                    public boolean endVisit(DependencyNode dn) {
                        return true;
                    }
                };
                this.rootNode.accept(visitor);
                this.writeCatalog(catalog);
                this.getLog().debug((CharSequence)(LOG_PREFIX + catalog.toString()));
            }
            catch (IOException | XMLStreamException | DependencyGraphBuilderException ex) {
                this.getLog().error((CharSequence)(LOG_PREFIX + ex.getMessage()), ex);
            }
        }
        catch (DependencyResolutionRequiredException ex) {
            this.getLog().error((CharSequence)(LOG_PREFIX + ex.getMessage()), (Throwable)ex);
        }
    }

    private void processDependency(DependencyNode dn, List<String> classpaths, CatalogModel catalog) {
        String artifactId = dn.getArtifact().getArtifactId();
        String groupId = dn.getArtifact().getGroupId();
        String version = dn.getArtifact().getVersion();
        if (this.rewriteToProtocol != null && this.rewriteToProtocol.length() > 1) {
            RewriteSystemModel rsm = new RewriteSystemModel(this.buildPattern(groupId, artifactId, version), this.rewriteToProtocol);
            if (!catalog.containsUriStartPrefix(rsm.getUriStartPrefix())) {
                catalog.getEntries().add(rsm);
            }
        } else {
            try {
                String jarFileName = null;
                if (this.isInJarWithDependencies(dn)) {
                    this.getLog().debug((CharSequence)(LOG_PREFIX + artifactId + " is in a jar-with-dependencies"));
                    jarFileName = this.getJarFileForJarWithDependency(dn, classpaths);
                } else {
                    this.getLog().debug((CharSequence)(LOG_PREFIX + artifactId + " is in a jar"));
                    String artifactPath = this.constructArtifactPath(dn.getArtifact());
                    this.getLog().debug((CharSequence)("[catalog] artifactPath= " + artifactPath));
                    for (String s : classpaths) {
                        if (s.contains(artifactPath)) {
                            jarFileName = s;
                            continue;
                        }
                        if (!s.endsWith("target/classes") && !s.matches(".*[/\\\\]target[/\\\\][^/\\\\]+\\.jar")) continue;
                        this.getLog().debug((CharSequence)("found classpath : " + s));
                        File dir = new File(s).getParentFile().getParentFile();
                        if (this.isPathMatchesDependency(dir, groupId, artifactId, version)) {
                            jarFileName = s;
                            continue;
                        }
                        this.getLog().debug((CharSequence)(LOG_PREFIX + s + " does not match (" + dir.getAbsolutePath() + "," + groupId + "," + artifactId + "," + version + ")"));
                        this.getLog().debug((CharSequence)(LOG_PREFIX + artifactId + ":/ won't be bind to a classpath element"));
                    }
                }
                this.getLog().debug((CharSequence)(LOG_PREFIX + artifactId + " -> " + jarFileName));
                if (jarFileName != null) {
                    RewriteSystemModel rsm;
                    RewriteSystemModel rewriteSystemModel = rsm = jarFileName.endsWith(".jar") ? new RewriteSystemModel(this.buildPattern(groupId, artifactId, version), "jar:file:" + jarFileName + "!/") : new RewriteSystemModel(this.buildPattern(groupId, artifactId, version), new File(jarFileName).toURI().toString());
                    if (!catalog.containsUriStartPrefix(rsm.getUriStartPrefix())) {
                        catalog.getEntries().add(rsm);
                    }
                }
            }
            catch (OverConstrainedVersionException ex) {
                this.getLog().error((CharSequence)(LOG_PREFIX + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    boolean isPathMatchesDependency(File dir, String groupId, String artifactId, String version) {
        MyArtifact art = this.dependencyDirs.get(dir);
        if (art == null) {
            art = this.loadArtifactFromDir(dir);
            if (art != null) {
                this.dependencyDirs.put(dir, art);
                return groupId.equals(art.getGroupId()) && artifactId.equals(art.getArtifactId()) && version.equals(art.getVersion());
            }
            return false;
        }
        return groupId.equals(art.getGroupId()) && artifactId.equals(art.getArtifactId()) && version.equals(art.getVersion());
    }

    MyArtifact loadArtifactFromDir(File dir) {
        try {
            XdmNode pom = this.builder.build(new File(dir, "pom.xml"));
            this.compiler.declareNamespace("mvn", "http://maven.apache.org/POM/4.0.0");
            XPathSelector selector = this.compiler.compile("/mvn:project/(mvn:groupId | mvn:artifactId | mvn:version)").load();
            selector.setContextItem((XdmItem)pom);
            XdmValue ret = selector.evaluate();
            String groupId = null;
            String artifactId = null;
            String version = null;
            for (XdmNode node : ret) {
                switch (node.getNodeName().getLocalName()) {
                    case "groupId": {
                        groupId = node.getStringValue();
                        break;
                    }
                    case "artifactId": {
                        artifactId = node.getStringValue();
                        break;
                    }
                    case "version": {
                        version = node.getStringValue();
                    }
                }
            }
            if (version == null || groupId == null) {
                File parentPomFile;
                String relativePath = "../pom.xml";
                XPathSelector selector2 = this.compiler.compile("/mvn:project/mvn:parent/mvn:relativePath").load();
                selector2.setContextItem((XdmItem)pom);
                XdmValue vRelativePath = selector2.evaluate();
                if (vRelativePath.size() > 0) {
                    this.getLog().debug((CharSequence)("vRelativePath is a " + vRelativePath.getClass().getName()));
                    this.getLog().debug((CharSequence)("vRelativePath is " + vRelativePath.size() + " long"));
                    this.getLog().debug((CharSequence)("vRelativePath: " + vRelativePath.toString()));
                    relativePath = ((XdmNode)vRelativePath).getStringValue();
                }
                if ((parentPomFile = new File(dir, relativePath)).isDirectory()) {
                    parentPomFile = new File(parentPomFile, "pom.xml");
                }
                if (version == null) {
                    XPathSelector versionSelector = this.compiler.compile("/mvn:project/mvn:version").load();
                    versionSelector.setContextItem((XdmItem)this.builder.build(parentPomFile));
                    version = ((XdmNode)versionSelector.evaluate()).getStringValue();
                }
                if (groupId == null) {
                    XPathSelector groupIdSelector = this.compiler.compile("/mvn:project/mvn:groupId").load();
                    groupIdSelector.setContextItem((XdmItem)this.builder.build(parentPomFile));
                    groupId = ((XdmNode)groupIdSelector.evaluate()).getStringValue();
                }
            }
            MyArtifact art = new MyArtifact(groupId, artifactId, version);
            this.getLog().debug((CharSequence)art.toString());
            return art;
        }
        catch (SaxonApiException ex) {
            this.getLog().error((CharSequence)"in loadArtifactFromDir", (Throwable)ex);
            return null;
        }
    }

    String buildPattern(String groupId, String artifactId, String version) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.patternUrl.length(); ++i) {
            String s = this.patternUrl.substring(i);
            if (s.startsWith("groupId")) {
                sb.append(groupId);
                i += "groupId".length() - 1;
                continue;
            }
            if (s.startsWith("artifactId")) {
                sb.append(artifactId);
                i += "artifactId".length() - 1;
                continue;
            }
            if (s.startsWith("version")) {
                sb.append(version);
                i += "version".length() - 1;
                continue;
            }
            sb.append(s.substring(0, 1));
        }
        return sb.toString();
    }

    private void writeCatalog(CatalogModel catalog) throws FileNotFoundException, XMLStreamException, IOException {
        XMLOutputFactory fact = XMLOutputFactory.newFactory();
        File catalogFile = new File(this.project.getBasedir(), this.catalogFileName);
        File directory = catalogFile.getParentFile();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(catalogFile);){
            XMLStreamWriter writer = fact.createXMLStreamWriter(fos, "UTF-8");
            writer = new IndentingXMLStreamWriter(writer);
            writer.writeStartDocument("UTF-8", "1.0");
            writer.writeDTD("<!DOCTYPE catalog PUBLIC \"-//OASIS//DTD Entity Resolution XML Catalog V1.0//EN\" \"http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd\">");
            writer.setDefaultNamespace(CATALOG_NS);
            writer.writeStartElement(CATALOG_NS, "catalog");
            writer.writeAttribute("xmlns", CATALOG_NS);
            for (RewriteSystemModel rsm : catalog.getEntries()) {
                writer.writeStartElement(CATALOG_NS, "rewriteURI");
                writer.writeAttribute("uriStartString", rsm.getUriStartPrefix());
                writer.writeAttribute("rewritePrefix", rsm.getRewritePrefix());
                writer.writeEndElement();
                writer.writeStartElement(CATALOG_NS, "rewriteSystem");
                writer.writeAttribute("systemIdStartString", rsm.getUriStartPrefix());
                writer.writeAttribute("rewritePrefix", rsm.getRewritePrefix());
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            fos.flush();
        }
    }

    private ArtifactFilter buildArtifactFilter() {
        return new ArtifactFilter(){

            public boolean include(Artifact artfct) {
                return true;
            }
        };
    }

    private boolean isInJarWithDependencies(DependencyNode dn) {
        this.getLog().debug((CharSequence)("[catalog]  looking for parentry of " + dn.getArtifact().toString()));
        String classifier = dn.getArtifact().getClassifier();
        this.getLog().debug((CharSequence)("[catalog] classifier=" + classifier));
        if (classifier != null && Arrays.binarySearch(ACCEPTABLE_JAR_WITH_DEPENDENCIES_CLASSIFIERS, classifier) >= 0) {
            this.getLog().debug((CharSequence)"[catalog]  return true");
            return true;
        }
        if (dn.getParent() == null) {
            this.getLog().debug((CharSequence)"[catalog] no parent, return false");
            return false;
        }
        return this.isInJarWithDependencies(dn.getParent());
    }

    private String getJarFileForJarWithDependency(DependencyNode dn, List<String> classpthElements) throws OverConstrainedVersionException {
        if (dn == null) {
            return null;
        }
        String lastFound = null;
        block0: for (DependencyNode currentDn = dn; currentDn != null; currentDn = currentDn.getParent()) {
            String classifier = currentDn.getArtifact().getClassifier();
            if (classifier != null && Arrays.binarySearch(ACCEPTABLE_JAR_WITH_DEPENDENCIES_CLASSIFIERS, classifier) < 0) continue;
            String artifactPath = this.constructArtifactPath(currentDn.getArtifact());
            for (String s : classpthElements) {
                if (!s.contains(artifactPath)) continue;
                lastFound = s;
                continue block0;
            }
        }
        return lastFound;
    }

    private String constructArtifactPath(Artifact art) throws OverConstrainedVersionException {
        Object[] groups = art.getGroupId().split("\\.");
        this.getLog().debug((CharSequence)("[catalog] groups=" + Arrays.toString(groups)));
        Object[] artifacts = art.getArtifactId().split("\\.");
        this.getLog().debug((CharSequence)("[catalog] artifacts=" + Arrays.toString(artifacts)));
        Object[] elements = new String[groups.length + artifacts.length + 1];
        System.arraycopy(groups, 0, elements, 0, groups.length);
        System.arraycopy(artifacts, 0, elements, groups.length, artifacts.length);
        this.getLog().debug((CharSequence)("[catalog] artifact.baseVersion=" + art.getBaseVersion()));
        elements[elements.length - 1] = art.getBaseVersion();
        return Joiner.on((String)File.separator).skipNulls().join(elements);
    }

    void setPatternUrl(String patternUrl) {
        this.patternUrl = patternUrl;
    }

    private class MyArtifact {
        private final String groupId;
        private final String artifactId;
        private final String version;

        public MyArtifact(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return String.format("artifact[%s,%s,%s]", this.groupId, this.artifactId, this.version);
        }
    }
}

