/*
 * Decompiled with CFR 0.152.
 */
package top.marchand.xml.maven.catalog;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javanet.staxutils.IndentingXMLStreamWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltTransformer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import top.marchand.xml.maven.catalog.ChmLogger;
import top.marchand.xml.maven.catalog.DelegateEntry;
import top.marchand.xml.maven.catalog.model.CatalogModel;
import top.marchand.xml.maven.catalog.model.RewriteSystemModel;

@Mojo(name="catalog", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE)
public class Catalog
extends AbstractMojo {
    public static final transient String SCHEME = "dependency:/";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    public MavenProject project;
    @Parameter(defaultValue="catalog.xml")
    public String catalogFileName;
    @Parameter
    public List<String> uriPatterns = new ArrayList<String>();
    @Parameter
    public List<String> generates;
    @Parameter
    private String rewriteToProtocol;
    @Parameter
    public boolean includeCurrentArtifact;
    @Parameter
    public List<String> nextCatalogs;
    @Parameter
    public List<String> excludes;
    @Parameter
    public List<String> includes;
    @Parameter
    public List<DelegateEntry> delegatesPublic;
    @Parameter
    public List<DelegateEntry> delegatesSystem;
    @Parameter
    public List<DelegateEntry> delegatesURI;
    @Parameter(defaultValue="true")
    public boolean removeDoctype;
    @Parameter(defaultValue="false")
    public boolean generateOxygenCatalog;
    @Component(hint="default")
    private DependencyGraphBuilder dependencyGraphBuilder;
    @Parameter
    private ChmLogger.LogReason[] logReasons;
    private DependencyNode rootNode;
    private ChmLogger chmLogger;
    private HashMap<File, MyArtifact> dependencyDirs;
    private Processor proc;
    private DocumentBuilder builder;
    private XPathCompiler xpathCompiler;
    private static final transient String LOG_PREFIX = "[catalog] ";
    private static final transient String CATALOG_NS = "urn:oasis:names:tc:entity:xmlns:xml:catalog";
    private static final String[] ACCEPTABLE_JAR_WITH_DEPENDENCIES_CLASSIFIERS = new String[]{"jar-with-dependencies", "jar-with-dependencies-and-model"};
    public static final transient String[] ALLOWED_URI_PATTERNS = new String[]{"compact", "full", "standard"};
    public static final transient String[] ALLOWED_REWRITES = new String[]{"public", "rewriteSystem", "rewriteURI", "system", "uri"};

    public Catalog() {
        this.uriPatterns.add("standard");
        this.generates = new ArrayList<String>();
        this.generates.add("rewriteURI");
        this.generates.add("rewriteSystem");
    }

    public void execute() throws MojoExecutionException {
        this.dependencyDirs = new HashMap();
        this.proc = new Processor(Configuration.newConfiguration());
        this.builder = this.proc.newDocumentBuilder();
        this.xpathCompiler = this.proc.newXPathCompiler();
        this.chmLogger = new ChmLogger(this.getLog());
        for (ChmLogger.LogReason reason : this.logReasons) {
            this.chmLogger.enableReason(reason, true);
        }
        this.chmLogger.log(ChmLogger.LogReason.PARAMETERS, ChmLogger.LogLevel.INFO, "catalogFile: " + this.catalogFileName);
        try {
            final ArrayList<String> classpaths = new ArrayList<String>(this.project.getCompileClasspathElements().size());
            for (Object i : this.project.getCompileClasspathElements()) {
                classpaths.add(i.toString());
            }
            this.chmLogger.log(ChmLogger.LogReason.CLASSPATH, ChmLogger.LogLevel.INFO, "[catalog] classpaths=" + classpaths);
            try {
                this.rootNode = this.dependencyGraphBuilder.buildDependencyGraph(this.project, this.buildArtifactFilter());
                final CatalogModel catalog = new CatalogModel();
                DependencyNodeVisitor visitor = new DependencyNodeVisitor(){

                    public boolean visit(DependencyNode dn) {
                        Catalog.this.chmLogger.log(ChmLogger.LogReason.VISITING, ChmLogger.LogLevel.INFO, "[catalog] Visiting " + dn.toNodeString());
                        if (Catalog.this.shouldProcessDependency(dn)) {
                            Catalog.this.processDependency(dn, classpaths, catalog);
                        }
                        return true;
                    }

                    public boolean endVisit(DependencyNode dn) {
                        return true;
                    }
                };
                this.rootNode.accept(visitor);
                this.writeCatalog(catalog);
                this.getLog().debug((CharSequence)(LOG_PREFIX + catalog.toString()));
                if (this.generateOxygenCatalog) {
                    this.writeOxygenCatalog();
                }
            }
            catch (IOException | XMLStreamException | SaxonApiException | DependencyGraphBuilderException ex) {
                this.getLog().error((CharSequence)(LOG_PREFIX + ex.getMessage()), ex);
                throw new MojoExecutionException(ex.getMessage(), (Exception)ex);
            }
        }
        catch (DependencyResolutionRequiredException ex) {
            this.getLog().error((CharSequence)(LOG_PREFIX + ex.getMessage()), (Throwable)ex);
        }
    }

    protected boolean shouldProcessDependency(DependencyNode dn) {
        Artifact artifact = dn.getArtifact();
        if (artifact.equals(this.project.getArtifact())) {
            this.chmLogger.log(ChmLogger.LogReason.EXCLUSION, ChmLogger.LogLevel.INFO, "Current artifact is " + (this.includeCurrentArtifact ? "" : "not ") + "excluded");
            return this.includeCurrentArtifact;
        }
        String groupId = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        String[] patterns = new String[]{groupId + ":" + artifactId, "*:" + artifactId, groupId + ":*"};
        if ((this.includes == null || this.includes.isEmpty()) && (this.excludes == null || this.excludes.isEmpty())) {
            return true;
        }
        if (this.includes != null && !this.includes.isEmpty()) {
            for (String pattern : patterns) {
                if (!this.includes.contains(pattern)) continue;
                return true;
            }
            this.chmLogger.log(ChmLogger.LogReason.EXCLUSION, ChmLogger.LogLevel.INFO, "Excluding " + artifact.toString() + " because includes is not empty and no pattern matches it");
            return false;
        }
        for (String pattern : patterns) {
            if (!this.excludes.contains(pattern)) continue;
            this.chmLogger.log(ChmLogger.LogReason.EXCLUSION, ChmLogger.LogLevel.INFO, "excluding " + artifact.toString() + " because it is excluded by " + pattern);
            return false;
        }
        return true;
    }

    private void processDependency(DependencyNode dn, List<String> classpaths, CatalogModel catalog) {
        String groupId = dn.getArtifact().getGroupId();
        String artifactId = dn.getArtifact().getArtifactId();
        String version = dn.getArtifact().getVersion();
        this.chmLogger.log(ChmLogger.LogReason.DEPENDENCY, ChmLogger.LogLevel.INFO, String.format("Processing dependency [%s:%s:%s]", groupId, artifactId, version));
        if (this.rewriteToProtocol != null && this.rewriteToProtocol.length() > 1) {
            for (String pattern : this.uriPatterns) {
                RewriteSystemModel rsm = new RewriteSystemModel(this.buildPattern(pattern, groupId, artifactId, version), this.rewriteToProtocol, groupId, artifactId, version);
                catalog.getEntries().add(rsm);
            }
        } else {
            try {
                String jarFileName = null;
                if (this.isInJarWithDependencies(dn)) {
                    this.getLog().debug((CharSequence)(LOG_PREFIX + artifactId + " is in a jar-with-dependencies"));
                    jarFileName = this.getJarFileForJarWithDependency(dn, classpaths);
                } else {
                    this.getLog().debug((CharSequence)(LOG_PREFIX + artifactId + " is in a jar"));
                    String artifactPath = this.constructArtifactPath(dn.getArtifact());
                    this.getLog().debug((CharSequence)("[catalog] artifactPath= " + artifactPath));
                    for (String classpath : classpaths) {
                        this.chmLogger.log(ChmLogger.LogReason.DEPENDENCY, ChmLogger.LogLevel.INFO, "\t comparing to classpath " + classpath);
                        if (classpath.contains(artifactPath)) {
                            this.chmLogger.log(ChmLogger.LogReason.DEPENDENCY, ChmLogger.LogLevel.INFO, "\t\t" + classpath + " contains " + artifactPath);
                            jarFileName = classpath;
                            continue;
                        }
                        if (!classpath.endsWith("target/classes") && !classpath.matches(".*[/\\\\]target[/\\\\][^/\\\\]+\\.jar")) continue;
                        this.getLog().debug((CharSequence)("found classpath : " + classpath));
                        File dir = new File(classpath).getParentFile().getParentFile();
                        if (!this.isPathMatchesDependency(dir, groupId, artifactId, version)) continue;
                        this.chmLogger.log(ChmLogger.LogReason.DEPENDENCY, ChmLogger.LogLevel.INFO, "\t\t" + dir.getAbsolutePath() + " matches artifact");
                        jarFileName = classpath;
                    }
                }
                this.getLog().debug((CharSequence)(LOG_PREFIX + artifactId + " -> " + jarFileName));
                if (jarFileName != null) {
                    for (String pattern : this.uriPatterns) {
                        RewriteSystemModel rsm = jarFileName.endsWith(".jar") ? new RewriteSystemModel(this.buildPattern(pattern, groupId, artifactId, version), "jar:file:" + jarFileName + "!/", groupId, artifactId, version) : new RewriteSystemModel(this.buildPattern(pattern, groupId, artifactId, version), new File(jarFileName).toURI().toString(), groupId, artifactId, version);
                        catalog.getEntries().add(rsm);
                    }
                }
                this.chmLogger.log(ChmLogger.LogReason.EXCLUSION, ChmLogger.LogLevel.INFO, "\t\tNo classpath found for artifact");
            }
            catch (OverConstrainedVersionException ex) {
                this.getLog().error((CharSequence)(LOG_PREFIX + ex.getMessage()), (Throwable)ex);
            }
        }
    }

    protected String buildPattern(String pattern, String groupId, String artifactId, String version) {
        StringBuilder sb = new StringBuilder(SCHEME);
        if ("full".equals(pattern) || "standard".equals(pattern)) {
            sb.append(groupId).append("+");
        }
        sb.append(artifactId);
        if ("full".equals(pattern)) {
            sb.append("$").append(version);
        }
        sb.append("/");
        return sb.toString();
    }

    boolean isPathMatchesDependency(File dir, String groupId, String artifactId, String version) {
        MyArtifact art = this.dependencyDirs.get(dir);
        if (art == null) {
            art = this.loadArtifactFromDir(dir);
        }
        if (art != null) {
            boolean ret;
            this.chmLogger.log(ChmLogger.LogReason.DEPENDENCY, ChmLogger.LogLevel.INFO, "\t\t\tart is " + art);
            this.dependencyDirs.put(dir, art);
            boolean bl = ret = groupId.equals(art.getGroupId()) && artifactId.equals(art.getArtifactId()) && version.equals(art.getVersion());
            if (!ret) {
                this.chmLogger.log(ChmLogger.LogReason.MATCHES, ChmLogger.LogLevel.INFO, art.toString() + " does not match " + groupId + ":" + artifactId + ":" + version);
            }
            return ret;
        }
        this.chmLogger.log(ChmLogger.LogReason.MATCHES, ChmLogger.LogLevel.INFO, "no artifact found in dir " + dir.getAbsolutePath());
        return false;
    }

    MyArtifact loadArtifactFromDir(File dir) {
        try {
            XdmNode pom = this.builder.build(new File(dir, "pom.xml"));
            this.xpathCompiler.declareNamespace("mvn", "http://maven.apache.org/POM/4.0.0");
            XPathSelector selector = this.xpathCompiler.compile("/mvn:project/(mvn:groupId | mvn:artifactId | mvn:version)").load();
            selector.setContextItem((XdmItem)pom);
            XdmValue ret = selector.evaluate();
            String groupId = null;
            String artifactId = null;
            String version = null;
            for (XdmNode node : ret) {
                switch (node.getNodeName().getLocalName()) {
                    case "groupId": {
                        groupId = node.getStringValue();
                        break;
                    }
                    case "artifactId": {
                        artifactId = node.getStringValue();
                        break;
                    }
                    case "version": {
                        version = node.getStringValue();
                    }
                }
            }
            if (version == null || groupId == null) {
                File parentPomFile;
                String relativePath = "../pom.xml";
                XPathSelector selector2 = this.xpathCompiler.compile("/mvn:project/mvn:parent/mvn:relativePath").load();
                selector2.setContextItem((XdmItem)pom);
                XdmValue vRelativePath = selector2.evaluate();
                if (vRelativePath.size() > 0) {
                    this.getLog().debug((CharSequence)("vRelativePath is a " + vRelativePath.getClass().getName()));
                    this.getLog().debug((CharSequence)("vRelativePath is " + vRelativePath.size() + " long"));
                    this.getLog().debug((CharSequence)("vRelativePath: " + vRelativePath.toString()));
                    relativePath = ((XdmNode)vRelativePath).getStringValue();
                }
                if ((parentPomFile = new File(dir, relativePath)).isDirectory()) {
                    parentPomFile = new File(parentPomFile, "pom.xml");
                }
                if (version == null) {
                    XPathSelector versionSelector = this.xpathCompiler.compile("/mvn:project/mvn:version").load();
                    versionSelector.setContextItem((XdmItem)this.builder.build(parentPomFile));
                    version = ((XdmNode)versionSelector.evaluate()).getStringValue();
                }
                if (groupId == null) {
                    XPathSelector groupIdSelector = this.xpathCompiler.compile("/mvn:project/mvn:groupId").load();
                    groupIdSelector.setContextItem((XdmItem)this.builder.build(parentPomFile));
                    groupId = ((XdmNode)groupIdSelector.evaluate()).getStringValue();
                }
            }
            MyArtifact art = new MyArtifact(groupId, artifactId, version);
            this.getLog().debug((CharSequence)art.toString());
            return art;
        }
        catch (SaxonApiException ex) {
            this.getLog().error((CharSequence)"in loadArtifactFromDir", (Throwable)ex);
            return null;
        }
    }

    private void writeOxygenCatalog() throws SaxonApiException {
        File sourceFile = new File(this.project.getBasedir(), this.catalogFileName);
        String oxygenCatalogFileName = sourceFile.getName();
        int lastIndex = oxygenCatalogFileName.lastIndexOf(".");
        oxygenCatalogFileName = oxygenCatalogFileName.substring(0, lastIndex) + "-oxygen" + oxygenCatalogFileName.substring(lastIndex);
        File targetFile = new File(sourceFile.getParentFile(), oxygenCatalogFileName);
        StreamSource source = new StreamSource(((Object)((Object)this)).getClass().getResourceAsStream("/top/marchand/xml/maven/catalog/xsl/oxygen-catalog-converter.xsl"));
        XsltTransformer tr = this.proc.newXsltCompiler().compile((Source)source).load();
        tr.setSource((Source)new StreamSource(sourceFile));
        Serializer dest = this.proc.newSerializer(targetFile);
        dest.setOutputProperty(Serializer.Property.INDENT, "true");
        tr.setDestination((Destination)dest);
        tr.transform();
    }

    private void writeCatalog(CatalogModel catalog) throws FileNotFoundException, XMLStreamException, IOException, MojoExecutionException {
        XMLOutputFactory fact = XMLOutputFactory.newFactory();
        File catalogFile = new File(this.project.getBasedir(), this.catalogFileName);
        File directory = catalogFile.getParentFile();
        if (!directory.exists()) {
            directory.mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(catalogFile);){
            XMLStreamWriter writer = fact.createXMLStreamWriter(fos, "UTF-8");
            writer = new IndentingXMLStreamWriter(writer);
            writer.writeStartDocument("UTF-8", "1.0");
            if (!this.removeDoctype) {
                writer.writeDTD("<!DOCTYPE catalog PUBLIC \"-//OASIS//DTD Entity Resolution XML Catalog V1.0//EN\" \"http://www.oasis-open.org/committees/entity/release/1.0/catalog.dtd\">");
            }
            writer.setDefaultNamespace(CATALOG_NS);
            writer.writeStartElement(CATALOG_NS, "catalog");
            writer.writeAttribute("xmlns", CATALOG_NS);
            for (RewriteSystemModel rsm : catalog.getEntries()) {
                for (String generate : this.generates) {
                    this.writeCatalogEntry(writer, generate, rsm);
                }
            }
            if (this.delegatesPublic != null) {
                for (DelegateEntry de : this.delegatesPublic) {
                    this.writeDelegateEntry(writer, "delegatePublic", de);
                }
            }
            if (this.delegatesSystem != null) {
                for (DelegateEntry de : this.delegatesSystem) {
                    this.writeDelegateEntry(writer, "delegateSystem", de);
                }
            }
            if (this.delegatesURI != null) {
                for (DelegateEntry de : this.delegatesURI) {
                    this.writeDelegateEntry(writer, "delegateURI", de);
                }
            }
            if (this.nextCatalogs != null) {
                for (String nextCatalog : this.nextCatalogs) {
                    writer.writeEmptyElement(CATALOG_NS, "nextCatalog");
                    writer.writeAttribute("catalog", nextCatalog);
                }
            }
            writer.writeEndElement();
            writer.writeEndDocument();
            fos.flush();
        }
    }

    protected void writeDelegateEntry(XMLStreamWriter writer, String delegate, DelegateEntry entry) throws XMLStreamException, MojoExecutionException {
        switch (delegate) {
            case "delegatePublic": {
                writer.writeEmptyElement(CATALOG_NS, "delegatePublic");
                writer.writeAttribute("publicIdStartString", entry.getStartString());
                writer.writeAttribute("catalog", entry.getCatalog());
                break;
            }
            case "delegateSystem": {
                writer.writeEmptyElement(CATALOG_NS, "delegateSystem");
                writer.writeAttribute("systemIdStartString", entry.getStartString());
                writer.writeAttribute("catalog", entry.getCatalog());
                break;
            }
            case "delegateURI": {
                writer.writeEmptyElement(CATALOG_NS, "delegateURI");
                writer.writeAttribute("uriStartString", entry.getStartString());
                writer.writeAttribute("catalog", entry.getCatalog());
                break;
            }
            default: {
                throw new MojoExecutionException("Illegal value for generate: " + delegate);
            }
        }
    }

    protected void writeCatalogEntry(XMLStreamWriter writer, String entry, RewriteSystemModel rsm) throws XMLStreamException, MojoExecutionException {
        switch (entry) {
            case "rewriteURI": {
                writer.writeEmptyElement(CATALOG_NS, "rewriteURI");
                writer.writeAttribute("uriStartString", rsm.getUriStartPrefix());
                writer.writeAttribute("rewritePrefix", rsm.getRewritePrefix());
                break;
            }
            case "rewriteSystem": {
                writer.writeEmptyElement(CATALOG_NS, "rewriteSystem");
                writer.writeAttribute("systemIdStartString", rsm.getUriStartPrefix());
                writer.writeAttribute("rewritePrefix", rsm.getRewritePrefix());
                break;
            }
            case "public": {
                writer.writeEmptyElement(CATALOG_NS, "public");
                writer.writeAttribute("publicId", rsm.getUriStartPrefix());
                writer.writeAttribute("uri", rsm.getRewritePrefix());
                break;
            }
            case "system": {
                writer.writeEmptyElement(CATALOG_NS, "system");
                writer.writeAttribute("name", rsm.getUriStartPrefix());
                writer.writeAttribute("uri", rsm.getRewritePrefix());
                break;
            }
            case "uri": {
                writer.writeEmptyElement(CATALOG_NS, "uri");
                writer.writeAttribute("name", rsm.getUriStartPrefix());
                writer.writeAttribute("uri", rsm.getRewritePrefix());
                break;
            }
            default: {
                throw new MojoExecutionException("Illegal value for generate: " + entry);
            }
        }
    }

    private ArtifactFilter buildArtifactFilter() {
        return new ArtifactFilter(){

            public boolean include(Artifact artfct) {
                return true;
            }
        };
    }

    private boolean isInJarWithDependencies(DependencyNode dn) {
        this.getLog().debug((CharSequence)("[catalog]  looking for parentry of " + dn.getArtifact().toString()));
        String classifier = dn.getArtifact().getClassifier();
        this.getLog().debug((CharSequence)("[catalog] classifier=" + classifier));
        if (classifier != null && Arrays.binarySearch(ACCEPTABLE_JAR_WITH_DEPENDENCIES_CLASSIFIERS, classifier) >= 0) {
            this.getLog().debug((CharSequence)"[catalog]  return true");
            return true;
        }
        if (dn.getParent() == null) {
            this.getLog().debug((CharSequence)"[catalog] no parent, return false");
            return false;
        }
        return this.isInJarWithDependencies(dn.getParent());
    }

    private String getJarFileForJarWithDependency(DependencyNode dn, List<String> classpthElements) throws OverConstrainedVersionException {
        if (dn == null) {
            return null;
        }
        String lastFound = null;
        block0: for (DependencyNode currentDn = dn; currentDn != null; currentDn = currentDn.getParent()) {
            String classifier = currentDn.getArtifact().getClassifier();
            if (classifier != null && Arrays.binarySearch(ACCEPTABLE_JAR_WITH_DEPENDENCIES_CLASSIFIERS, classifier) < 0) continue;
            String artifactPath = this.constructArtifactPath(currentDn.getArtifact());
            for (String s : classpthElements) {
                if (!s.contains(artifactPath)) continue;
                lastFound = s;
                continue block0;
            }
        }
        return lastFound;
    }

    private String constructArtifactPath(Artifact art) throws OverConstrainedVersionException {
        Object[] groups = art.getGroupId().split("\\.");
        this.getLog().debug((CharSequence)("[catalog] groups=" + Arrays.toString(groups)));
        Object[] artifacts = art.getArtifactId().split("\\.");
        this.getLog().debug((CharSequence)("[catalog] artifacts=" + Arrays.toString(artifacts)));
        String[] elements = new String[groups.length + artifacts.length + 1];
        System.arraycopy(groups, 0, elements, 0, groups.length);
        System.arraycopy(artifacts, 0, elements, groups.length, artifacts.length);
        this.getLog().debug((CharSequence)("[catalog] artifact.baseVersion=" + art.getBaseVersion()));
        elements[elements.length - 1] = art.getBaseVersion();
        return Arrays.stream(elements).filter(element -> element != null && !element.isEmpty()).collect(Collectors.joining(File.separator));
    }

    void setUriPatterns(List<String> uriPatterns) {
        this.uriPatterns = uriPatterns;
    }

    private class MyArtifact {
        private final String groupId;
        private final String artifactId;
        private final String version;

        public MyArtifact(String groupId, String artifactId, String version) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return String.format("artifact[%s,%s,%s]", this.groupId, this.artifactId, this.version);
        }
    }
}

